/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.packageRequirements;

import com.jetbrains.python.packaging.PyPackageName;
import com.jetbrains.python.packaging.packageRequirements.PackageNode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J&\u0010\t\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/packaging/packageRequirements/TreeParser;", "", "<init>", "()V", "parseTree", "Lcom/jetbrains/python/packaging/packageRequirements/PackageNode;", "lines", "", "", "parseLevel", "Lcom/jetbrains/python/packaging/packageRequirements/TreeParser$ParseResult;", "startIndent", "", "index", "calculateIndentLevel", "line", "extractPackageName", "ParseResult", "Constants", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPythonPackageRequirementsTreeExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonPackageRequirementsTreeExtractor.kt\ncom/jetbrains/python/packaging/packageRequirements/TreeParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1834#2,4:84\n*S KotlinDebug\n*F\n+ 1 PythonPackageRequirementsTreeExtractor.kt\ncom/jetbrains/python/packaging/packageRequirements/TreeParser\n*L\n69#1:84,4\n*E\n"})
public final class TreeParser {
    @NotNull
    public static final Constants Constants = new Constants(null);
    @NotNull
    private static final Regex TREE_LINE_REGEX = new Regex("^[\\s\u2502|`]*[\u251c\u2514`|][-\u2500]+ ");
    private static final char SPACE_DELIMITER = ' ';
    private static final char VERSION_DELIMITER = '[';

    @NotNull
    public final PackageNode parseTree(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        PackageNode node = this.parseLevel(lines, this.calculateIndentLevel((String)CollectionsKt.first(lines)), 0).component1();
        return node;
    }

    private final ParseResult parseLevel(List<String> lines, int startIndent, int index) {
        String line = lines.get(index);
        String name2 = this.extractPackageName(line);
        PackageNode node = new PackageNode(PyPackageName.Companion.from-P5OnQWY(name2), null, 2, null);
        int currentIndex = index + 1;
        while (currentIndex < lines.size() && this.calculateIndentLevel(lines.get(currentIndex)) > startIndent) {
            ParseResult result2 = this.parseLevel(lines, this.calculateIndentLevel(lines.get(currentIndex)), currentIndex);
            node.getChildren().add(result2.getNode());
            currentIndex = result2.getNextIndex();
        }
        return new ParseResult(node, currentIndex);
    }

    private final int calculateIndentLevel(String line) {
        int n;
        Object object = Regex.find$default((Regex)TREE_LINE_REGEX, (CharSequence)line, (int)0, (int)2, null);
        if (object == null || (object = object.getValue()) == null) {
            object = "";
        }
        Object indentMatch = object;
        Iterable $this$count$iv = StringsKt.chunked((CharSequence)((CharSequence)indentMatch), (int)4);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private final String extractPackageName(String line) {
        Object object = line;
        Regex regex = TREE_LINE_REGEX;
        String string = "";
        String clean = ((Object)StringsKt.trimStart((CharSequence)regex.replaceFirst((CharSequence)object, string))).toString();
        object = new char[1];
        object[0] = 32;
        return StringsKt.substringBefore$default((String)((String)StringsKt.split$default((CharSequence)clean, (char[])object, (boolean)false, (int)2, (int)2, null).get(0)), (char)'[', null, (int)2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/packaging/packageRequirements/TreeParser$Constants;", "", "<init>", "()V", "TREE_LINE_REGEX", "Lkotlin/text/Regex;", "SPACE_DELIMITER", "", "VERSION_DELIMITER", "intellij.python.community.impl"})
    public static final class Constants {
        private Constants() {
        }

        public /* synthetic */ Constants(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/packaging/packageRequirements/TreeParser$ParseResult;", "", "node", "Lcom/jetbrains/python/packaging/packageRequirements/PackageNode;", "nextIndex", "", "<init>", "(Lcom/jetbrains/python/packaging/packageRequirements/PackageNode;I)V", "getNode", "()Lcom/jetbrains/python/packaging/packageRequirements/PackageNode;", "getNextIndex", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.python.community.impl"})
    private static final class ParseResult {
        @NotNull
        private final PackageNode node;
        private final int nextIndex;

        public ParseResult(@NotNull PackageNode node, int nextIndex) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.nextIndex = nextIndex;
        }

        @NotNull
        public final PackageNode getNode() {
            return this.node;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        @NotNull
        public final PackageNode component1() {
            return this.node;
        }

        public final int component2() {
            return this.nextIndex;
        }

        @NotNull
        public final ParseResult copy(@NotNull PackageNode node, int nextIndex) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return new ParseResult(node, nextIndex);
        }

        public static /* synthetic */ ParseResult copy$default(ParseResult parseResult, PackageNode packageNode, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                packageNode = parseResult.node;
            }
            if ((n2 & 2) != 0) {
                n = parseResult.nextIndex;
            }
            return parseResult.copy(packageNode, n);
        }

        @NotNull
        public String toString() {
            return "ParseResult(node=" + this.node + ", nextIndex=" + this.nextIndex + ")";
        }

        public int hashCode() {
            int result2 = this.node.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.nextIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParseResult)) {
                return false;
            }
            ParseResult parseResult = (ParseResult)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)parseResult.node)) {
                return false;
            }
            return this.nextIndex == parseResult.nextIndex;
        }
    }
}

