/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce.parameter;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import com.jetbrains.python.refactoring.introduce.IntroduceHandler;
import com.jetbrains.python.refactoring.introduce.IntroduceOperation;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import com.jetbrains.python.refactoring.introduce.variable.VariableValidator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntroduceParameterHandler
extends IntroduceHandler {
    public PyIntroduceParameterHandler() {
        super((IntroduceValidator)new VariableValidator(), PyBundle.message("refactoring.extract.parameter.dialog.title", new Object[0]));
    }

    protected String getHelpId() {
        return "python.reference.introduceParameter";
    }

    @Nullable
    protected PsiElement addDeclaration(@NotNull PsiElement expression, @NotNull PsiElement declaration, @NotNull IntroduceOperation operation) {
        if (expression == null) {
            PyIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            PyIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        if (operation == null) {
            PyIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        return this.doIntroduceParameter(expression, (PyAssignmentStatement)declaration);
    }

    public PsiElement doIntroduceParameter(PsiElement expression, PyAssignmentStatement declaration) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
        if (function != null && declaration != null) {
            PyParameterList parameterList = function.getParameterList();
            parameterList.addParameter(PyElementGenerator.getInstance((Project)function.getProject()).createParameter(declaration.getText()));
            CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function);
            return parameterList.findParameterByName(declaration.getTargets()[0].getText());
        }
        return null;
    }

    @Nullable
    protected PsiElement replaceExpression(PsiElement expression, PyExpression newExpression, IntroduceOperation operation) {
        return PyReplaceExpressionUtil.replaceExpression((PsiElement)expression, (PsiElement)newExpression);
    }

    protected boolean isValidIntroduceContext(PsiElement element2) {
        if (element2 != null) {
            if (!PyIntroduceParameterHandler.isValidPlace(element2)) {
                return false;
            }
            return PyIntroduceParameterHandler.isNotDeclared(element2);
        }
        return false;
    }

    private static boolean isNotDeclared(PsiElement element2) {
        final ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)element2);
        final boolean[] isValid = new boolean[]{true};
        if (scopeOwner != null) {
            String name2;
            String string = name2 = element2 instanceof PsiNamedElement ? ((PsiNamedElement)element2).getName() : element2.getText();
            if (name2 != null && ControlFlowCache.getScope((ScopeOwner)scopeOwner).containsDeclaration(name2)) {
                return false;
            }
            new PyRecursiveElementVisitor(){

                public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitPyReferenceExpression(node);
                    String name2 = node.getName();
                    if (name2 != null && ControlFlowCache.getScope((ScopeOwner)scopeOwner).containsDeclaration(name2)) {
                        isValid[0] = false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/introduce/parameter/PyIntroduceParameterHandler$1", "visitPyReferenceExpression"));
                }
            }.visitElement(element2);
        }
        return !PyIntroduceParameterHandler.isResolvedToParameter(element2) && isValid[0];
    }

    private static boolean isValidPlace(PsiElement element2) {
        PyExpression target;
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, PyFunction.class);
        PyForPart forPart = (PyForPart)PsiTreeUtil.getParentOfType((PsiElement)element2, PyForPart.class);
        if (forPart != null && (target = forPart.getTarget()) instanceof PyTargetExpression && element2.getText().equals(target.getName())) {
            return false;
        }
        PyStatement nonlocalStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{PyNonlocalStatement.class, PyGlobalStatement.class});
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)element2, PyStatementList.class);
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, PyImportStatement.class);
        return nonlocalStatement == null && importStatement == null && statementList != null && function != null;
    }

    private static boolean isResolvedToParameter(PsiElement element2) {
        while (element2 instanceof PyReferenceExpression) {
            PyReferenceExpression ref = (PyReferenceExpression)element2;
            if (ref.getReference().resolve() instanceof PyNamedParameter) {
                return true;
            }
            element2 = ref.getQualifier();
        }
        return false;
    }

    protected void performInplaceIntroduce(IntroduceOperation operation) {
        PsiElement statement = this.performRefactoring(operation);
        if (statement instanceof PyNamedParameter) {
            List occurrences = operation.getOccurrences();
            PsiElement occurrence = PyIntroduceParameterHandler.findOccurrenceUnderCaret((List)occurrences, (Editor)operation.getEditor());
            PsiElement elementForCaret = occurrence != null ? occurrence : statement;
            operation.getEditor().getCaretModel().moveToOffset(elementForCaret.getTextRange().getStartOffset());
            PyInplaceParameterIntroducer introducer = new PyInplaceParameterIntroducer((PyNamedParameter)statement, operation, occurrences);
            introducer.performInplaceRefactoring(new LinkedHashSet(operation.getSuggestedNames()));
        }
    }

    protected String getRefactoringId() {
        return "refactoring.python.introduce.parameter";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "declaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "operation";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/refactoring/introduce/parameter/PyIntroduceParameterHandler";
        objectArray[2] = "addDeclaration";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PyInplaceParameterIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        private final PyNamedParameter myTarget;

        PyInplaceParameterIntroducer(PyNamedParameter target, IntroduceOperation operation, List<PsiElement> occurrences) {
            super((PsiNamedElement)target, operation.getEditor(), operation.getProject(), PyBundle.message("refactoring.introduce.parameter.dialog.title", new Object[0]), occurrences.toArray(PsiElement.EMPTY_ARRAY), null);
            this.myTarget = target;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }
    }
}

