/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move.moduleMembers;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyNamespacePackageUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.move.PyMoveRefactoringUtil;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveSymbolProcessor;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveSymbolResult;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyMoveModuleMembersProcessor
extends BaseRefactoringProcessor {
    private final List<SmartPsiElementPointer<PsiNamedElement>> myElements;
    private final LinkedHashSet<PsiFile> mySourceFiles;
    private final String myDestination;

    public PyMoveModuleMembersProcessor(PsiNamedElement @NotNull [] elements, @NotNull String destination) {
        if (destination == null) {
            PyMoveModuleMembersProcessor.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PyMoveModuleMembersProcessor.$$$reportNull$$$0(1);
        }
        super(elements[0].getProject());
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myElements = ContainerUtil.map((Object[])elements, arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0));
        this.mySourceFiles = new LinkedHashSet(ContainerUtil.map((Object[])elements, PsiElement::getContainingFile));
        this.myDestination = destination;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyMoveModuleMembersProcessor.$$$reportNull$$$0(2);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = ContainerUtil.mapNotNull(PyMoveModuleMembersProcessor.this.myElements, SmartPsiElementPointer::getElement).toArray(PsiElement.EMPTY_ARRAY);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PyMoveModuleMembersProcessor.getRefactoringName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = (UsageInfo[])StreamEx.of(this.myElements).map(SmartPsiElementPointer::getElement).nonNull().flatMap(e -> StreamEx.of((Collection)PyPsiIndexUtil.findUsages((PsiNamedElement)e, (boolean)false)).map(info -> new MyUsageInfo((UsageInfo)info, (PsiElement)e))).toArray(UsageInfo[]::new);
        if (usageInfoArray == null) {
            PyMoveModuleMembersProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyMoveModuleMembersProcessor.$$$reportNull$$$0(4);
        }
        MultiMap usagesByElement = MultiMap.create();
        for (UsageInfo usage : usages) {
            usagesByElement.putValue((Object)((MyUsageInfo)usage).myMovedElement, (Object)usage);
        }
        boolean isNamespace = ContainerUtil.all(this.mySourceFiles, PyNamespacePackageUtil::isInNamespacePackage);
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            PyFile destination = PyClassRefactoringUtil.getOrCreateFile((String)this.myDestination, (Project)this.myProject, (boolean)isNamespace);
            CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)destination);
            LinkedHashSet optimizeImportsTargets = Sets.newLinkedHashSet(this.mySourceFiles);
            for (SmartPsiElementPointer<PsiNamedElement> pointer : this.myElements) {
                PsiNamedElement e = (PsiNamedElement)pointer.getElement();
                if (e == null) continue;
                CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)e);
                assert (e instanceof PyClass || e instanceof PyFunction || e instanceof PyTargetExpression);
                String name2 = e.getName();
                if (name2 == null) continue;
                if (e instanceof PyClass && destination.findTopLevelClass(name2) != null) {
                    throw new IncorrectOperationException(PyBundle.message("refactoring.move.error.destination.file.contains.class", name2));
                }
                if (e instanceof PyFunction && destination.findTopLevelFunction(name2) != null) {
                    throw new IncorrectOperationException(PyBundle.message("refactoring.move.error.destination.file.contains.function", name2));
                }
                if (e instanceof PyTargetExpression && destination.findTopLevelAttribute(name2) != null) {
                    throw new IncorrectOperationException(PyBundle.message("refactoring.move.error.destination.file.contains.global.variable", name2));
                }
                Collection usageInfos = usagesByElement.get((Object)e);
                boolean usedFromOutside = ContainerUtil.exists((Iterable)usageInfos, usageInfo -> {
                    PsiElement element2 = usageInfo.getElement();
                    return element2 != null && !PsiTreeUtil.isAncestor((PsiElement)e, (PsiElement)element2, (boolean)false);
                });
                if (usedFromOutside) {
                    PyMoveRefactoringUtil.checkValidImportableFile((PsiElement)e, destination.getVirtualFile());
                }
                PyMoveSymbolResult results = new PyMoveSymbolProcessor(e, destination, usageInfos, this.myElements).moveElement();
                optimizeImportsTargets.addAll(results.getOptimizeImportsTargets());
            }
            for (PsiFile file : optimizeImportsTargets) {
                PyClassRefactoringUtil.optimizeImports((PsiFile)file);
            }
        }), PyMoveModuleMembersProcessor.getRefactoringName(), null);
    }

    @NotNull
    protected String getCommandName() {
        String string = PyMoveModuleMembersProcessor.getRefactoringName();
        if (string == null) {
            PyMoveModuleMembersProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    public static String getRefactoringName() {
        return PyBundle.message("refactoring.move.module.members", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static class MyUsageInfo
    extends UsageInfo {
        private final PsiElement myMovedElement;

        MyUsageInfo(@NotNull UsageInfo usageInfo, @NotNull PsiElement element2) {
            if (usageInfo == null) {
                MyUsageInfo.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                MyUsageInfo.$$$reportNull$$$0(1);
            }
            super(usageInfo.getSmartPointer(), usageInfo.getPsiFileRange(), usageInfo.isDynamicUsage(), usageInfo.isNonCodeUsage, usageInfo.getReferenceClass());
            this.myMovedElement = element2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "usageInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/refactoring/move/moduleMembers/PyMoveModuleMembersProcessor$MyUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

