/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonConsoleScripts;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.ScriptBuilder;
import com.jetbrains.python.run.StringLiteralTargetFunctionWrapper;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001ak\u0010\u0004\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\b0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\b0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\b0\rH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0003\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a8\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u0007*\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u0007H\u0007\u00a8\u0006\u0013"}, d2={"buildScriptWithConsoleRun", "", "config", "Lcom/jetbrains/python/run/PythonRunConfiguration;", "buildScriptFunctionWithConsoleRun", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "T", "stringBuilderConstructor", "Lkotlin/Function0;", "Lcom/jetbrains/python/run/ScriptBuilder;", "t", "Lkotlin/Function1;", "toTargetPath", "toStringLiteral", "(Lcom/jetbrains/python/run/PythonRunConfiguration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "escape", "s", "intellij.python.community.impl"})
@JvmName(name="PythonConsoleScripts")
public final class PythonConsoleScripts {
    @NotNull
    public static final String buildScriptWithConsoleRun(@NotNull PythonRunConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Project project = config.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Sdk sdk2 = config.getSdk();
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project2).getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"getPythonConsoleSettings(...)");
        PyRemotePathMapper pathMapper = PydevConsoleRunnerUtil.getPathMapper(project2, sdk2, pyConsoleSettings);
        return (String)PythonConsoleScripts.buildScriptFunctionWithConsoleRun(config, buildScriptWithConsoleRun.1.INSTANCE, PythonConsoleScripts::buildScriptWithConsoleRun$lambda$0, arg_0 -> PythonConsoleScripts.buildScriptWithConsoleRun$lambda$1(pathMapper, arg_0), buildScriptWithConsoleRun.4.INSTANCE);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Function<TargetEnvironment, String> buildScriptFunctionWithConsoleRun(@NotNull PythonRunConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (Function)PythonConsoleScripts.buildScriptFunctionWithConsoleRun(config, buildScriptFunctionWithConsoleRun.1.INSTANCE, buildScriptFunctionWithConsoleRun.2.INSTANCE, PythonConsoleScripts::buildScriptFunctionWithConsoleRun$lambda$0, buildScriptFunctionWithConsoleRun.4.INSTANCE);
    }

    private static final <T> T buildScriptFunctionWithConsoleRun(PythonRunConfiguration config, Function0<? extends ScriptBuilder<T>> stringBuilderConstructor, Function1<? super String, ? extends T> t, Function1<? super String, ? extends T> toTargetPath, Function1<? super T, ? extends T> toStringLiteral) {
        ScriptBuilder scriptBuilder = (ScriptBuilder)stringBuilderConstructor.invoke();
        Map map2 = config.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvs(...)");
        Map configEnvs = map2;
        configEnvs.remove("PYTHONUNBUFFERED");
        if (!configEnvs.isEmpty()) {
            scriptBuilder.append(t.invoke((Object)"import os\n"));
            for (Map.Entry entry : configEnvs.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Intrinsics.checkNotNull((Object)key);
                String string = PythonConsoleScripts.toStringLiteral(key);
                Intrinsics.checkNotNull((Object)value);
                scriptBuilder.append(t.invoke((Object)("os.environ[" + string + "] = " + PythonConsoleScripts.toStringLiteral(value) + "\n")));
            }
        }
        String string = PythonScriptCommandLineState.getExpandedScriptName(config);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpandedScriptName(...)");
        String scriptPath = string;
        String workingDir = config.getWorkingDirectory();
        scriptBuilder.append(t.invoke((Object)"runfile("));
        scriptBuilder.append(toStringLiteral.invoke(toTargetPath.invoke((Object)scriptPath)));
        List list = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)config.getScriptParameters());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"expandMacrosAndParseParameters(...)");
        List scriptParameters = list;
        if (scriptParameters.size() != 0) {
            scriptBuilder.append(t.invoke((Object)(", args=[" + CollectionsKt.joinToString$default((Iterable)scriptParameters, (CharSequence)", ", null, null, (int)0, null, (Function1)buildScriptFunctionWithConsoleRun.5.INSTANCE, (int)30, null) + "]")));
        }
        Intrinsics.checkNotNull((Object)workingDir);
        if (!(((CharSequence)workingDir).length() == 0)) {
            scriptBuilder.append(t.invoke((Object)", wdir="));
            String string2 = PythonScriptCommandLineState.getExpandedWorkingDir(config);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExpandedWorkingDir(...)");
            scriptBuilder.append(toStringLiteral.invoke(toTargetPath.invoke((Object)string2)));
        }
        if (config.isModuleMode()) {
            scriptBuilder.append(t.invoke((Object)", is_module=True"));
        }
        scriptBuilder.append(t.invoke((Object)")"));
        return scriptBuilder.build();
    }

    @Contract(pure=true)
    private static final String escape(String s) {
        String string = StringUtil.escapeCharCharacters((String)s);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static final String toStringLiteral(@NotNull String $this$toStringLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringLiteral, (String)"<this>");
        return "'" + PythonConsoleScripts.escape($this$toStringLiteral) + "'";
    }

    @Contract(pure=true)
    @NotNull
    public static final Function<TargetEnvironment, String> toStringLiteral(@NotNull Function<TargetEnvironment, String> $this$toStringLiteral) {
        Intrinsics.checkNotNullParameter($this$toStringLiteral, (String)"<this>");
        return (Function)((Object)new StringLiteralTargetFunctionWrapper($this$toStringLiteral));
    }

    private static final String buildScriptWithConsoleRun$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String buildScriptWithConsoleRun$lambda$1(PyRemotePathMapper $pathMapper, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = $pathMapper;
        if (object == null || (object = ((PyRemotePathMapper)object).convertToRemote(it)) == null) {
            object = it;
        }
        return object;
    }

    private static final Function buildScriptFunctionWithConsoleRun$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path2 = Path.of(it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return TargetEnvironmentFunctions.targetPath((Path)path2);
    }
}

