/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.targetWithVfs.TargetWithMappedLocalVfs;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0003\u0014\u0015\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/openapi/project/Project;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "pyRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "targetEnvRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetEnvRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "StateFile", "RootInfo", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyTargetsRemoteSourcesRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTargetsRemoteSourcesRefresher.kt\ncom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,211:1\n1#2:212\n1#2:230\n1#2:250\n10574#3:213\n11007#3,5:214\n1642#4,10:219\n1915#4:229\n1916#4:231\n1652#4:232\n1915#4,2:233\n1915#4,2:235\n1642#4,10:239\n1915#4:249\n1916#4:251\n1652#4:252\n1915#4,2:253\n221#5,2:237\n13#6:255\n*S KotlinDebug\n*F\n+ 1 PyTargetsRemoteSourcesRefresher.kt\ncom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher\n*L\n101#1:230\n185#1:250\n101#1:213\n101#1:214,5\n101#1:219,10\n101#1:229\n101#1:231\n101#1:232\n117#1:233,2\n123#1:235,2\n185#1:239,10\n185#1:249\n185#1:251\n185#1:252\n185#1:253,2\n145#1:237,2\n207#1:255\n*E\n"})
public final class PyTargetsRemoteSourcesRefresher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final Project project;
    @NotNull
    private final HelpersAwareTargetEnvironmentRequest pyRequest;
    @NotNull
    private static final Logger LOG;

    public PyTargetsRemoteSourcesRefresher(@NotNull Sdk sdk2, @NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.sdk = sdk2;
        this.project = project;
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonInterpreterTargetEnvironmentFactory.Companion.findPythonTargetInterpreter(this.sdk, this.project);
        if (helpersAwareTargetEnvironmentRequest == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.pyRequest = helpersAwareTargetEnvironmentRequest;
        boolean bl2 = bl = !(this.sdk instanceof Disposable) || !Disposer.isDisposed((Disposable)((Disposable)this.sdk));
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    private final TargetEnvironmentRequest getTargetEnvRequest() {
        return this.pyRequest.getTargetEnvironmentRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run(@NotNull ProgressIndicator indicator) throws ExecutionException {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        BufferedReader it;
        Object $this$forEach$iv2;
        Object it2;
        TargetWithMappedLocalVfs targetWithVfs;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path localRemoteSourcesRoot = Files.createDirectories(PySdkExtKt.getRemoteSourcesLocalPath(this.sdk), new FileAttribute[0]);
        Path localUploadDir = Files.createTempDirectory("remote_sync", new FileAttribute[0]);
        if (Files.getFileStore(localUploadDir).supportsFileAttributeView("posix")) {
            Intrinsics.checkNotNull((Object)localUploadDir);
            Path path2 = localUploadDir;
            Set<PosixFilePermission> set = PosixFilePermissions.fromString("rwxr-xr-x");
            Intrinsics.checkNotNullExpressionValue(set, (String)"fromString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions(path2, set), (String)"setPosixFilePermissions(...)");
        }
        Intrinsics.checkNotNull((Object)localUploadDir);
        TargetEnvironment.UploadRoot uploadVolume = new TargetEnvironment.UploadRoot(localUploadDir, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
        ((Collection)this.getTargetEnvRequest().getUploadVolumes()).add(uploadVolume);
        TargetEnvironment.DownloadRoot downloadVolume = new TargetEnvironment.DownloadRoot(localRemoteSourcesRoot, (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
        ((Collection)this.getTargetEnvRequest().getDownloadVolumes()).add(downloadVolume);
        PythonScripts.ensureProjectSdkAndModuleDirsAreOnTarget(this.pyRequest.getTargetEnvironmentRequest(), this.project, new Module[0]);
        PythonScriptExecution execution = PythonScripts.prepareHelperScriptExecution(PythonHelper.REMOTE_SYNC, this.pyRequest);
        Intrinsics.checkNotNull((Object)localRemoteSourcesRoot);
        Path path3 = localRemoteSourcesRoot.resolve(".state.json");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path stateFilePath = path3;
        FileTime stateFilePrevTimestamp = null;
        if (Files.exists(stateFilePath, new LinkOption[0])) {
            FileTime fileTime = Files.getLastModifiedTime(stateFilePath, new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            stateFilePrevTimestamp = fileTime;
            Path path4 = localUploadDir.resolve(".state.json");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Files.copy(stateFilePath, path4, new CopyOption[0]);
            execution.addParameter("--state-file");
            execution.addParameter(TargetEnvironmentFunctions.getRelativeTargetPath((Function)TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)uploadVolume), (String)".state.json"));
        } else {
            FileTime fileTime = FileTime.from(Instant.MIN);
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
            stateFilePrevTimestamp = fileTime;
        }
        execution.addParameter(TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)downloadVolume));
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = PySdkExtKt.getTargetEnvConfiguration(this.sdk);
        if (targetEnvironmentConfiguration != null) {
            TargetEnvironmentConfiguration it3 = targetEnvironmentConfiguration;
            boolean bl = false;
            v6 = PythonInterpreterTargetEnvironmentFactory.Companion.getTargetWithMappedLocalVfs(it3);
        } else {
            v6 = targetWithVfs = null;
        }
        if (targetWithVfs != null) {
            void $this$mapNotNullTo$iv$iv2;
            Iterator $this$mapNotNull$iv;
            Iterator element$iv$iv2;
            void $this$flatMapTo$iv$iv;
            Object $this$flatMap$iv = ProjectUtil.getModules((Project)this.project);
            boolean $i$f$flatMap = false;
            Module[] bl = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Iterator element$iv$iv2 : $this$flatMapTo$iv$iv) {
                void it4 = element$iv$iv2;
                boolean bl2 = false;
                VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)it4).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                Iterable list$iv$iv = ArraysKt.asList((Object[])virtualFileArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
                boolean bl3 = false;
                it2 = (VirtualFile)element$iv$iv3;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it2);
                if (targetWithVfs.getTargetPathFromVfs((VirtualFile)it2) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleRoots = (List)destination$iv$iv;
            if (!((Collection)moduleRoots).isEmpty()) {
                execution.addParameter("--project-roots");
                for (String root : moduleRoots) {
                    execution.addParameter(root);
                }
            }
        }
        TargetProgressIndicatorAdapter targetIndicator = new TargetProgressIndicatorAdapter(indicator);
        TargetEnvironment environment = this.getTargetEnvRequest().prepareEnvironment((TargetProgressIndicator)targetIndicator);
        try {
            Iterable $this$forEach$iv3 = environment.getUploadVolumes().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                TargetEnvironment.UploadableVolume it5 = (TargetEnvironment.UploadableVolume)element$iv;
                boolean bl = false;
                it5.upload(".", (TargetProgressIndicator)targetIndicator);
            }
            TargetedCommandLine cmd = PythonScripts.buildTargetedCommandLine$default(execution, environment, this.sdk, CollectionsKt.emptyList(), false, null, 24, null);
            PythonScripts.execute(cmd, environment, indicator);
            $this$forEach$iv2 = environment.getDownloadVolumes().values();
            boolean $i$f$forEach2 = false;
            Iterator element$iv = $this$forEach$iv2.iterator();
            while (element$iv.hasNext()) {
                Object element$iv2 = element$iv.next();
                TargetEnvironment.DownloadableVolume it6 = (TargetEnvironment.DownloadableVolume)element$iv2;
                boolean bl = false;
                it6.download(".", indicator);
            }
        }
        finally {
            environment.shutdown();
        }
        if (!Files.exists(stateFilePath, new LinkOption[0])) {
            throw new IllegalStateException(stateFilePath + " is missing");
        }
        if (Files.getLastModifiedTime(stateFilePath, new LinkOption[0]).compareTo(stateFilePrevTimestamp) <= 0) {
            throw new IllegalStateException(stateFilePath + " has not been updated");
        }
        Object stateFile = null;
        $this$forEach$iv2 = Files.newBufferedReader(stateFilePath);
        Iterator<String> $i$f$forEach2 = null;
        try {
            it = (BufferedReader)$this$forEach$iv2;
            boolean bl = false;
            Object object = new Gson().fromJson((Reader)it, StateFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            stateFile = object;
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            $i$f$forEach2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$this$forEach$iv2, (Throwable)((Object)$i$f$forEach2));
        }
        PathMappingSettings pathMappings = new PathMappingSettings();
        it = this.sdk.getSdkAdditionalData();
        PyTargetAwareAdditionalData pyTargetAwareAdditionalData = it instanceof PyTargetAwareAdditionalData ? (PyTargetAwareAdditionalData)((Object)it) : null;
        if (pyTargetAwareAdditionalData != null) {
            PyTargetAwareAdditionalData pyData = pyTargetAwareAdditionalData;
            boolean bl = false;
            Map $this$forEach$iv4 = MapsKt.plus(PyTargetAwareAdditionalData.Companion.getPathsAddedByUser(pyData), PyTargetAwareAdditionalData.Companion.getPathsRemovedByUser(pyData));
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv4.entrySet()) {
                it2 = element$iv;
                boolean bl6 = false;
                Path localPath = (Path)it2.getKey();
                String remotePath = (String)it2.getValue();
                pathMappings.add(new PathMappingSettings.PathMapping(((Object)localPath).toString(), remotePath));
            }
        }
        $i$f$forEach2 = ((StateFile)stateFile).getRoots().iterator();
        while ($i$f$forEach2.hasNext()) {
            Path rootZip;
            RootInfo root = (RootInfo)$i$f$forEach2.next();
            String remoteRootPath = root.getPath();
            String localRootName = String.valueOf(remoteRootPath.hashCode());
            Path path5 = localRemoteSourcesRoot.resolve(localRootName);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            Path localRoot = Files.createDirectories(path5, new FileAttribute[0]);
            pathMappings.addMappingCheckUnique(((Object)localRoot).toString(), remoteRootPath);
            Intrinsics.checkNotNullExpressionValue((Object)localRemoteSourcesRoot.resolve(root.getZipName()), (String)"resolve(...)");
            ZipUtil.extract((Path)rootZip, (Path)localRoot, null, (boolean)true);
            for (String invalidEntryRelPath : root.getInvalidEntries()) {
                Path localInvalidEntry;
                Intrinsics.checkNotNull((Object)localRoot);
                Path bl6 = localRoot;
                String string = PathUtil.toSystemDependentName((String)invalidEntryRelPath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)bl6.resolve(string), (String)"resolve(...)");
                LOG.debug("Removing the mapped file " + invalidEntryRelPath + " from " + remoteRootPath);
                PathKt.deleteWithParentsIfEmpty$default((Path)localInvalidEntry, (Path)localRemoteSourcesRoot, (boolean)false, (int)2, null);
            }
            Files.delete(rootZip);
        }
        if (targetWithVfs != null) {
            $i$f$forEach2 = ((StateFile)stateFile).getSkippedRoots().iterator();
            while ($i$f$forEach2.hasNext()) {
                String remoteRoot = $i$f$forEach2.next();
                Object object = targetWithVfs.getVfsFromTargetPath(remoteRoot);
                if (object == null || (object = object.getPath()) == null) continue;
                Object localPath = object;
                pathMappings.add(new PathMappingSettings.PathMapping((String)localPath, remoteRoot));
            }
        }
        Iterator<String> $this$run_u24lambda_u247 = $i$f$forEach2 = this.sdk.getSdkModificator();
        boolean bl = false;
        SdkAdditionalData localRootName = $this$run_u24lambda_u247.getSdkAdditionalData();
        RemoteSdkProperties remoteSdkProperties = localRootName instanceof RemoteSdkProperties ? (RemoteSdkProperties)localRootName : null;
        if (remoteSdkProperties != null) {
            remoteSdkProperties.setPathMappings(pathMappings);
        }
        Object it7 = ApplicationManager.getApplication();
        boolean bl7 = false;
        it7.invokeAndWait(() -> PyTargetsRemoteSourcesRefresher.run$lambda$7$0$0((Application)it7, $this$run_u24lambda_u247));
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fs = localFileSystem;
        List list = pathMappings.getPathMappings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathMappings(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        it7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl8 = false;
            PathMappingSettings.PathMapping it8 = (PathMappingSettings.PathMapping)element$iv$iv;
            boolean bl9 = false;
            if (fs.findFileByPath(it8.getLocalRoot()) == null) continue;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it9 = (VirtualFile)element$iv;
            boolean bl11 = false;
            it9.refresh(false, true);
        }
    }

    private static final void run$lambda$7$0$0$0(SdkModificator $this_apply) {
        $this_apply.commitChanges();
    }

    private static final void run$lambda$7$0$0(Application $it, SdkModificator $this_apply) {
        $it.runWriteAction(() -> PyTargetsRemoteSourcesRefresher.run$lambda$7$0$0$0($this_apply));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyTargetsRemoteSourcesRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0013\u001a\u00020\u0005H\u0096\u0080\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$RootInfo;", "", "<init>", "()V", "path", "", "getPath", "()Ljava/lang/String;", "setPath", "(Ljava/lang/String;)V", "zipName", "getZipName", "setZipName", "invalidEntries", "", "getInvalidEntries", "()Ljava/util/List;", "setInvalidEntries", "(Ljava/util/List;)V", "toString", "intellij.python.community.impl"})
    private static final class RootInfo {
        @NotNull
        private String path = "";
        @SerializedName(value="zip_name")
        @NotNull
        private String zipName = "";
        @SerializedName(value="invalid_entries")
        @NotNull
        private List<String> invalidEntries = CollectionsKt.emptyList();

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final String getZipName() {
            return this.zipName;
        }

        public final void setZipName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.zipName = string;
        }

        @NotNull
        public final List<String> getInvalidEntries() {
            return this.invalidEntries;
        }

        public final void setInvalidEntries(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.invalidEntries = list;
        }

        @NotNull
        public String toString() {
            return this.path;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$StateFile;", "", "<init>", "()V", "roots", "", "Lcom/jetbrains/python/sdk/PyTargetsRemoteSourcesRefresher$RootInfo;", "getRoots", "()Ljava/util/List;", "setRoots", "(Ljava/util/List;)V", "skippedRoots", "", "getSkippedRoots", "setSkippedRoots", "intellij.python.community.impl"})
    private static final class StateFile {
        @NotNull
        private List<RootInfo> roots = CollectionsKt.emptyList();
        @SerializedName(value="skipped_roots")
        @NotNull
        private List<String> skippedRoots = CollectionsKt.emptyList();

        @NotNull
        public final List<RootInfo> getRoots() {
            return this.roots;
        }

        public final void setRoots(@NotNull List<RootInfo> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.roots = list;
        }

        @NotNull
        public final List<String> getSkippedRoots() {
            return this.skippedRoots;
        }

        public final void setSkippedRoots(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.skippedRoots = list;
        }
    }
}

