/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetBasedSdks;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.reference.SoftReference;
import com.intellij.remote.ExceptionFix;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.parser.icons.PythonParserIcons;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.CustomSdkHomePattern;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyInvalidSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.target.PyDetectedSdkAdditionalData;
import com.jetbrains.python.target.PyInterpreterVersionUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.venvReader.VirtualEnvReaderKt;
import java.awt.Component;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.CoroutineScope;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PythonSdkType
extends SdkType {
    @ApiStatus.Internal
    @NotNull
    public static final Key<List<String>> MOCK_SYS_PATH_KEY = Key.create((String)"PY_MOCK_SYS_PATH_KEY");
    @ApiStatus.Internal
    @NotNull
    public static final Key<String> MOCK_PY_VERSION_KEY = Key.create((String)"PY_MOCK_PY_VERSION_KEY");
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> MOCK_PY_MARKER_KEY = Key.create((String)"MOCK_PY_MARKER_KEY");
    private static final Logger LOG = Logger.getInstance(PythonSdkType.class);
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");

    public static PythonSdkType getInstance() {
        return (PythonSdkType)PythonSdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonParserIcons.PythonFile;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.python";
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        Sdk[] existingSdks = (Sdk[])ReadAction.compute(() -> ProjectJdkTable.getInstance().getAllJdks());
        List<PyDetectedSdk> sdks = PySdkExtKt.detectSystemWideSdks(null, Arrays.asList(existingSdks));
        PyDetectedSdk latest = StreamEx.of(sdks).findFirst().orElse(null);
        if (latest != null) {
            Set<String> set = Collections.singleton(latest.getHomePath());
            if (set == null) {
                PythonSdkType.$$$reportNull$$$0(0);
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    public boolean isValidSdkHome(@NotNull String localPath) {
        if (localPath == null) {
            PythonSdkType.$$$reportNull$$$0(2);
        }
        try {
            return PythonSdkType.isLocalPathValid(Paths.get(localPath, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @ApiStatus.Internal
    private static boolean isLocalPathValid(@NotNull Path path2) {
        if (path2 == null) {
            PythonSdkType.$$$reportNull$$$0(3);
        }
        return PythonSdkFlavor.getFlavor((String)path2.toString()) != null;
    }

    @ApiStatus.Internal
    @RequiresBackgroundThread
    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        String string;
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertBackgroundThread();
        try {
            Path pythonPath = VirtualEnvReaderKt.VirtualEnvReader().findPythonInPythonRoot(Path.of(homePath, new String[0]));
            string = pythonPath != null ? pythonPath.toString() : homePath;
        }
        catch (InvalidPathException e) {
            String string2 = homePath;
            if (string2 == null) {
                PythonSdkType.$$$reportNull$$$0(6);
            }
            return string2;
        }
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0) {
                    final VirtualFile file = files[0];
                    record ValidationResult(boolean isValid, boolean isDirectory) {
                    }
                    ValidationResult result2 = (ValidationResult)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)ModalTaskOwner.guess(), (String)PyBundle.message("modal.progress.title.path.validation", new Object[0]), (TaskCancellation)TaskCancellation.cancellable(), (Function2)new Function2<CoroutineScope, Continuation<? super ValidationResult>, Object>(){

                        public ValidationResult invoke(CoroutineScope scope, Continuation<? super ValidationResult> continuation) {
                            try {
                                String adjustedPath = PythonSdkType.this.adjustSelectedSdkHome(file.getPath());
                                boolean isValid = PythonSdkType.isLocalPathValid(Path.of(adjustedPath, new String[0]));
                                return new ValidationResult(PythonSdkType.isLocatedInWsl(file) || isValid, file.isDirectory());
                            }
                            catch (InvalidPathException e) {
                                return new ValidationResult(false, false);
                            }
                        }
                    });
                    if (!result2.isValid()) {
                        String message = result2.isDirectory() ? PyBundle.message("python.sdk.error.invalid.venv.selected", file.getName()) : PyBundle.message("python.sdk.error.invalid.interpreter.selected", file.getName());
                        throw new Exception(message);
                    }
                }
            }

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                if (file == null) {
                    return false;
                }
                Path pythonPath = VirtualEnvReaderKt.VirtualEnvReader().findPythonInPythonRoot(file.toNioPath());
                return pythonPath != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/python/sdk/PythonSdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (SystemInfo.isMac) {
            descriptor.setForcedToUseIdeaFileChooser(true);
        }
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            PythonSdkType.$$$reportNull$$$0(7);
        }
        return fileChooserDescriptor;
    }

    @ApiStatus.Internal
    private static boolean isLocatedInWsl(@NotNull VirtualFile file) {
        if (file == null) {
            PythonSdkType.$$$reportNull$$$0(8);
        }
        return SystemInfo.isWindows && PythonSdkType.isCustomPythonSdkHomePath(file.getPath());
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    @ApiStatus.Internal
    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(9);
        }
        if (parentComponent == null) {
            PythonSdkType.$$$reportNull$$$0(10);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.$$$reportNull$$$0(11);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PyAddSdkDialog.show(project, null, sdk2 -> {
            sdk2.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
            sdkCreatedCallback.accept((Sdk)sdk2);
        });
    }

    @ApiStatus.Internal
    public static void patchCommandLineForVirtualenv(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk2) {
        if (commandLine == null) {
            PythonSdkType.$$$reportNull$$$0(12);
        }
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(13);
        }
        PythonSdkType.patchEnvironmentVariablesForVirtualenv(commandLine.getEnvironment(), sdk2);
    }

    public static void patchEnvironmentVariablesForVirtualenv(@NotNull Map<String, String> environment, @NotNull Sdk sdk2) {
        Map virtualEnv;
        if (environment == null) {
            PythonSdkType.$$$reportNull$$$0(14);
        }
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(15);
        }
        if (!(virtualEnv = PySdkUtil.activateVirtualEnv((Sdk)sdk2)).isEmpty()) {
            for (Map.Entry entry : virtualEnv.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (environment.containsKey(key)) {
                    if (!key.equalsIgnoreCase("PATH")) continue;
                    PythonEnvUtil.addToPathEnvVar((String)environment.get(key), (String)value, (boolean)false);
                    continue;
                }
                environment.put(key, value);
            }
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(16);
        }
        String name2 = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File virtualEnvRoot = PythonSdkUtil.getVirtualEnvRoot((String)sdkHome);
        if (virtualEnvRoot != null) {
            String path2 = FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath());
            String string = name2 + " " + path2;
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(18);
        }
        return string;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @ApiStatus.Internal
    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor flavor;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(19);
        }
        if ((flavor = PythonSdkFlavor.getFlavor((String)sdkHome)) == null) {
            return null;
        }
        return flavor.getName() + " " + String.valueOf(flavor.getLanguageLevel(sdkHome));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(20);
        }
        if (sdkModificator == null) {
            PythonSdkType.$$$reportNull$$$0(21);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.$$$reportNull$$$0(22);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(23);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        String homePath;
        if (currentSdk == null) {
            PythonSdkType.$$$reportNull$$$0(24);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(25);
        }
        if ((homePath = currentSdk.getHomePath()) != null) {
            if (additional.getAttributeBooleanValue("IS_DETECTED")) {
                PyDetectedSdkAdditionalData data2 = new PyDetectedSdkAdditionalData(null, null);
                data2.load(additional);
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = TargetBasedSdks.loadTargetConfiguration((Element)additional);
                if (targetEnvironmentConfiguration != null) {
                    data2.setTargetEnvironmentConfiguration(targetEnvironmentConfiguration);
                }
                return data2;
            }
            PyTargetAwareAdditionalData targetAdditionalData = PyTargetAwareAdditionalData.loadTargetAwareData(currentSdk, additional);
            if (targetAdditionalData != null) {
                return targetAdditionalData;
            }
            if (PythonSdkType.isCustomPythonSdkHomePath(homePath)) {
                LOG.warn("Pretarget SDK skipped " + homePath);
                return PyInvalidSdk.INSTANCE;
            }
        }
        SdkAdditionalData additionalData = PySdkProvider.EP_NAME.getExtensionList().stream().map(ext -> ext.loadAdditionalDataForSdk(additional)).filter(data -> data != null).findFirst().orElseGet(() -> PythonSdkAdditionalData.loadFromElement((Element)additional));
        return additionalData;
    }

    @Contract(pure=true)
    @VisibleForTesting
    @ApiStatus.Internal
    public static boolean isCustomPythonSdkHomePath(@NotNull String homePath) {
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(26);
        }
        return CustomSdkHomePattern.isCustomPythonSdkHomePath((String)homePath);
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        return "Python SDK";
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        VirtualFile sdkPath;
        String path2;
        PythonSdkFlavor flavor;
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(27);
        }
        if ((flavor = PythonSdkFlavor.getFlavor((String)(path2 = super.sdkPath(homePath)))) != null && (sdkPath = flavor.getSdkPath(homePath)) != null) {
            String string = FileUtil.toSystemDependentName((String)sdkPath.getPath());
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)path2);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(29);
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(30);
        }
        if (PlatformUtils.isFleetBackend()) {
            return;
        }
        WeakReference ownerComponentRef = (WeakReference)sdk2.getUserData(SDK_CREATOR_COMPONENT_KEY);
        Component ownerComponent = (Component)SoftReference.dereference((Reference)ownerComponentRef);
        AtomicReference<Project> projectRef = new AtomicReference<Project>();
        if (PlatformUtils.isQodana()) {
            Project project = (Project)ContainerUtil.getFirstItem(Arrays.asList(ProjectManager.getInstance().getOpenProjects()));
            projectRef.set(project);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (ownerComponent != null) {
                    projectRef.set((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)));
                } else {
                    projectRef.set((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()));
                }
            });
        }
        PythonSdkUpdater.updateOrShowError(sdk2, (Project)projectRef.get(), ownerComponent);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk2, @NotNull SdkModel sdkModel) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(31);
        }
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(32);
        }
        return true;
    }

    @ApiStatus.Internal
    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e, @Nullable Runnable restartAction) {
        String notificationMessage;
        NotificationListener notificationListener;
        if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
            ExceptionFix fix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e, ExceptionFix.class);
            notificationListener = (notification2, event) -> {
                fix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = fix.getNotificationMessage(e.getMessage());
        } else {
            notificationListener = null;
            notificationMessage = e.getMessage();
        }
        Notification notification3 = new Notification("Python SDK Updater", PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), notificationMessage, NotificationType.WARNING).setDisplayId("refresh.skeletons.for.remote.interpreter.failed");
        if (notificationListener != null) {
            notification3.setListener(notificationListener);
        }
        notification3.notify(null);
    }

    @ApiStatus.Internal
    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path2) {
        VirtualFile jar;
        String suffix;
        if (path2 == null) {
            PythonSdkType.$$$reportNull$$$0(33);
        }
        if ((suffix = path2.getExtension()) != null) {
            suffix = StringUtil.toLowerCase((String)suffix);
        }
        if (!path2.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path2)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                PythonSdkType.$$$reportNull$$$0(34);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path2;
        if (virtualFile == null) {
            PythonSdkType.$$$reportNull$$$0(35);
        }
        return virtualFile;
    }

    public String getVersionString(@NotNull Sdk sdk2) {
        String version2;
        SdkAdditionalData sdkAdditionalData;
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(36);
        }
        if ((sdkAdditionalData = sdk2.getSdkAdditionalData()) instanceof PyTargetAwareAdditionalData) {
            String versionString;
            try {
                versionString = PyInterpreterVersionUtil.getInterpreterVersionForJava((PyTargetAwareAdditionalData)sdkAdditionalData).toPythonVersion();
            }
            catch (Exception e) {
                versionString = "undefined";
            }
            return versionString;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (version2 = (String)sdk2.getUserData(MOCK_PY_VERSION_KEY)) != null) {
            return version2;
        }
        String homePath = sdk2.getHomePath();
        return homePath == null ? null : this.getVersionString(homePath);
    }

    @Nullable
    public String getVersionString(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(37);
        }
        if (PythonSdkType.isCustomPythonSdkHomePath(sdkHome)) {
            return null;
        }
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor((String)sdkHome);
        return flavor != null ? PythonSdkFlavor.getVersionStringStatic((String)sdkHome) : null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type2) {
        if (type2 == null) {
            PythonSdkType.$$$reportNull$$$0(38);
        }
        return type2 == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(39);
        }
        if (PythonSdkUtil.isRemote((Sdk)sdk2)) {
            return true;
        }
        VirtualFile homeDir = sdk2.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    @ApiStatus.Internal
    public static boolean isRunAsRootViaSudo(@NotNull Sdk sdk2) {
        PyTargetAwareAdditionalData pyTargetAwareAdditionalData;
        SdkAdditionalData data;
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(40);
        }
        return (data = sdk2.getSdkAdditionalData()) instanceof PyTargetAwareAdditionalData && (pyTargetAwareAdditionalData = (PyTargetAwareAdditionalData)data).isRunAsRootViaSudo();
    }

    @ApiStatus.Internal
    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(41);
        }
        String string = sdk2.getName();
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(42);
        }
        return string;
    }

    public boolean isLocalSdk(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(43);
        }
        return !PythonSdkUtil.isRemote((Sdk)sdk2);
    }

    @ApiStatus.Internal
    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module2) {
        Sdk moduleSDK = PythonSdkUtil.findPythonSdk((Module)module2);
        return PythonSdkType.findLocalCPythonForSdk(moduleSDK);
    }

    @ApiStatus.Internal
    @Nullable
    public static Sdk findLocalCPythonForSdk(@Nullable Sdk existingSdk) {
        if (existingSdk != null && !PythonSdkUtil.isRemote((Sdk)existingSdk) && PythonSdkFlavor.getFlavor((Sdk)existingSdk) instanceof CPythonSdkFlavor) {
            return existingSdk;
        }
        for (Sdk sdk2 : ContainerUtil.sorted((Collection)PythonSdkUtil.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkUtil.isRemote((Sdk)sdk2)) continue;
            return sdk2;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk2) {
        LanguageLevel languageLevel = PySdkUtil.getLanguageLevelForSdk((Sdk)sdk2);
        if (languageLevel == null) {
            PythonSdkType.$$$reportNull$$$0(44);
        }
        return languageLevel;
    }

    public boolean allowWslSdkForLocalProject() {
        return true;
    }

    @ApiStatus.Internal
    public static boolean isMock(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(45);
        }
        return sdk2.getUserData(MOCK_PY_VERSION_KEY) != null || sdk2.getUserData(MOCK_SYS_PATH_KEY) != null || sdk2.getUserData(MOCK_PY_MARKER_KEY) != null;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<String> getMockPath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(46);
        }
        String workDir = Paths.get(Objects.requireNonNull(sdk2.getHomePath()), new String[0]).getParent().toString();
        List mockPaths = (List)sdk2.getUserData(MOCK_SYS_PATH_KEY);
        List<Object> list = mockPaths != null ? Collections.unmodifiableList(mockPaths) : Collections.singletonList(workDir);
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(47);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 26, 27, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 43, 45, 46 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: 
            case 15: 
            case 30: 
            case 31: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 16: 
            case 19: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLocalPathValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLocatedInWsl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineForVirtualenv";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchEnvironmentVariablesForVirtualenv";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCustomPythonSdkHomePath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsRootViaSudo";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isMock";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getMockPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 26, 27, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 43, 45, 46 -> new IllegalArgumentException(string);
        };
    }
}

