/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.ModuleTransferredRoots;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/sdk/TransferredRootsDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectModules", "", "Lcom/intellij/openapi/module/Module;", "getProjectModules", "()Ljava/util/List;", "moduleToContentRoots", "Lcom/google/common/collect/SetMultimap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleToContentRoots", "()Lcom/google/common/collect/SetMultimap;", "moduleToSourceRoots", "getModuleToSourceRoots", "detect", "Lcom/jetbrains/python/sdk/ModuleTransferredRoots;", "module", "newPaths", "", "oldPaths", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyTransferredSdkRoots.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTransferredSdkRoots.kt\ncom/jetbrains/python/sdk/TransferredRootsDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n777#2:220\n873#2,2:221\n2045#2,14:223\n*S KotlinDebug\n*F\n+ 1 PyTransferredSdkRoots.kt\ncom/jetbrains/python/sdk/TransferredRootsDetector\n*L\n201#1:220\n201#1:221,2\n203#1:223,14\n*E\n"})
final class TransferredRootsDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> projectModules;
    @NotNull
    private final SetMultimap<Module, VirtualFile> moduleToContentRoots;
    @NotNull
    private final SetMultimap<Module, VirtualFile> moduleToSourceRoots;

    public TransferredRootsDetector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projectModules = ArraysKt.toList((Object[])((Object[])ActionsKt.runReadAction(() -> TransferredRootsDetector.projectModules$lambda$0(this))));
        SetMultimap setMultimap = MultimapBuilder.hashKeys().hashSetValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)setMultimap, (String)"build(...)");
        this.moduleToContentRoots = setMultimap;
        SetMultimap setMultimap2 = MultimapBuilder.hashKeys().hashSetValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)setMultimap2, (String)"build(...)");
        this.moduleToSourceRoots = setMultimap2;
        for (Module mod : this.projectModules) {
            ModuleRootManager moduleRootManager;
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)mod), (String)"getInstance(...)");
            VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            this.moduleToContentRoots.putAll((Object)mod, (Iterable)ArraysKt.toList((Object[])virtualFileArray));
            VirtualFile[] virtualFileArray2 = moduleRootManager.getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getSourceRoots(...)");
            this.moduleToSourceRoots.putAll((Object)mod, (Iterable)ArraysKt.toList((Object[])virtualFileArray2));
        }
    }

    @NotNull
    public final List<Module> getProjectModules() {
        return this.projectModules;
    }

    @NotNull
    public final SetMultimap<Module, VirtualFile> getModuleToContentRoots() {
        return this.moduleToContentRoots;
    }

    @NotNull
    public final SetMultimap<Module, VirtualFile> getModuleToSourceRoots() {
        return this.moduleToSourceRoots;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ModuleTransferredRoots detect(@NotNull Module module2, @NotNull Set<? extends VirtualFile> newPaths, @NotNull Set<? extends VirtualFile> oldPaths) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(newPaths, (String)"newPaths");
        Intrinsics.checkNotNullParameter(oldPaths, (String)"oldPaths");
        LinkedHashSet<VirtualFile> sourceRoots = new LinkedHashSet<VirtualFile>();
        LinkedHashSet<Module> dependencies = new LinkedHashSet<Module>();
        Set set = this.moduleToSourceRoots.get((Object)module2);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"get(...)");
        Set manuallyMarkedModuleSourceRoots = SetsKt.minus((Set)set, (Iterable)oldPaths);
        Set set2 = this.moduleToContentRoots.get((Object)module2);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"get(...)");
        Set moduleContentRoots = set2;
        for (VirtualFile virtualFile : newPaths) {
            Map.Entry entry;
            Module moduleForPath;
            Object v3;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set set3 = this.moduleToContentRoots.entries();
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"entries(...)");
            Iterable iterable = set3;
            boolean $i$f$filter = false;
            void var14_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!VfsUtil.isAncestor((VirtualFile)((VirtualFile)it.getValue()), (VirtualFile)virtualFile, (boolean)false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    Map.Entry it = (Map.Entry)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = ((VirtualFile)it.getValue()).getPath().length();
                    do {
                        Object e$iv = iterator$iv.next();
                        Map.Entry it2 = (Map.Entry)e$iv;
                        boolean bl2 = false;
                        int v$iv = ((VirtualFile)it2.getValue()).getPath().length();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            if ((moduleForPath = (entry = (Map.Entry)v3) != null ? (Module)entry.getKey() : null) == null) continue;
            if (Intrinsics.areEqual((Object)moduleForPath, (Object)module2)) {
                if (moduleContentRoots.contains(virtualFile) || manuallyMarkedModuleSourceRoots.contains(virtualFile)) continue;
                sourceRoots.add(virtualFile);
                continue;
            }
            if (!Intrinsics.areEqual((Object)virtualFile, (Object)BasePySdkExtKt.getBaseDir((Module)moduleForPath)) || !Registry.Companion.is("python.detect.cross.module.dependencies")) continue;
            dependencies.add(moduleForPath);
        }
        return new ModuleTransferredRoots((Set<? extends VirtualFile>)sourceRoots, (Set<? extends Module>)dependencies);
    }

    private static final Module[] projectModules$lambda$0(TransferredRootsDetector this$0) {
        return ModuleManager.Companion.getInstance(this$0.project).getModules();
    }
}

