/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.venvReader.VirtualEnvReaderKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class UnixPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final String[] BIN_DIRECTORIES = new String[]{"/usr/bin", "/usr/local/bin"};
    private static final Set<Pattern> SYS_PYTHON_FILE_NAMES = Sets.newHashSet((Object[])new Pattern[]{Pattern.compile("pypy$"), Pattern.compile("python3(\\.[0-9]+)?$")});

    private UnixPythonSdkFlavor() {
    }

    public static UnixPythonSdkFlavor getInstance() {
        return (UnixPythonSdkFlavor)((Object)EP_NAME.findExtension(UnixPythonSdkFlavor.class));
    }

    public boolean isApplicable() {
        return SystemInfo.isUnix && !SystemInfo.isMac;
    }

    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    protected @NotNull Collection<@NotNull Path> suggestLocalHomePathsImpl(@Nullable Module module2, @Nullable UserDataHolder context) {
        return UnixPythonSdkFlavor.getDefaultUnixPythons();
    }

    @NotNull
    public static List<Path> getDefaultUnixPythons() {
        return UnixPythonSdkFlavor.getDefaultUnixPythons(null);
    }

    @NotNull
    public static List<Path> getDefaultUnixPythons(@Nullable Path rootPath) {
        ArrayList<Path> candidates = new ArrayList<Path>();
        Arrays.stream(BIN_DIRECTORIES).map(x$0 -> Path.of(x$0, new String[0])).map(binDirectory -> UnixPythonSdkFlavor.optionallyChangeRoot(rootPath, binDirectory)).forEach(rootDir -> UnixPythonSdkFlavor.collectUnixPythons(rootDir, candidates));
        UnixPythonSdkFlavor.collectPyenvPythons(candidates);
        ArrayList<Path> arrayList = candidates;
        if (arrayList == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    private static Path optionallyChangeRoot(@Nullable Path rootPath, @NotNull Path dir) {
        if (dir == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        Path path2 = rootPath != null ? rootPath.resolve(dir.getRoot().relativize(dir)) : dir;
        if (path2 == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(2);
        }
        return path2;
    }

    @ApiStatus.Internal
    public static void collectUnixPythons(@NotNull Path binDirectory, @NotNull Collection<Path> candidates) {
        if (binDirectory == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(3);
        }
        if (candidates == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(4);
        }
        try (Stream<Path> entries = Files.list(binDirectory);){
            entries.filter(path2 -> ContainerUtil.exists(SYS_PYTHON_FILE_NAMES, regex -> regex.matcher(path2.getFileName().toString()).matches())).collect(Collectors.toCollection(() -> candidates));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void collectPyenvPythons(@NotNull Collection<Path> candidates) {
        if (candidates == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(5);
        }
        candidates.addAll(VirtualEnvReaderKt.VirtualEnvReader().findPyenvInterpreters());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/UnixPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixPythons";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/UnixPythonSdkFlavor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "optionallyChangeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "optionallyChangeRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectUnixPythons";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectPyenvPythons";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

