/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors.conda;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.PyCondaFlavorData;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0015J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/sdk/flavors/conda/CondaEnvSdkFlavor;", "Lcom/jetbrains/python/sdk/flavors/CPythonSdkFlavor;", "Lcom/jetbrains/python/sdk/flavors/conda/PyCondaFlavorData;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "getFlavorDataClass", "Ljava/lang/Class;", "suggestLocalHomePathsImpl", "", "Ljava/nio/file/Path;", "module", "Lcom/intellij/openapi/module/Module;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "sdkSeemsValid", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "flavorData", "targetConfig", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getUniqueId", "", "isValidSdkPath", "pathStr", "isPlatformIndependent", "providePyCharmHosted", "supportsEmptyData", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class CondaEnvSdkFlavor
extends CPythonSdkFlavor<PyCondaFlavorData> {
    @NotNull
    public static final CondaEnvSdkFlavor INSTANCE = new CondaEnvSdkFlavor();

    private CondaEnvSdkFlavor() {
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Anaconda");
        return icon;
    }

    @NotNull
    public Class<PyCondaFlavorData> getFlavorDataClass() {
        return PyCondaFlavorData.class;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    protected Collection<Path> suggestLocalHomePathsImpl(@Nullable Module module2, @Nullable UserDataHolder context) {
        return new ArrayList();
    }

    public boolean sdkSeemsValid(@NotNull Sdk sdk2, @NotNull PyCondaFlavorData flavorData, @Nullable TargetEnvironmentConfiguration targetConfig) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)flavorData, (String)"flavorData");
        String condaPath2 = flavorData.getEnv().getFullCondaPathOnTarget();
        return CPythonSdkFlavor.isFileExecutable((String)condaPath2, (TargetEnvironmentConfiguration)targetConfig);
    }

    @NotNull
    public String getUniqueId() {
        return "Conda";
    }

    public boolean isValidSdkPath(@NotNull String pathStr2) {
        Intrinsics.checkNotNullParameter((Object)pathStr2, (String)"pathStr");
        if (!super.isValidSdkPath(pathStr2)) {
            return false;
        }
        return PythonSdkUtil.isConda((String)pathStr2);
    }

    public boolean isPlatformIndependent() {
        return true;
    }

    public boolean providePyCharmHosted() {
        return false;
    }

    public boolean supportsEmptyData() {
        return false;
    }
}

