/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.frontend.gateway.action;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.station.core.toolbox.ToolboxStatus;
import com.intellij.station.core.toolbox.ToolboxStatusService;
import com.intellij.station.frontend.StationFrontendBundle;
import com.intellij.station.frontend.action.ToolboxWelcomeRemdevPanel;
import com.intellij.station.frontend.action.ToolboxWelcomeRemdevService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/station/frontend/gateway/action/OpenToolboxAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.station.frontend.gateway"})
@SourceDebugExtension(value={"SMAP\nCombinedWelcomeRemdevAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedWelcomeRemdevAction.kt\ncom/intellij/station/frontend/gateway/action/OpenToolboxAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,188:1\n42#2,3:189\n42#2,3:192\n42#2,3:195\n*S KotlinDebug\n*F\n+ 1 CombinedWelcomeRemdevAction.kt\ncom/intellij/station/frontend/gateway/action/OpenToolboxAction\n*L\n78#1:189,3\n99#1:192,3\n104#1:195,3\n*E\n"})
public final class OpenToolboxAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$service = false;
        Class<ToolboxWelcomeRemdevService> serviceClass$iv = ToolboxWelcomeRemdevService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ToolboxWelcomeRemdevService remdevService = (ToolboxWelcomeRemdevService)object;
        ToolboxStatus status = (ToolboxStatus)ToolboxStatusService.Companion.getInstance().getToolboxStatus().getValue();
        String text = status instanceof ToolboxStatus.NotYetComputed ? StationFrontendBundle.INSTANCE.message("action.WelcomeOpenToolbox.text", new Object[0]) : (!(status instanceof ToolboxStatus.Installed) ? StationFrontendBundle.INSTANCE.message("action.WelcomeOpenToolbox.install.text", new Object[0]) : (remdevService.needUpdateToolbox((ToolboxStatus.Installed)status) ? StationFrontendBundle.INSTANCE.message("action.WelcomeOpenToolbox.update.text", new Object[0]) : StationFrontendBundle.INSTANCE.message("action.WelcomeOpenToolbox.text", new Object[0])));
        String hint = StationFrontendBundle.INSTANCE.message("action.recommended.hint", new Object[0]);
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainMenu")) {
            e.getPresentation().setText(text + " (" + hint + ")");
        } else {
            e.getPresentation().setText(text);
            e.getPresentation().putClientProperty(ActionUtil.SECONDARY_TEXT, (Object)hint);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$service = false;
        Class<ToolboxWelcomeRemdevService> serviceClass$iv = ToolboxWelcomeRemdevService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ToolboxWelcomeRemdevService remdevService = (ToolboxWelcomeRemdevService)object;
        if (remdevService.getLastError().getValue() != null) {
            ToolboxWelcomeRemdevPanel.Companion.showPopup(e);
        } else {
            $i$f$service = false;
            serviceClass$iv = ToolboxWelcomeRemdevService.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((ToolboxWelcomeRemdevService)object2).createNewSshConnection(e.getProject());
        }
    }
}

