/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.execService.impl;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.intellij.python.community.execService.impl.LoggedProcessLine;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/python/community/execService/impl/LoggingInputStream;", "Ljava/io/InputStream;", "backingInputStream", "linesFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/python/community/execService/impl/LoggedProcessLine;", "kind", "Lcom/intellij/python/community/execService/impl/LoggedProcessLine$Kind;", "<init>", "(Ljava/io/InputStream;Lkotlinx/coroutines/flow/MutableSharedFlow;Lcom/intellij/python/community/execService/impl/LoggedProcessLine$Kind;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "outputSize", "", "reachedEnd", "", "currentLineBytes", "Lcom/google/common/io/ByteArrayDataOutput;", "read", "b", "", "off", "len", "close", "", "checkForStreamEnd", "char", "processChar", "finalizeLine", "bytes", "finalizeLastLine", "intellij.python.community.execService"})
final class LoggingInputStream
extends InputStream {
    @NotNull
    private final InputStream backingInputStream;
    @NotNull
    private final MutableSharedFlow<LoggedProcessLine> linesFlow;
    @NotNull
    private final LoggedProcessLine.Kind kind;
    @NotNull
    private AtomicBoolean closed;
    private int outputSize;
    private boolean reachedEnd;
    @NotNull
    private ByteArrayDataOutput currentLineBytes;

    public LoggingInputStream(@NotNull InputStream backingInputStream, @NotNull MutableSharedFlow<LoggedProcessLine> linesFlow, @NotNull LoggedProcessLine.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)backingInputStream, (String)"backingInputStream");
        Intrinsics.checkNotNullParameter(linesFlow, (String)"linesFlow");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.backingInputStream = backingInputStream;
        this.linesFlow = linesFlow;
        this.kind = kind;
        this.closed = new AtomicBoolean(false);
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        Intrinsics.checkNotNullExpressionValue((Object)byteArrayDataOutput, (String)"newDataOutput(...)");
        this.currentLineBytes = byteArrayDataOutput;
    }

    @Override
    public int read() {
        if (this.closed.get()) {
            return -1;
        }
        int n = this.backingInputStream.read();
        this.checkForStreamEnd(n);
        if (!this.reachedEnd) {
            this.processChar(n);
            ++this.outputSize;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.closed.get()) {
            return -1;
        }
        int finalLen = this.backingInputStream.read(b, off, len);
        this.checkForStreamEnd(finalLen);
        if (!this.reachedEnd) {
            int truncatedLen = this.outputSize + finalLen > 100000 ? 100000 - this.outputSize : finalLen;
            int n = off + truncatedLen;
            for (int index = off; index < n; ++index) {
                this.processChar(b[index]);
            }
            this.outputSize += truncatedLen;
        }
        return finalLen;
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.finalizeLastLine();
        super.close();
    }

    private final void checkForStreamEnd(int n) {
        if (!(this.reachedEnd || this.outputSize < 100000 && n != -1)) {
            this.reachedEnd = true;
            this.finalizeLastLine();
        }
    }

    private final void processChar(int n) {
        if (n == -1) {
            return;
        }
        switch ((char)n) {
            case '\r': {
                break;
            }
            case '\n': {
                byte[] byArray = this.currentLineBytes.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                this.finalizeLine(byArray);
                break;
            }
            default: {
                this.currentLineBytes.write(n);
            }
        }
    }

    private final void finalizeLine(byte[] bytes) {
        String line = new String(bytes, Charsets.UTF_8);
        this.linesFlow.tryEmit((Object)new LoggedProcessLine(line, this.kind));
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        Intrinsics.checkNotNullExpressionValue((Object)byteArrayDataOutput, (String)"newDataOutput(...)");
        this.currentLineBytes = byteArrayDataOutput;
    }

    private final void finalizeLastLine() {
        byte[] byArray = this.currentLineBytes.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] bytes = byArray;
        if (bytes.length > 0) {
            this.finalizeLine(bytes);
        }
    }
}

