/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.backend.gotourl;

import com.intellij.microservices.backend.gotourl.MyConstantRangesMinusculeMatcher;
import com.intellij.microservices.backend.gotourl.SegmentMatchResult;
import com.intellij.microservices.backend.gotourl.UrlPathMatchResult;
import com.intellij.microservices.url.UrlPath;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.text.matching.MatchedFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0001H\u0096\u0082\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/backend/gotourl/ResultFromUrlMatcher;", "Lcom/intellij/microservices/backend/gotourl/UrlPathMatchResult;", "score", "", "segments", "", "Lcom/intellij/microservices/backend/gotourl/SegmentMatchResult;", "<init>", "(ILjava/util/List;)V", "getScore", "()I", "getSegments", "()Ljava/util/List;", "compareTo", "other", "toPresentationMatcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "urlPath", "Lcom/intellij/microservices/url/UrlPath;", "intellij.microservices.backend"})
final class ResultFromUrlMatcher
implements UrlPathMatchResult {
    private final int score;
    @NotNull
    private final List<SegmentMatchResult> segments;

    public ResultFromUrlMatcher(int score, @NotNull List<SegmentMatchResult> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.score = score;
        this.segments = segments;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @NotNull
    public final List<SegmentMatchResult> getSegments() {
        return this.segments;
    }

    @Override
    public int compareTo(@NotNull UrlPathMatchResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)this.getScore(), (int)other.getScore());
    }

    @Override
    @NotNull
    public MinusculeMatcher toPresentationMatcher(@NotNull UrlPath urlPath) {
        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull((List)urlPath.getSegments());
        int lengthBefore = (pathSegment != null ? pathSegment.isEmpty() : false) ? 0 : 1;
        int includedSegmentIndex = 0;
        List result = new ArrayList();
        int n = ((Collection)urlPath.getSegments()).size();
        for (int i = 0; i < n && includedSegmentIndex <= CollectionsKt.getLastIndex(this.segments); ++i) {
            if (i == this.segments.get(includedSegmentIndex).getSegmentIndex()) {
                for (MatchedFragment textRange : this.segments.get(includedSegmentIndex).getRangesInSegment()) {
                    result.add(MatchedFragment.copy$default((MatchedFragment)textRange, (int)(textRange.getStartOffset() + lengthBefore), (int)(textRange.getEndOffset() + lengthBefore), (int)0, (int)4, null));
                }
                ++includedSegmentIndex;
            }
            lengthBefore += UrlPath.FULL_PATH_VARIABLE_PRESENTATION.patternMatch((UrlPath.PathSegment)urlPath.getSegments().get(i)).length() + 1;
        }
        return new MyConstantRangesMinusculeMatcher(result, "/" + urlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION));
    }
}

