/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.permissions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.frontend.CodeWithMeFrontendBundle;
import com.intellij.cwm.frontend.permissions.CWMPermissionDecorator;
import com.intellij.cwm.frontend.permissions.UtilKt;
import com.intellij.cwm.plugin.common.CommonNotifications;
import com.intellij.cwm.plugin.common.permissions.AccessLevel;
import com.intellij.cwm.plugin.common.permissions.AccessLevelImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupCornerType;
import com.intellij.openapi.util.NlsActions;
import com.intellij.platform.frontend.split.connection.ConnectionInfoProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.jetbrains.codeWithMe.model.NotPermittedNotification;
import com.jetbrains.codeWithMe.model.PermissionsLevelModel;
import com.jetbrains.codeWithMe.model.UserPermissionModel;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.codeWithMe.permissions.AccessLevels;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsMode;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsRequestLevel;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.thinclient.services.ThinClientPermissionHost;
import com.jetbrains.thinclient.services.ThinClientPermissionInteractionManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\nH\u0016J8\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager;", "Lcom/jetbrains/thinclient/services/ThinClientPermissionInteractionManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "model", "Lcom/jetbrains/codeWithMe/model/UserPermissionModel;", "notifyNotPermitted", "", "frontendActionId", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "askForPermissions", "level", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/PermissionsRequestLevel;", "place", "decorateActionPresentation", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "actionTemplateText", "inputEvent", "Ljava/awt/event/InputEvent;", "requestLevel", "project", "Lcom/intellij/openapi/project/Project;", "getLevels", "", "Lcom/jetbrains/rd/actions/AccessLevelMarker;", "mode", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/PermissionsMode;", "shouldShowTooltip", "", "ProtocolListener", "Companion", "intellij.cwm.frontend"})
@SourceDebugExtension(value={"SMAP\nCWMPermissionInteractionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CWMPermissionInteractionManager.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n1#2:187\n13#3:188\n*S KotlinDebug\n*F\n+ 1 CWMPermissionInteractionManager.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager\n*L\n184#1:188\n*E\n"})
public final class CWMPermissionInteractionManager
extends LifetimedService
implements ThinClientPermissionInteractionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UserPermissionModel model;
    @NotNull
    private static final Logger logger;

    public void notifyNotPermitted(@NotNull String frontendActionId, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AnAction anAction = ActionManager.getInstance().getAction(frontendActionId);
        if (anAction == null) {
            return;
        }
        AnAction action = anAction;
        AccessRequirements accessRequirements = ThinClientPermissionHost.Companion.getInstance().getAccessRequirements(frontendActionId);
        if (accessRequirements == null) {
            accessRequirements = (AccessRequirements)new AccessRequirements.Listed(AccessLevels.INSTANCE.getMaxValues());
        }
        AccessRequirements accessRequirements2 = accessRequirements;
        logger.warn("action " + frontendActionId + " requires more permissions (" + accessRequirements2 + ") and won't be executed");
        String title = action.getTemplateText();
        InputEvent inputEvent = event.getInputEvent();
        PermissionsRequestLevel permissionsRequestLevel = UtilKt.getRequestLevel(accessRequirements2);
        String string = event.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        this.notifyNotPermitted(title, inputEvent, permissionsRequestLevel, string, event.getProject());
    }

    public void notifyNotPermitted(@NotNull AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List list = (List)event.getPresentation().getClientProperty(ActionUtil.UNSATISFIED_PERMISSIONS);
        if (list == null) {
            return;
        }
        List permissions = list;
        AccessLevel accessLevel = com.intellij.cwm.plugin.common.permissions.UtilKt.getAccessLevel((List)permissions);
        AccessLevelImpl accessLevelImpl = accessLevel instanceof AccessLevelImpl ? (AccessLevelImpl)accessLevel : null;
        if (accessLevelImpl == null) {
            return;
        }
        AccessLevelImpl level = accessLevelImpl;
        String string = action.getTemplateText();
        InputEvent inputEvent = event.getInputEvent();
        PermissionsRequestLevel permissionsRequestLevel = level.getLevel();
        String string2 = event.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlace(...)");
        this.notifyNotPermitted(string, inputEvent, permissionsRequestLevel, string2, event.getProject());
    }

    public void askForPermissions(@NotNull PermissionsRequestLevel level, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        PermissionsLevelModel levelModel = switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1 -> PermissionsLevelModel.FULL_ACCESS;
            case 2 -> PermissionsLevelModel.EDIT_FILES;
            default -> throw new NoWhenBranchMatchedException();
        };
        ThinClientPermissionHost permissionHost = ThinClientPermissionHost.Companion.getInstance();
        PermissionsMode currentPermissionMode = permissionHost.areSatisfied((AccessRequirements)new AccessRequirements.Listed(this.getLevels(PermissionsMode.FullAccess))) ? PermissionsMode.FullAccess : (permissionHost.areSatisfied((AccessRequirements)new AccessRequirements.Listed(this.getLevels(PermissionsMode.EditFiles))) ? PermissionsMode.EditFiles : (permissionHost.areSatisfied((AccessRequirements)new AccessRequirements.Listed(this.getLevels(PermissionsMode.Readonly))) ? PermissionsMode.Readonly : PermissionsMode.Custom));
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onPermissionsRequested(ConnectionInfoProvider.Companion.getSessionId(), currentPermissionMode, level, place);
        UserPermissionModel userPermissionModel = this.model;
        Intrinsics.checkNotNull((Object)userPermissionModel);
        userPermissionModel.getRequestPermissionsChange().start(this.getServiceLifetime(), (Object)levelModel);
    }

    public void decorateActionPresentation(@NotNull Presentation presentation, @NotNull String place) {
        Icon disabledIcon;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        presentation.setEnabled(false);
        Icon icon = presentation.getDisabledIcon();
        if (icon == null) {
            Icon icon2 = presentation.getIcon();
            if (icon2 != null) {
                Icon it = icon2;
                boolean bl = false;
                icon = ActionButtonLook.SYSTEM_LOOK.getDisabledIcon(it);
            } else {
                icon = null;
            }
        }
        if ((disabledIcon = icon) != null) {
            presentation.setDisabledIcon(CWMPermissionDecorator.Companion.decorateIcon$default(CWMPermissionDecorator.Companion, disabledIcon, null, 2, null));
        }
        CWMPermissionDecorator.Companion.setRequestFullAccessTooltip(presentation, null, place);
    }

    private final void notifyNotPermitted(@NlsActions.ActionText String actionTemplateText, InputEvent inputEvent, PermissionsRequestLevel requestLevel, String place, Project project) {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[requestLevel.ordinal()] == 2) {
            string = CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.edit.files.notification.description", new Object[0]);
        } else if (actionTemplateText != null) {
            Object[] objectArray = new Object[]{actionTemplateText};
            string = CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.notification.description", objectArray);
        } else {
            string = CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.description", new Object[0]);
        }
        String description = string;
        PermissionsRequestLevel it = requestLevel;
        boolean bl = false;
        Function1 function1 = arg_0 -> CWMPermissionInteractionManager.notifyNotPermitted$lambda$0$0(this, it, arg_0);
        Pair action = TuplesKt.to((Object)function1, (Object)(switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
            case 1 -> CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.full.access.tooltip", new Object[0]);
            case 2 -> CodeWithMeFrontendBundle.INSTANCE.message("presentation.permissions.edit.files.tooltip", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        }));
        if (inputEvent != null && inputEvent instanceof MouseEvent && this.shouldShowTooltip(place)) {
            HelpTooltip tooltip = new HelpTooltip().setDescription(description).setLink((String)action.getSecond(), () -> CWMPermissionInteractionManager.notifyNotPermitted$lambda$1(action, place));
            JPanel jPanel = tooltip.createTipPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createTipPanel(...)");
            JPanel panel = jPanel;
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, null).setShowBorder(UIManager.getBoolean("ToolTip.paintBorder")).setBorderColor(JBUI.CurrentTheme.Tooltip.borderColor()).setShowShadow(true).addUserData((Object)PopupCornerType.RoundedTooltip).setCancelOnMouseOutCallback(arg_0 -> CWMPermissionInteractionManager.notifyNotPermitted$lambda$2(panel, arg_0)).createPopup().show(new RelativePoint(((MouseEvent)inputEvent).getComponent(), ((MouseEvent)inputEvent).getPoint()));
        } else {
            String groupId = CommonNotifications.INSTANCE.getGroupId();
            Notification notification = new Notification(groupId, CodeWithMeFrontendBundle.INSTANCE.message("permissions.notification.title", new Object[0]), description, NotificationType.INFORMATION);
            notification.setIcon(AllIcons.CodeWithMe.CwmPermissions);
            String string2 = (String)action.getSecond();
            notification.addAction(new AnAction((Pair<? extends Function1<? super String, Unit>, String>)action, notification, string2){
                final /* synthetic */ Pair<Function1<String, Unit>, String> $action;
                final /* synthetic */ Notification $notification;
                {
                    this.$action = $action;
                    this.$notification = $notification;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ((Function1)this.$action.getFirst()).invoke((Object)"Notification");
                    this.$notification.expire();
                }
            });
            notification.notify(project);
        }
    }

    private final List<AccessLevelMarker> getLevels(PermissionsMode mode) {
        Object[] objectArray = new AccessLevelMarker[]{mode.getFileAccess(), mode.getRunAccess(), mode.getTerminalAccess(), mode.getToolWindowAccess()};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final boolean shouldShowTooltip(String place) {
        Object[] objectArray = new String[]{"EditorPopup", "EditorTabPopup", "ICON_NAVIGATION", "ICON_NAVIGATION_SECONDARY_BUTTON"};
        return CollectionsKt.listOf((Object[])objectArray).contains(place);
    }

    private static final Unit notifyNotPermitted$lambda$0$0(CWMPermissionInteractionManager this$0, PermissionsRequestLevel $it, String place) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this$0.askForPermissions($it, place);
        return Unit.INSTANCE;
    }

    private static final void notifyNotPermitted$lambda$1(Pair $action, String $place) {
        ((Function1)$action.getFirst()).invoke((Object)$place);
    }

    private static final boolean notifyNotPermitted$lambda$2(JPanel $panel, MouseEvent e) {
        if (!$panel.isShowing()) {
            return false;
        }
        Cloneable it = $panel.getLocationOnScreen();
        boolean bl = false;
        it = $panel.getSize();
        Point point = new Point(it.x - 10, it.y - 10);
        boolean bl2 = false;
        Point point2 = point;
        Dimension dimension = new Dimension(((Dimension)it).width + 10, ((Dimension)it).height + 10);
        Rectangle screenBounds = new Rectangle(point2, dimension);
        return !screenBounds.contains(e.getLocationOnScreen());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CWMPermissionInteractionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CWMPermissionInteractionManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager$ProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/codeWithMe/model/UserPermissionModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.cwm.frontend"})
    @SourceDebugExtension(value={"SMAP\nCWMPermissionInteractionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CWMPermissionInteractionManager.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager$ProtocolListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,186:1\n42#2,3:187\n*S KotlinDebug\n*F\n+ 1 CWMPermissionInteractionManager.kt\ncom/intellij/cwm/frontend/permissions/CWMPermissionInteractionManager$ProtocolListener\n*L\n175#1:187,3\n*E\n"})
    public static final class ProtocolListener
    implements RootExtListener<UserPermissionModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull UserPermissionModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            boolean $i$f$service = false;
            Class<ThinClientPermissionInteractionManager> serviceClass$iv = ThinClientPermissionInteractionManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.cwm.frontend.permissions.CWMPermissionInteractionManager");
            CWMPermissionInteractionManager manager = (CWMPermissionInteractionManager)((Object)object);
            model.getNotifyNotPermitted().advise(lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$0(manager, arg_0));
            manager.model = model;
        }

        private static final Unit extensionCreated$lambda$0(CWMPermissionInteractionManager $manager, NotPermittedNotification it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $manager.notifyNotPermitted(it.getActionText(), null, UtilKt.fromModel(it.getAccessLevel()), "Notification", ProjectUtilKt.toProject((RdProjectId)it.getProjectId()));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionsRequestLevel.values().length];
            try {
                nArray[PermissionsRequestLevel.FULL_ACCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionsRequestLevel.EDIT_FILES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

