/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.frontend.toolwindow;

import com.intellij.cwm.frontend.toolwindow.FrontendToolwindowMirrorModeTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.frontend.split.FrontendProcessInfo;
import com.jetbrains.rd.ide.model.BeIdeaToolWindow;
import com.jetbrains.thinclient.toolWindow.FrontendToolWindowHost;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/cwm/frontend/toolwindow/FrontendMirrorModeToolwindowListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "toolWindowsRegistered", "", "ids", "", "", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.cwm.frontend"})
final class FrontendMirrorModeToolwindowListener
implements ToolWindowManagerListener {
    @NotNull
    private final Project project;

    public FrontendMirrorModeToolwindowListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        if (!FrontendProcessInfo.INSTANCE.isGuest()) {
            return;
        }
        for (String id : ids) {
            BeIdeaToolWindow model;
            ToolWindow toolWindow;
            if (toolWindowManager.getToolWindow(id) == null) continue;
            if (FrontendToolWindowHost.Companion.getInstance(this.project).getModel(toolWindow) == null) {
                return;
            }
            Disposable disposable = toolWindow.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            new FrontendToolwindowMirrorModeTracker(this.project, id, model, LifetimeDisposableExKt.createLifetime((Disposable)disposable));
        }
    }
}

