/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DarkReplacer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.ui.icons.ImageDataByPathResourceLoader;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a.\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\b2\u0012\b\u0002\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0019H\u0007\u001aF\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\u0012\b\u0002\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00192\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"2\u0010\u0004\u001a&\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "iconCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lkotlin/Pair;", "", "Ljava/lang/ClassLoader;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/ui/icons/CachedImageIcon;", "fakeComponent", "Ljavax/swing/JComponent;", "getFakeComponent", "()Ljavax/swing/JComponent;", "fakeComponent$delegate", "Lkotlin/Lazy;", "findUserIconByPath", "file", "Ljava/nio/file/Path;", "findIconUsingNewImplementation", "Ljavax/swing/Icon;", "path", "classLoader", "toolTip", "Ljava/util/function/Supplier;", "findIconUsingDeprecatedImplementation", "originalPath", "aClass", "Ljava/lang/Class;", "strict", "", "ourDarkReplacer", "Lcom/intellij/openapi/util/DarkReplacer;", "ourLightReplacer", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nIconLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IconLoader.kt\ncom/intellij/openapi/util/IconLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,469:1\n13#2:470\n*S KotlinDebug\n*F\n+ 1 IconLoader.kt\ncom/intellij/openapi/util/IconLoaderKt\n*L\n67#1:470\n*E\n"})
public final class IconLoaderKt {
    @NotNull
    private static final Cache<Pair<String, ClassLoader>, CachedImageIcon> iconCache;
    @NotNull
    private static final Lazy fakeComponent$delegate;
    @NotNull
    private static final DarkReplacer ourDarkReplacer;
    @NotNull
    private static final DarkReplacer ourLightReplacer;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IconLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public static final JComponent getFakeComponent() {
        Lazy lazy = fakeComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    @ApiStatus.Internal
    @NotNull
    public static final CachedImageIcon findUserIconByPath(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = iconCache.get((Object)new Pair((Object)((Object)file).toString(), null), arg_0 -> IconLoaderKt.findUserIconByPath$lambda$1(arg_0 -> IconLoaderKt.findUserIconByPath$lambda$0(file, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (CachedImageIcon)object;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Icon findIconUsingNewImplementation(@NotNull String path, @NotNull ClassLoader classLoader, @Nullable Supplier<String> toolTip) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return ImageDataByPathLoaderKt.findIconByPath(path, classLoader, iconCache, toolTip);
    }

    public static /* synthetic */ Icon findIconUsingNewImplementation$default(String string, ClassLoader classLoader, Supplier supplier, int n, Object object) {
        if ((n & 4) != 0) {
            supplier = null;
        }
        return IconLoaderKt.findIconUsingNewImplementation(string, classLoader, supplier);
    }

    @ApiStatus.Internal
    @Nullable
    public static final Icon findIconUsingDeprecatedImplementation(@NotNull String originalPath, @NotNull ClassLoader classLoader, @Nullable Class<?> aClass, @Nullable Supplier<String> toolTip, boolean strict) {
        Object object;
        Object effectivePath;
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Object effectiveClassLoader = null;
        effectiveClassLoader = classLoader;
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        Pair<String, ClassLoader> patchedPath = CachedImageIconKt.patchIconPath(originalPath, (ClassLoader)effectiveClassLoader);
        Object object2 = patchedPath;
        if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
            object2 = effectivePath = originalPath;
        }
        if ((object = patchedPath) != null && (object = (ClassLoader)object.getSecond()) != null) {
            Object it = object;
            boolean bl = false;
            effectiveClassLoader = it;
        }
        Icon icon = null;
        if (ImageDataByPathLoaderKt.isReflectivePath(effectivePath)) {
            icon = ImageDataByPathLoaderKt.getReflectiveIcon(effectivePath, effectiveClassLoader);
        } else {
            Pair key = new Pair((Object)originalPath, effectiveClassLoader);
            icon = (Icon)iconCache.getIfPresent((Object)key);
            if (icon == null) {
                icon = (Icon)iconCache.get((Object)key, arg_0 -> IconLoaderKt.findIconUsingDeprecatedImplementation$lambda$2(arg_0 -> IconLoaderKt.findIconUsingDeprecatedImplementation$lambda$1(aClass, strict, effectivePath, toolTip, arg_0), arg_0));
            }
        }
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        return icon;
    }

    public static /* synthetic */ Icon findIconUsingDeprecatedImplementation$default(String string, ClassLoader classLoader, Class clazz, Supplier supplier, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            supplier = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return IconLoaderKt.findIconUsingDeprecatedImplementation(string, classLoader, clazz, supplier, bl);
    }

    private static final fakeComponent.2.1 fakeComponent_delegate$lambda$0() {
        return new JComponent(){};
    }

    private static final CachedImageIcon findUserIconByPath$lambda$0(Path $file, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CachedImageIcon($file);
    }

    private static final CachedImageIcon findUserIconByPath$lambda$1(Function1 $tmp0, Object p0) {
        return (CachedImageIcon)$tmp0.invoke(p0);
    }

    private static final CachedImageIcon findIconUsingDeprecatedImplementation$lambda$1(Class $aClass, boolean $strict, String $effectivePath, Supplier $toolTip, Pair k) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        ClassLoader classLoader = (ClassLoader)k.getSecond();
        ImageDataByPathResourceLoader loader = new ImageDataByPathResourceLoader($aClass, classLoader, $strict, $effectivePath);
        return new CachedImageIcon(loader, $toolTip);
    }

    private static final CachedImageIcon findIconUsingDeprecatedImplementation$lambda$2(Function1 $tmp0, Object p0) {
        return (CachedImageIcon)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Cache access$getIconCache$p() {
        return iconCache;
    }

    public static final /* synthetic */ DarkReplacer access$getOurDarkReplacer$p() {
        return ourDarkReplacer;
    }

    public static final /* synthetic */ DarkReplacer access$getOurLightReplacer$p() {
        return ourLightReplacer;
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return IconLoaderKt.getLOG();
    }

    static {
        Cache cache = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault())).maximumSize(256L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        iconCache = cache;
        fakeComponent$delegate = LazyKt.lazy(IconLoaderKt::fakeComponent_delegate$lambda$0);
        ourDarkReplacer = new DarkReplacer(true);
        ourLightReplacer = new DarkReplacer(false);
    }
}

