/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.surveys.trialExpiredSurvey;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.platform.feedback.impl.state.CommonFeedbackSurveyService;
import com.intellij.platform.trialPromotion.common.TrialStateService;
import com.intellij.pycharm.pro.surveys.trialExpiredSurvey.TrialExpiredFeedbackDialog;
import com.intellij.pycharm.pro.surveys.trialExpiredSurvey.TrialFeedbackBundle;
import com.intellij.util.PlatformUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tH\u0016J \u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/pycharm/pro/surveys/trialExpiredSurvey/TrialExpiredFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "trialExpiredMoreThan7DaysAgo", "checkExtraConditionSatisfiedForNotification", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "forTest", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "updateStateAfterNotificationShowed", "", "updateStateAfterDialogClosedOk", "intellij.pycharm.pro.surveys"})
public final class TrialExpiredFeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    private final boolean requireIdeEAP;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2099, 1, 1);

    public TrialExpiredFeedbackSurveyConfig() {
        this.surveyId = "pycharm_trial_expired_free_mode_survey";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isPyCharm();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (CommonFeedbackSurveyService.Companion.checkIsFeedbackSurveyAnswerSent(this.getSurveyId())) {
            return false;
        }
        if (CommonFeedbackSurveyService.Companion.getNumberShowsOfFeedbackSurvey(this.getSurveyId()) > 0) {
            return false;
        }
        return this.trialExpiredMoreThan7DaysAgo();
    }

    private final boolean trialExpiredMoreThan7DaysAgo() {
        boolean isFreeMode = PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
        if (!isFreeMode) {
            return false;
        }
        TrialStateService trialStateService = TrialStateService.Companion.getInstance();
        Instant instant = trialStateService.getLastTrialExpirationDate();
        if (instant == null) {
            return false;
        }
        Instant expirationDate = instant;
        int delayMinutes = Registry.Companion.intValue("pycharm.trial.expired.survey.delay.minutes", -1);
        Instant targetDate = delayMinutes > 0 ? expirationDate.plus((long)delayMinutes, ChronoUnit.MINUTES) : expirationDate.plus(7L, ChronoUnit.DAYS);
        return Instant.now().isAfter(targetDate);
    }

    public boolean checkExtraConditionSatisfiedForNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.checkExtraConditionSatisfied(project);
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RequestFeedbackNotification(TrialFeedbackBundle.INSTANCE.message("notification.channel", new Object[0]), TrialFeedbackBundle.INSTANCE.message("notification.request.title", new Object[0]), TrialFeedbackBundle.INSTANCE.message("notification.request.text", new Object[0]));
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (BlockBasedFeedbackDialog)new TrialExpiredFeedbackDialog(project, forTest);
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CommonFeedbackSurveyService.Companion.feedbackSurveyShowed(this.getSurveyId());
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CommonFeedbackSurveyService.Companion.feedbackSurveyAnswerSent(this.getSurveyId());
    }
}

