/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.console;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.filter.WebpackErrorFilter;
import com.intellij.javascript.testing.vitest.VitestStacktraceFilter;
import com.intellij.lang.javascript.linter.eslint.filter.EslintErrorFilter;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/nodejs/console/NodeConsoleFilterProvider;", "Lcom/intellij/execution/filters/ConsoleDependentFilterProvider;", "<init>", "()V", "getDefaultFilters", "", "Lcom/intellij/execution/filters/Filter;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/execution/filters/Filter;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/execution/filters/Filter;", "intellij.nodeJS"})
public final class NodeConsoleFilterProvider
extends ConsoleDependentFilterProvider {
    @NotNull
    public Filter[] getDefaultFilters(@NotNull ConsoleView consoleView, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        String workingDirectory;
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (consoleView instanceof DataProvider) {
            Object object = LangDataKeys.RUN_PROFILE.getData((DataProvider)consoleView);
            CommonProgramRunConfigurationParameters commonProgramRunConfigurationParameters = object instanceof CommonProgramRunConfigurationParameters ? (CommonProgramRunConfigurationParameters)object : null;
            v1 = commonProgramRunConfigurationParameters != null ? commonProgramRunConfigurationParameters.getWorkingDirectory() : null;
        } else {
            v1 = workingDirectory = null;
        }
        if (workingDirectory != null) {
            Filter[] filterArray = new Filter[]{new NodeStackTraceFilter(project, workingDirectory)};
            return filterArray;
        }
        return this.getDefaultFilters(project);
    }

    @NotNull
    public Filter[] getDefaultFilters(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile root = ProjectUtil.guessProjectDir((Project)project);
        Filter[] filterArray = new Filter[]{new NodeStackTraceFilter(project, root), new WebpackErrorFilter(project, root), new EslintErrorFilter(project, root), new VitestStacktraceFilter(project, root)};
        return filterArray;
    }
}

