/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import zmq.Options;
import zmq.Own;
import zmq.SocketBase;
import zmq.ZError;
import zmq.io.IOObject;
import zmq.io.IOThread;
import zmq.io.SessionBase;
import zmq.io.StreamEngine;
import zmq.io.net.Address;
import zmq.io.net.StandardProtocolFamily;
import zmq.io.net.tcp.TcpUtils;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;
import zmq.util.Utils;

public class TcpConnecter
extends Own
implements IPollEvents {
    protected static final int RECONNECT_TIMER_ID = 1;
    protected final IOObject ioObject;
    private final Address addr;
    private SocketChannel fd;
    private Poller.Handle handle;
    protected final boolean delayedStart;
    private boolean timerStarted;
    private final SessionBase session;
    private int currentReconnectIvl;
    private final SocketBase socket;

    public TcpConnecter(IOThread ioThread, SessionBase session2, Options options, Address addr, boolean delayedStart) {
        super(ioThread, options);
        this.ioObject = new IOObject(ioThread, this);
        this.addr = addr;
        this.fd = null;
        this.delayedStart = delayedStart;
        this.timerStarted = false;
        this.session = session2;
        this.currentReconnectIvl = this.options.reconnectIvl;
        assert (this.addr != null);
        this.socket = session2.getSocket();
    }

    @Override
    protected void destroy() {
        assert (!this.timerStarted);
        assert (this.handle == null);
        assert (this.fd == null);
        this.ioObject.unplug();
    }

    @Override
    protected void processPlug() {
        this.ioObject.plug();
        if (this.delayedStart) {
            this.addReconnectTimer();
        } else {
            this.startConnecting();
        }
    }

    @Override
    protected void processTerm(int linger) {
        if (this.timerStarted) {
            this.ioObject.cancelTimer(1);
            this.timerStarted = false;
        }
        if (this.handle != null) {
            this.ioObject.removeHandle(this.handle);
            this.handle = null;
        }
        if (this.fd != null) {
            this.close();
        }
        super.processTerm(linger);
    }

    @Override
    public void connectEvent() {
        StreamEngine engine;
        this.ioObject.removeHandle(this.handle);
        this.handle = null;
        SocketChannel channel = this.connect();
        if (channel == null) {
            this.close();
            this.addReconnectTimer();
            return;
        }
        try {
            TcpUtils.tuneTcpSocket(channel);
            TcpUtils.tuneTcpKeepalives(channel, this.options.tcpKeepAlive, this.options.tcpKeepAliveCnt, this.options.tcpKeepAliveIdle, this.options.tcpKeepAliveIntvl);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        try {
            engine = new StreamEngine(channel, this.options, this.addr.toString());
        }
        catch (ZError.InstantiationException e) {
            return;
        }
        this.fd = null;
        this.sendAttach(this.session, engine);
        this.terminate();
        this.socket.eventConnected(this.addr.toString(), channel);
    }

    @Override
    public void timerEvent(int id) {
        assert (id == 1);
        this.timerStarted = false;
        this.startConnecting();
    }

    private void startConnecting() {
        try {
            boolean rc = this.open();
            if (rc) {
                this.handle = this.ioObject.addFd(this.fd);
                this.connectEvent();
            } else {
                this.handle = this.ioObject.addFd(this.fd);
                this.ioObject.setPollConnect(this.handle);
                this.socket.eventConnectDelayed(this.addr.toString(), -1);
            }
        }
        catch (IOException | RuntimeException e) {
            if (this.fd != null) {
                this.close();
            }
            this.addReconnectTimer();
        }
    }

    private void addReconnectTimer() {
        int rcIvl = this.getNewReconnectIvl();
        this.ioObject.addTimer(rcIvl, 1);
        try {
            this.addr.resolve(this.options.ipv6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.eventConnectRetried(this.addr.toString(), rcIvl);
        this.timerStarted = true;
    }

    private int getNewReconnectIvl() {
        int interval = this.currentReconnectIvl + Utils.randomInt() % this.options.reconnectIvl;
        if (this.options.reconnectIvlMax > 0 && this.options.reconnectIvlMax > this.options.reconnectIvl) {
            this.currentReconnectIvl = Math.min(this.currentReconnectIvl * 2, this.options.reconnectIvlMax);
        }
        return interval;
    }

    private boolean open() throws IOException {
        boolean rc;
        assert (this.fd == null);
        if (this.addr == null) {
            throw new IOException("Null address");
        }
        this.addr.resolve(this.options.ipv6);
        Address.IZAddress resolved = this.addr.resolved();
        if (resolved == null) {
            throw new IOException("Address not resolved");
        }
        SocketAddress sa = resolved.address();
        if (sa == null) {
            throw new IOException("Socket address not resolved");
        }
        this.fd = this.options.selectorChooser == null ? SocketChannel.open() : this.options.selectorChooser.choose(resolved, this.options).openSocketChannel();
        if (resolved.family() == StandardProtocolFamily.INET6) {
            TcpUtils.enableIpv4Mapping(this.fd);
        }
        TcpUtils.unblockSocket(this.fd);
        if (this.options.sndbuf != 0) {
            TcpUtils.setTcpSendBuffer(this.fd, this.options.sndbuf);
        }
        if (this.options.rcvbuf != 0) {
            TcpUtils.setTcpReceiveBuffer(this.fd, this.options.rcvbuf);
        }
        if (this.options.tos != 0) {
            TcpUtils.setIpTypeOfService(this.fd, this.options.tos);
        }
        try {
            rc = this.fd.connect(sa);
            if (!rc) {
                this.errno.set(36);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
        return rc;
    }

    private SocketChannel connect() {
        try {
            boolean finished = this.fd.finishConnect();
            assert (finished);
            return this.fd;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void close() {
        assert (this.fd != null);
        try {
            this.fd.close();
            this.socket.eventClosed(this.addr.toString(), this.fd);
        }
        catch (IOException e) {
            this.socket.eventCloseFailed(this.addr.toString(), ZError.exccode(e));
        }
        this.fd = null;
    }

    @Override
    public void inEvent() {
    }

    @Override
    public void outEvent() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.options.socketId + "]";
    }
}

