/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u0002H\b\u0012\u0002\b\u00030\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/psi/impl/IntentionalUnstubbing;", "", "<init>", "()V", "forciblyUnstubbed", "", "Lcom/intellij/psi/PsiFile;", "onFileOf", "R", "element", "Lcom/intellij/psi/PsiElement;", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "getForciblyUnstubbedFiles", "", "resetForciblyUnstubbedFileSet", "", "intellij.python.psi"})
@ApiStatus.Internal
public final class IntentionalUnstubbing {
    @NotNull
    public static final IntentionalUnstubbing INSTANCE = new IntentionalUnstubbing();
    @NotNull
    private static final Set<PsiFile> forciblyUnstubbed;

    private IntentionalUnstubbing() {
    }

    @JvmStatic
    public static final <R> R onFileOf(@NotNull PsiElement element, @NotNull ThrowableComputable<R, ?> computable) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        PsiFile psiFile = element.getContainingFile();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Intrinsics.checkNotNull((Object)psiFile);
            forciblyUnstubbed.add(psiFile);
        }
        return (R)AstLoadingFilter.forceAllowTreeLoading((PsiFile)psiFile, computable);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final Set<PsiFile> getForciblyUnstubbedFiles() {
        Set<PsiFile> set = Collections.unmodifiableSet(forciblyUnstubbed);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    @JvmStatic
    @TestOnly
    public static final void resetForciblyUnstubbedFileSet() {
        forciblyUnstubbed.clear();
    }

    static {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        forciblyUnstubbed = keySetView;
    }
}

