/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.frontend;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.frontend.split.daemon.HighlightingUtilKt;
import com.jetbrains.codeWithMe.model.SyntaxHighlighterModel;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.pyi.PyiFileType;
import com.jetbrains.rd.ide.model.DefaultHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/frontend/PyFrontendHighlighterSuppressionHandler;", "Lcom/jetbrains/rdclient/daemon/FrontendHighlighterSuppressionHandler;", "<init>", "()V", "shouldSuppress", "", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.python.frontend"})
public final class PyFrontendHighlighterSuppressionHandler
implements FrontendHighlighterSuppressionHandler {
    public boolean shouldSuppress(@NotNull HighlighterModel highlighterModel, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)highlighterModel, (String)"highlighterModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        if (!Intrinsics.areEqual((Object)vFile.getFileType(), (Object)PythonFileType.INSTANCE) && !Intrinsics.areEqual((Object)vFile.getFileType(), (Object)PyiFileType.INSTANCE)) {
            return false;
        }
        if (HighlightingUtilKt.isFromInjection((HighlighterModel)highlighterModel)) {
            return false;
        }
        if (highlighterModel instanceof SyntaxHighlighterModel && StringsKt.startsWith$default((String)highlighterModel.getProperties().getAttributeId(), (String)"IJ.PY.", (boolean)false, (int)2, null)) {
            return true;
        }
        Object object = highlighterModel instanceof DefaultHighlighterModel ? (DefaultHighlighterModel)highlighterModel : null;
        boolean bl = object != null && (object = object.getInfo()) != null && (object = object.getToolId()) != null ? StringsKt.endsWith$default((String)object, (String)"DefaultHighlightVisitor", (boolean)false, (int)2, null) : false;
        if (bl) {
            return true;
        }
        if (Intrinsics.areEqual((Object)highlighterModel.getProperties().getAttributeId(), (Object)("IJ." + PyHighlighter.PY_KEYWORD.getExternalName()))) {
            return true;
        }
        TextAttributesKeyModel textAttributesKeyModel = highlighterModel.getTextAttributesKey();
        String attributeName = textAttributesKeyModel != null ? textAttributesKeyModel.getExternalName() : null;
        return Intrinsics.areEqual((Object)attributeName, (Object)CodeInsightColors.MATCHED_BRACE_ATTRIBUTES.getExternalName()) || Intrinsics.areEqual((Object)attributeName, (Object)CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES.getExternalName());
    }
}

