/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportQuickFix;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "intellij.javascript.codeinsight"})
public final class ES6ConvertModuleExportToExportInspection
extends JSInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new JSElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            /*
             * Unable to fully structure code
             */
            public void visitJSAssignmentExpression(JSAssignmentExpression assignment) {
                Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
                if (!DialectDetector.hasFeature((PsiElement)((PsiElement)assignment), (JSLanguageFeature)JSLanguageFeature.EXPORT_DECLARATIONS)) {
                    return;
                }
                v0 = com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportInspection$Companion.access$checkAssignmentGetDefinitionReference(ES6ConvertModuleExportToExportInspection.Companion, assignment);
                if (v0 == null) {
                    return;
                }
                nameParts = v0;
                v1 = com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportInspection$Companion.access$isExport(ES6ConvertModuleExportToExportInspection.Companion, nameParts, false);
                if (v1 == null) {
                    return;
                }
                exportedNameParts = v1;
                v2 = exportedName = exportedNameParts.isEmpty() != false ? null : (String)exportedNameParts.get(0);
                if (Intrinsics.areEqual((Object)"exports", nameParts.get(0)) && exportedNameParts.isEmpty() || exportedNameParts.size() > 1) ** GOTO lbl-1000
                if (exportedNameParts.isEmpty()) ** GOTO lbl-1000
                if (Intrinsics.areEqual((Object)exportedName, (Object)"prototype") || Intrinsics.areEqual((Object)exportedName, (Object)"constructor")) ** GOTO lbl-1000
                v3 = exportedName;
                v4 = v3 != null ? StringsKt.startsWith$default((String)v3, (String)"[", (boolean)false, (int)2, null) : false;
                if (v4) lbl-1000:
                // 3 sources

                {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                onlyHighlight = v5;
                v6 = assignment.getDefinitionExpression();
                Intrinsics.checkNotNull((Object)v6);
                v7 = v6.getExpression();
                if (v7 == null) {
                    var8_6 = "Required value was null.";
                    throw new IllegalStateException(var8_6.toString());
                }
                expression = v7;
                if (onlyHighlight) {
                    this.$holder.registerProblem((PsiElement)expression, JavaScriptBundle.message((String)"js.convert.module.exports.into.es6.export.inspection.text", (Object[])new Object[0]), new LocalQuickFix[0]);
                } else {
                    var7_8 = new LocalQuickFix[]{new ES6ConvertModuleExportToExportQuickFix(assignment, exportedName)};
                    this.$holder.registerProblem((PsiElement)expression, JavaScriptBundle.message((String)"js.convert.module.exports.into.es6.export.inspection.text", (Object[])new Object[0]), var7_8);
                }
            }
        };
    }

    @JvmStatic
    public static final boolean checkContext(@NotNull JSAssignmentExpression assignment) {
        return Companion.checkContext(assignment);
    }

    @JvmStatic
    @Nullable
    public static final List<String> checkAssignmentToBeExport(@NotNull JSAssignmentExpression assignment) {
        return Companion.checkAssignmentToBeExport(assignment);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J&\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection$Companion;", "", "<init>", "()V", "checkContext", "", "assignment", "Lcom/intellij/lang/javascript/psi/JSAssignmentExpression;", "checkAssignmentGetDefinitionReference", "", "", "checkAssignmentToBeExport", "isExport", "nameParts", "ignoreShortDefaultExport", "intellij.javascript.codeinsight"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean checkContext(@NotNull JSAssignmentExpression assignment) {
            Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
            if (!ES6ConvertRequireIntoImportInspection.checkElementIsOnTopLevel((JSElement)assignment)) {
                return false;
            }
            PsiElement parent = assignment.getParent();
            return parent instanceof JSSourceElement || parent instanceof JSCommaExpression;
        }

        private final List<String> checkAssignmentGetDefinitionReference(JSAssignmentExpression assignment) {
            if (assignment.getOperationSign() != JSTokenTypes.EQ) {
                return null;
            }
            JSDefinitionExpression definition = assignment.getDefinitionExpression();
            if (definition == null || definition.getInitializerOrStub() == null || definition.getExpression() == null) {
                return null;
            }
            if (!this.checkContext(assignment)) {
                return null;
            }
            JSExpression jSExpression = definition.getExpression();
            Intrinsics.checkNotNull((Object)jSExpression);
            return JSSymbolUtil.getReferenceParts((JSExpression)jSExpression);
        }

        @JvmStatic
        @Nullable
        public final List<String> checkAssignmentToBeExport(@NotNull JSAssignmentExpression assignment) {
            Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
            List<String> list = this.checkAssignmentGetDefinitionReference(assignment);
            if (list == null) {
                return null;
            }
            List<String> nameParts = list;
            return this.isExport(nameParts, true);
        }

        private final List<String> isExport(List<String> nameParts, boolean ignoreShortDefaultExport) {
            if (Intrinsics.areEqual((Object)nameParts.get(0), (Object)"exports")) {
                return ignoreShortDefaultExport && nameParts.size() == 1 ? null : nameParts.subList(1, nameParts.size());
            }
            if (Intrinsics.areEqual((Object)nameParts.get(0), (Object)"module") && nameParts.size() > 1 && Intrinsics.areEqual((Object)nameParts.get(1), (Object)"exports")) {
                return nameParts.subList(2, nameParts.size());
            }
            return null;
        }

        public static final /* synthetic */ List access$checkAssignmentGetDefinitionReference(Companion $this, JSAssignmentExpression assignment) {
            return $this.checkAssignmentGetDefinitionReference(assignment);
        }

        public static final /* synthetic */ List access$isExport(Companion $this, List nameParts, boolean ignoreShortDefaultExport) {
            return $this.isExport(nameParts, ignoreShortDefaultExport);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

