/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.parsing.JSDocParsing;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.validation.JSValidationUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public final class JSValidateJSDocInspection
extends JSInspection {
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSValidateJSDocInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSValidateJSDocInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSDocTagType(@NotNull JSDocTagType tagType) {
                if (tagType == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSValidateJSDocInspection.checkReferences((PsiElement)tagType, holder);
            }

            public void visitJSDocTagNamepath(@NotNull JSDocTagNamepath tagNamepath) {
                if (tagNamepath == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSValidateJSDocInspection.checkReferences((PsiElement)tagNamepath, holder);
            }

            public void visitJSDocTagDescription(@NotNull JSDocDescription tagDescription) {
                if (tagDescription == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSValidateJSDocInspection.checkReferences((PsiElement)tagDescription, holder);
            }

            public void visitJSDocComment(@NotNull JSDocComment docComment) {
                if (docComment == null) {
                    1.$$$reportNull$$$0(3);
                }
                JSValidateJSDocInspection.checkReferences((PsiElement)docComment, holder);
            }

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (JSDocParsing.isInsideJSDoc((PsiElement)element)) {
                    TextRange parentTextRange;
                    int startOffsetInParent;
                    PsiElement parent = element.getParent();
                    TextRange rangeInParent = new TextRange(startOffsetInParent, startOffsetInParent + ((startOffsetInParent = element.getStartOffsetInParent()) == (parentTextRange = parent.getTextRange()).getLength() ? 0 : 1));
                    holder.registerProblem(parent, rangeInParent, element.getErrorDescription(), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tagType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tagNamepath";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tagDescription";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "docComment";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSValidateJSDocInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDocTagType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDocTagNamepath";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDocTagDescription";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSDocComment";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitErrorElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void checkReferences(PsiElement element, ProblemsHolder holder) {
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)element, () -> {
            for (PsiReference ref : element.getReferences()) {
                if (ref instanceof JSDocParamReference || JSValidationUtils.hasImportReferences(element) || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref, (boolean)false)) continue;
                holder.registerProblem(ref, ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSValidateJSDocInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

