/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.intentions.destructuring.JSGenerateDestructuringPatternIntentionKt;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.recordImpl.ComputedPropertySignatureImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u0012H\u0002JB\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J>\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/intentions/destructuring/JSDestructuringVariantsEvaluator;", "", "context", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "names", "", "", "depth", "", "evaluateVariants", "", "jsType", "Lcom/intellij/lang/javascript/psi/JSType;", "shouldSkipDestructuring", "", "getTupleVariants", "Lcom/intellij/lang/javascript/psi/types/JSTupleType;", "blowPrefixes", "", "prefixes", "variants", "size", "i", "rparen", "getObjectVariants", "type", "Lcom/intellij/lang/javascript/psi/JSRecordType;", "appendSignature", "name", "signature", "Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;", "intellij.javascript.codeinsight"})
@SourceDebugExtension(value={"SMAP\nJSGenerateDestructuringPatternIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSGenerateDestructuringPatternIntention.kt\ncom/intellij/lang/javascript/intentions/destructuring/JSDestructuringVariantsEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n777#2:332\n873#2,2:333\n1807#2,3:335\n812#2,12:338\n1586#2:350\n1661#2,3:351\n*S KotlinDebug\n*F\n+ 1 JSGenerateDestructuringPatternIntention.kt\ncom/intellij/lang/javascript/intentions/destructuring/JSDestructuringVariantsEvaluator\n*L\n199#1:332\n199#1:333,2\n203#1:335,3\n265#1:338,12\n292#1:350\n292#1:351,3\n*E\n"})
public final class JSDestructuringVariantsEvaluator {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final Set<String> names;
    private int depth;

    public JSDestructuringVariantsEvaluator(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.names = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> evaluateVariants(@Nullable JSType jsType) {
        List<String> list;
        if (jsType == null || this.depth > 10) {
            return CollectionsKt.emptyList();
        }
        JSType type = JSTypeUtils.getValuableType((JSType)jsType, (PsiElement)this.context);
        if (this.shouldSkipDestructuring(type)) {
            return CollectionsKt.emptyList();
        }
        if (type instanceof JSUnionType && !((JSUnionType)type).isSourceStrict() && ((JSUnionType)type).isAnyType()) {
            void $this$filterTo$iv$iv;
            List list2 = ((JSUnionType)type).getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypes(...)");
            List types = list2;
            Iterable $this$filter$iv = types;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JSType it = (JSType)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof JSAnyType))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredTypes = (List)destination$iv$iv;
            type = JSCompositeTypeFactory.createUnionType((JSTypeSource)((JSUnionType)type).getSource(), (Collection)filteredTypes);
        }
        if (type instanceof JSUnionOrIntersectionType) {
            boolean bl;
            block11: {
                List list3 = ((JSUnionOrIntersectionType)type).getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypes(...)");
                Iterable $this$any$iv = list3;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JSType it = (JSType)element$iv;
                        boolean bl2 = false;
                        if (!this.shouldSkipDestructuring(it)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return CollectionsKt.emptyList();
            }
        }
        if (type instanceof JSTupleType) {
            list = this.getTupleVariants((JSTupleType)type);
        } else {
            JSType jSType = type;
            Intrinsics.checkNotNull((Object)jSType);
            JSRecordType jSRecordType = jSType.asRecordType();
            Intrinsics.checkNotNullExpressionValue((Object)jSRecordType, (String)"asRecordType(...)");
            list = this.getObjectVariants(jSRecordType);
        }
        return list;
    }

    private final boolean shouldSkipDestructuring(JSType jsType) {
        if (jsType instanceof JSPrimitiveType || jsType instanceof JSAnyType) {
            return true;
        }
        if (!(jsType instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo jSResolvedTypeInfo = ((JSResolvableType)jsType).resolveType();
        Intrinsics.checkNotNullExpressionValue((Object)jSResolvedTypeInfo, (String)"resolveType(...)");
        JSResolvedTypeInfo info = jSResolvedTypeInfo;
        return info.isEnum() || info.isEnumLiteral();
    }

    private final List<String> getTupleVariants(JSTupleType jsType) {
        List<String> prefixes = (List<String>)new SmartList();
        prefixes.add("[");
        int size = jsType.getMaxLength();
        for (int i = 0; i < size; ++i) {
            String newName;
            List list;
            JSType type = jsType.getTypeByIndex(i);
            if (JSGenerateDestructuringPatternIntentionKt.isApplicableType(type, false)) {
                ArrayList arrayList;
                int n = this.depth;
                this.depth = n + 1;
                ArrayList it = arrayList = new ArrayList(this.evaluateVariants(type));
                boolean bl = false;
                int n2 = this.depth;
                this.depth = n2 + -1;
                list = arrayList;
            } else {
                list = new ArrayList();
            }
            List variants = list;
            Intrinsics.checkNotNullExpressionValue((Object)JSNameSuggestionsUtil.ensureUniqueVariableName((String)JSNameSuggestionsUtil.generateOrdinal((int)i), (PsiElement)this.context, (Collection)this.names, (boolean)false), (String)"ensureUniqueVariableName(...)");
            variants.add(0, newName);
            this.names.add(newName);
            prefixes = this.blowPrefixes(prefixes, variants, size, i, "]");
        }
        return prefixes;
    }

    private final List<String> blowPrefixes(List<String> prefixes, List<String> variants, int size, int i, String rparen) {
        ArrayList<CallSite> newPrefixes = new ArrayList<CallSite>(prefixes.size() * variants.size());
        String comma = i == 0 ? "" : ", ";
        String rbrace = i == size - 1 ? rparen : "";
        for (String prefix : prefixes) {
            for (String variant : variants) {
                newPrefixes.add((CallSite)((Object)(prefix + comma + variant + rbrace)));
            }
        }
        return newPrefixes;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getObjectVariants(JSRecordType type) {
        int i;
        void $this$filterIsInstanceTo$iv$iv;
        if (!type.hasProperties()) {
            return CollectionsKt.emptyList();
        }
        List<String> prefixes = (List<String>)new SmartList();
        prefixes.add("{");
        List list = ContainerUtil.sorted((Collection)type.getPropertyNames());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sorted(...)");
        List allNames = list;
        Collection collection = type.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProperties(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ComputedPropertySignatureImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List computedProperties = (List)destination$iv$iv;
        int size = allNames.size() + computedProperties.size();
        for (i = 0; i < allNames.size(); ++i) {
            String name = (String)allNames.get(i);
            JSRecordType.PropertySignature signature = type.findPropertySignature(name);
            Intrinsics.checkNotNull((Object)name);
            prefixes = this.appendSignature(prefixes, size, i, name, signature);
        }
        for (ComputedPropertySignatureImpl property : computedProperties) {
            prefixes = this.appendSignature(prefixes, size, i, "[" + property.getNameRef() + "]", (JSRecordType.PropertySignature)property);
            ++i;
        }
        return prefixes;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> appendSignature(List<String> prefixes, int size, int i, String name, JSRecordType.PropertySignature signature) {
        List list;
        JSType signatureType;
        JSType jSType = signatureType = signature == null ? null : TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)signature.getJSType(), (PsiElement)this.context);
        if (JSGenerateDestructuringPatternIntentionKt.isApplicableType(signatureType, false)) {
            void $this$mapTo$iv$iv;
            int n = this.depth;
            this.depth = n + 1;
            ArrayList $this$map$iv = (ArrayList)this.evaluateVariants(signatureType);
            boolean $i$f$map = false;
            ArrayList arrayList = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void v;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(name + ": " + (String)v);
            }
            Collection collection = (List)destination$iv$iv;
            ArrayList it = $this$map$iv = new ArrayList(collection);
            boolean bl = false;
            int n2 = this.depth;
            this.depth = n2 + -1;
            list = $this$map$iv;
        } else {
            list = new ArrayList();
        }
        List variants = list;
        Object newName = JSSymbolUtil.isValidPropertyName((String)name) ? name : "prop" + i;
        String string = JSNameSuggestionsUtil.ensureUniqueVariableName((String)newName, (PsiElement)this.context, (Collection)this.names, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ensureUniqueVariableName(...)");
        newName = string;
        variants.add(0, Intrinsics.areEqual((Object)name, (Object)newName) ? name : name + ": " + (String)newName);
        this.names.add((String)newName);
        return this.blowPrefixes(prefixes, variants, size, i, "}");
    }
}

