/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSParameterIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J3\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0096\u0002J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "referenceExpression", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "myReferencedName", "", "<init>", "(Lcom/intellij/lang/javascript/psi/JSReferenceExpression;Ljava/lang/String;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "file", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "node", "hasUsages", "", "startInWriteAction", "getElementToMakeWritable", "currentFile", "Companion", "intellij.javascript.codeinsight"})
public final class CreateJSParameterIntentionAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myReferencedName;

    public CreateJSParameterIntentionAction(@Nullable JSReferenceExpression referenceExpression, @NotNull String myReferencedName) {
        Intrinsics.checkNotNullParameter((Object)myReferencedName, (String)"myReferencedName");
        super((PsiElement)referenceExpression);
        this.myReferencedName = myReferencedName;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.myReferencedName};
        String string = JavaScriptBundle.message((String)"javascript.fix.create.parameter", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.create.variable.intention.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        JSReferenceExpression node = (JSReferenceExpression)startElement;
        JSFunction jSFunction = CreateJSParameterIntentionAction.Companion.getJSFunction((PsiElement)node);
        if (jSFunction == null) {
            return;
        }
        JSFunction function = jSFunction;
        SmartPsiElementPointer functionPtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)function));
        SmartPsiElementPointer nodePtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)node));
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)function))) {
            JSFunction jSFunction2 = (JSFunction)functionPtr.getElement();
            if (jSFunction2 == null) {
                return;
            }
            JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)nodePtr.getElement();
            if (jSReferenceExpression == null) {
                return;
            }
            this.invoke(project, psiFile, editor, jSFunction2, jSReferenceExpression, false);
        } else {
            String string = JavaScriptBundle.message((String)"progress.title.find.usages", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            boolean hasUsages2 = (Boolean)TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>((SmartPsiElementPointer<JSFunction>)functionPtr, null){
                int label;
                final /* synthetic */ SmartPsiElementPointer<JSFunction> $functionPtr;
                {
                    this.$functionPtr = $functionPtr;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.readAction(() -> invoke.hasUsages.1.invokeSuspend$lambda$0(this.$functionPtr), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final boolean invokeSuspend$lambda$0(SmartPsiElementPointer $functionPtr) {
                    JSFunction jSFunction = (JSFunction)$functionPtr.getElement();
                    if (jSFunction == null) {
                        return false;
                    }
                    return com.intellij.lang.javascript.validation.fixes.CreateJSParameterIntentionAction$Companion.access$hasUsages(CreateJSParameterIntentionAction.Companion, jSFunction);
                }
            }));
            WriteAction.run(() -> CreateJSParameterIntentionAction.invoke$lambda$0(this, project, psiFile, editor, functionPtr, nodePtr, hasUsages2));
        }
    }

    private final void invoke(Project project, PsiFile file, Editor editor, JSFunction function, JSReferenceExpression node, boolean hasUsages2) {
        JSParameterInserter jSParameterInserter = JSParameterInserter.build(function);
        if (jSParameterInserter == null) {
            return;
        }
        JSParameterInserter parameterInserter = jSParameterInserter;
        String type = null;
        boolean isActionScript = DialectDetector.isActionScript((PsiElement)((PsiElement)node));
        if (isActionScript) {
            type = BaseCreateFix.guessTypeForExpression((JSExpression)((JSExpression)node), (PsiElement)((PsiElement)file), (boolean)false);
        }
        if (hasUsages2 && !IntentionPreviewUtils.isPreviewElement((PsiElement)((PsiElement)function)) && editor != null) {
            TextRange textRange = node.getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            String finalType = type;
            new JSIntroduceParameterHandler(parameterInserter, finalType, node){
                final /* synthetic */ JSParameterInserter $parameterInserter;
                final /* synthetic */ String $finalType;
                final /* synthetic */ JSReferenceExpression $node;
                {
                    this.$parameterInserter = $parameterInserter;
                    this.$finalType = $finalType;
                    this.$node = $node;
                }

                protected JSIntroduceParameterSettings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
                    Intrinsics.checkNotNullParameter(expressionDescriptor, (String)"expressionDescriptor");
                    Intrinsics.checkNotNullParameter((Object)occurrences, (String)"occurrences");
                    return ApplicationManager.getApplication().isUnitTestMode() ? (JSIntroduceParameterSettings)new JSIntroduceParameterSettings.Base(expressionDescriptor, this.$parameterInserter, this.$finalType, this.$node){
                        final /* synthetic */ JSParameterInserter $parameterInserter;
                        final /* synthetic */ String $finalType;
                        final /* synthetic */ JSReferenceExpression $node;
                        {
                            this.$parameterInserter = $parameterInserter;
                            this.$finalType = $finalType;
                            this.$node = $node;
                            super($expressionDescriptor);
                        }

                        public boolean addOptionalParameter() {
                            return this.$parameterInserter.mustBeOptional();
                        }

                        public String getInitialValue() {
                            String string = JSTypeUtils.defaultValueOfType((String)this.$finalType);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultValueOfType(...)");
                            return string;
                        }

                        public boolean isReplaceAllOccurrences() {
                            return true;
                        }

                        public String getVariableName() {
                            return this.$node.getReferencedName();
                        }

                        public String getVariableType() {
                            return this.$finalType;
                        }
                    } : (JSIntroduceParameterSettings)super.getSettings(project, editor, expressionDescriptor, occurrences, scope);
                }
            }.invoke(project, editor, file, DataManager.getInstance().getDataContext());
            return;
        }
        Object typeDecoration = "";
        if (isActionScript && type != null) {
            typeDecoration = (String)typeDecoration + ":" + type;
        }
        boolean mustBeOptional = parameterInserter.mustBeOptional();
        String introduced = node.getReferencedName() + (String)typeDecoration;
        if (mustBeOptional) {
            introduced = introduced + "=" + JSTypeUtils.defaultValueOfType((String)type);
        }
        String finalIntroduced = introduced;
        JSParameter parameter = parameterInserter.doInsert(finalIntroduced, mustBeOptional, "");
        CodeStyleManager.getInstance((Project)project).reformat(parameter.getParent());
    }

    public boolean startInWriteAction() {
        return IntentionPreviewUtils.isIntentionPreviewActive();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        if (this.myStartElement != null) {
            return (PsiElement)this.myStartElement.getContainingFile();
        }
        return (PsiElement)currentFile;
    }

    private static final void invoke$lambda$0(CreateJSParameterIntentionAction this$0, Project $project, PsiFile $psiFile, Editor $editor, SmartPsiElementPointer $functionPtr, SmartPsiElementPointer $nodePtr, boolean $hasUsages) {
        JSFunction jSFunction = (JSFunction)$functionPtr.getElement();
        if (jSFunction == null) {
            return;
        }
        JSReferenceExpression jSReferenceExpression = (JSReferenceExpression)$nodePtr.getElement();
        if (jSReferenceExpression == null) {
            return;
        }
        this$0.invoke($project, $psiFile, $editor, jSFunction, jSReferenceExpression, $hasUsages);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction$Companion;", "", "<init>", "()V", "getJSFunction", "Lcom/intellij/lang/javascript/psi/JSFunction;", "element", "Lcom/intellij/psi/PsiElement;", "hasUsages", "", "function", "intellij.javascript.codeinsight"})
    public static final class Companion {
        private Companion() {
        }

        private final JSFunction getJSFunction(PsiElement element) {
            Class[] classArray = new Class[]{JSFunction.class};
            return (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])classArray);
        }

        private final boolean hasUsages(JSFunction function) {
            if (function == null) {
                return false;
            }
            boolean noRefsFound = ReferencesSearch.search((PsiElement)((PsiElement)function)).forEach(Companion::hasUsages$lambda$0);
            return !noRefsFound;
        }

        private static final boolean hasUsages$lambda$0(PsiReference it) {
            return JSResolveUtil.isSelfReference((PsiElement)it.getElement());
        }

        public static final /* synthetic */ boolean access$hasUsages(Companion $this, JSFunction function) {
            return $this.hasUsages(function);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

