/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/ES6ConvertDefaultImportToSpecifierFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "<init>", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;)V", "bindingName", "", "getBindingName", "()Ljava/lang/String;", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "memberWithBindingNameIsAvailableFromModule", "declaration", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "intellij.javascript.codeinsight"})
@SourceDebugExtension(value={"SMAP\nES6ConvertDefaultImportToSpecifierFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConvertDefaultImportToSpecifierFix.kt\ncom/intellij/lang/javascript/validation/fixes/ES6ConvertDefaultImportToSpecifierFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ES6ConvertDefaultImportToSpecifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String bindingName;

    public ES6ConvertDefaultImportToSpecifierFix(@NotNull ES6ImportedBinding element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        String string = StringUtil.notNullize((String)element.getDeclaredName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
        this.bindingName = string;
    }

    @NotNull
    public final String getBindingName() {
        return this.bindingName;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.bindingName};
        String string = JavaScriptBundle.message((String)"es6.change.to.named.import.fix", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!this.isAvailable(project, psiFile, startElement, endElement)) {
            return;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportedBinding)startElement).getDeclaration();
        Intrinsics.checkNotNull((Object)eS6ImportDeclaration);
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        WriteAction.run(() -> ES6ConvertDefaultImportToSpecifierFix.invoke$lambda$0(this, declaration));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Object v2;
        ES6ImportDeclaration declaration;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!(startElement instanceof ES6ImportedBinding)) {
                return false;
            }
            ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportedBinding)startElement).getDeclaration();
            if (eS6ImportDeclaration == null) {
                return false;
            }
            declaration = eS6ImportDeclaration;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)declaration))) {
                return false;
            }
            ES6ImportSpecifier[] eS6ImportSpecifierArray = declaration.getImportSpecifiers();
            Intrinsics.checkNotNullExpressionValue((Object)eS6ImportSpecifierArray, (String)"getImportSpecifiers(...)");
            Sequence sequence = ArraysKt.asSequence((Object[])eS6ImportSpecifierArray);
            for (Object e : sequence) {
                ES6ImportSpecifier it = (ES6ImportSpecifier)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.bindingName, (Object)it.getReferenceName())) continue;
                v2 = e;
                break block4;
            }
            v2 = null;
        }
        return v2 == null && this.memberWithBindingNameIsAvailableFromModule(declaration);
    }

    private final boolean memberWithBindingNameIsAvailableFromModule(ES6ImportDeclaration declaration) {
        Object v2;
        block3: {
            ES6FromClause fromClause = declaration.getFromClause();
            if (fromClause == null) {
                return false;
            }
            PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)((PsiElement)declaration));
            if (!(module instanceof JSElement)) {
                return false;
            }
            Collection collection = fromClause.resolveReferencedElements();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveReferencedElements(...)");
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), ES6ConvertDefaultImportToSpecifierFix::memberWithBindingNameIsAvailableFromModule$lambda$0);
            for (Object e : sequence) {
                Object[] symbolsInModule;
                JSElement it = (JSElement)e;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)ES6PsiUtil.resolveSymbolInModule((String)this.bindingName, (PsiElement)((PsiElement)declaration), (JSElement)it), (String)"resolveSymbolInModule(...)");
                ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])symbolsInModule);
                Object element = resolveResult != null ? resolveResult.getElement() : null;
                if (!(element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExported())) continue;
                v2 = e;
                break block3;
            }
            v2 = null;
        }
        return v2 != null;
    }

    private static final void invoke$lambda$0(ES6ConvertDefaultImportToSpecifierFix this$0, ES6ImportDeclaration $declaration) {
        block4: {
            ES6ImportedBinding newBinding;
            Object v3;
            block3: {
                ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(this$0.bindingName, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                ES6ImportSpecifier eS6ImportSpecifier = ES6ImportPsiUtil.insertImportSpecifier((ES6ImportDeclaration)$declaration, (ES6ImportPsiUtil.CreateImportExportInfo)createImportExportInfo);
                if (eS6ImportSpecifier == null) {
                    return;
                }
                ES6ImportSpecifier insertImportSpecifier = eS6ImportSpecifier;
                ES6ImportDeclaration eS6ImportDeclaration = insertImportSpecifier.getDeclaration();
                if (eS6ImportDeclaration == null) {
                    return;
                }
                ES6ImportDeclaration eS6ImportDeclaration2 = eS6ImportDeclaration;
                ES6ImportedBinding[] eS6ImportedBindingArray = eS6ImportDeclaration2.getImportedBindings();
                Intrinsics.checkNotNullExpressionValue((Object)eS6ImportedBindingArray, (String)"getImportedBindings(...)");
                Sequence sequence = ArraysKt.asSequence((Object[])eS6ImportedBindingArray);
                for (Object e : sequence) {
                    ES6ImportedBinding it = (ES6ImportedBinding)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDeclaredName(), (Object)this$0.bindingName)) continue;
                    v3 = e;
                    break block3;
                }
                v3 = null;
            }
            ES6ImportedBinding eS6ImportedBinding = newBinding = (ES6ImportedBinding)v3;
            if (eS6ImportedBinding == null) break block4;
            eS6ImportedBinding.delete();
        }
    }

    private static final JSElement memberWithBindingNameIsAvailableFromModule$lambda$0(PsiElement it) {
        return it instanceof JSElement ? (JSElement)it : null;
    }
}

