/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext.python.run.sphinx;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.restructuredtext.python.PythonRestBundle;
import com.intellij.restructuredtext.python.run.RestConfigurationEditor;
import com.intellij.restructuredtext.python.run.RestRunConfiguration;
import com.intellij.restructuredtext.python.run.sphinx.SphinxCommandLineState;
import com.intellij.restructuredtext.python.run.sphinx.SphinxTasksModel;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\tH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/restructuredtext/python/run/sphinx/SphinxRunConfiguration;", "Lcom/intellij/restructuredtext/python/run/RestRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "createConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "checkConfiguration", "", "suggestedName", "", "intellij.restructuredtext.python"})
public final class SphinxRunConfiguration
extends RestRunConfiguration {
    public SphinxRunConfiguration(@Nullable Project project, @Nullable ConfigurationFactory factory) {
        super(project, factory);
    }

    @NotNull
    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        SphinxTasksModel model = new SphinxTasksModel();
        Sdk sdk = this.getSdk();
        if (!model.contains("pdf") && sdk != null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk);
            boolean isInstalled = PythonPackageManagerExt.hasInstalledPackageSnapshot$default((PythonPackageManager)packageManager, (String)"rst2pdf", null, (int)2, null);
            if (isInstalled) {
                model.add(13, "pdf");
            }
        }
        RestConfigurationEditor editor = new RestConfigurationEditor(this.getProject(), this, model);
        editor.setConfigurationName("Sphinx task");
        editor.setOpenInBrowserVisible(false);
        editor.setInputDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor());
        editor.setOutputDescriptor(FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return editor;
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        return (RunProfileState)new SphinxCommandLineState(this, env);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        CharSequence charSequence = this.getInputFile();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeConfigurationError(PythonRestBundle.message("python.rest.specify.input.directory.name", new Object[0]));
        }
        charSequence = this.getOutputFile();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeConfigurationError(PythonRestBundle.message("python.rest.specify.output.directory.name", new Object[0]));
        }
    }

    @NotNull
    public String suggestedName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.getName(), (String)"getName(...)");
        return PythonRestBundle.message("python.rest.sphinx.run.cfg.default.name", objectArray);
    }
}

