/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.maven;

import com.intellij.indexing.shared.java.maven.MavenPackageCoordinatesInferenceExtension;
import com.intellij.indexing.shared.java.maven.MavenPackageId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/java/maven/MavenJarHelper;", "", "<init>", "()V", "INFERENCE_EXT_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/indexing/shared/java/maven/MavenPackageCoordinatesInferenceExtension;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "listAllJarCoordinates", "", "Lcom/intellij/indexing/shared/java/maven/MavenPackageId;", "project", "Lcom/intellij/openapi/project/Project;", "inferPackageCoordinates", "path", "", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nMavenJarHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenJarHelper.kt\ncom/intellij/indexing/shared/java/maven/MavenJarHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,52:1\n23#2:53\n*S KotlinDebug\n*F\n+ 1 MavenJarHelper.kt\ncom/intellij/indexing/shared/java/maven/MavenJarHelper\n*L\n16#1:53\n*E\n"})
public final class MavenJarHelper {
    @NotNull
    public static final MavenJarHelper INSTANCE = new MavenJarHelper();
    @NotNull
    private static final ExtensionPointName<MavenPackageCoordinatesInferenceExtension> INFERENCE_EXT_EP = new ExtensionPointName("com.intellij.indexing.shared.java.maven.mavenPackageCoordinatesInferenceExtension");
    @NotNull
    private static final Logger LOG;

    private MavenJarHelper() {
    }

    @NotNull
    public final Set<MavenPackageId> listAllJarCoordinates(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WorkspaceModel model = WorkspaceModel.Companion.getInstance(project);
        Sequence libraries = model.getCurrentSnapshot().entities(LibraryEntity.class);
        return SequencesKt.toHashSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)libraries, MavenJarHelper::listAllJarCoordinates$lambda$0), MavenJarHelper::listAllJarCoordinates$lambda$1), MavenJarHelper::listAllJarCoordinates$lambda$2), MavenJarHelper::listAllJarCoordinates$lambda$3), MavenJarHelper::listAllJarCoordinates$lambda$4)), MavenJarHelper::listAllJarCoordinates$lambda$5));
    }

    @Nullable
    public final MavenPackageId inferPackageCoordinates(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{"/"};
        List reverseElements = CollectionsKt.reversed((Iterable)StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (reverseElements.size() <= 5) {
            return null;
        }
        return (MavenPackageId)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)INFERENCE_EXT_EP.getExtensionList()), arg_0 -> MavenJarHelper.inferPackageCoordinates$lambda$0(path, reverseElements, arg_0)));
    }

    private static final Iterable listAllJarCoordinates$lambda$0(LibraryEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRoots();
    }

    private static final boolean listAllJarCoordinates$lambda$1(LibraryRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)LibraryRootTypeId.Companion.getCOMPILED());
    }

    private static final VirtualFile listAllJarCoordinates$lambda$2(LibraryRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl());
    }

    private static final VirtualFile listAllJarCoordinates$lambda$3(VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JarFileSystem.getInstance().getLocalByEntry(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean listAllJarCoordinates$lambda$4(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isDirectory()) return false;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final MavenPackageId listAllJarCoordinates$lambda$5(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return INSTANCE.inferPackageCoordinates(string);
    }

    private static final MavenPackageId inferPackageCoordinates$lambda$0(String $path, List $reverseElements, MavenPackageCoordinatesInferenceExtension it) {
        Object object;
        block2: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            object = INSTANCE;
            try {
                MavenJarHelper $this$inferPackageCoordinates_u24lambda_u240_u240 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)it.infer($path, $reverseElements));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it2 = object2 = throwable;
            boolean bl = false;
            LOG.error((Throwable)it2);
        }
        return (MavenPackageId)(Result.isFailure-impl((Object)object) ? null : object);
    }

    static {
        MavenJarHelper $this$thisLogger$iv = INSTANCE;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(MavenJarHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

