/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.kotlin.correctness;

import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricherBase;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionStringLiteralSupporter;
import com.intellij.ml.inline.completion.kotlin.correctness.KotlinEnrichmentTool;
import com.intellij.ml.inline.completion.kotlin.correctness.KotlinGradleVersionFilteringChecker;
import com.intellij.ml.inline.completion.kotlin.correctness.KotlinHighlightingEnricher;
import com.intellij.ml.inline.completion.kotlin.correctness.KotlinImportDirectiveFilteringChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J8\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/correctness/KotlinSuggestionEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricherBase;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "stringLiteralSupporter", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionStringLiteralSupporter;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionStringLiteralSupporter;)V", "createCopyOfScript", "Lorg/jetbrains/kotlin/psi/KtFile;", "originalFile", "Lcom/intellij/psi/PsiFile;", "newFile", "buildFileWithSuggestion", "suggestionOffset", "", "suggestion", "", "suffix", "matchedEnclosuresIndices", "", "intellij.fullLine.kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/kotlin/correctness/KotlinSuggestionEnricher\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,437:1\n54#2:438\n1#3:439\n*S KotlinDebug\n*F\n+ 1 KotlinSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/kotlin/correctness/KotlinSuggestionEnricher\n*L\n54#1:438\n*E\n"})
public final class KotlinSuggestionEnricher
extends SuggestionEnricherBase {
    public KotlinSuggestionEnricher(@NotNull MLCompletionLanguageKit kit, @NotNull MLCompletionStringLiteralSupporter stringLiteralSupporter) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)stringLiteralSupporter, (String)"stringLiteralSupporter");
        Object[] objectArray = new EnrichmentTool[]{new KotlinImportDirectiveFilteringChecker(), new KotlinEnrichmentTool(kit), new KotlinHighlightingEnricher(), new KotlinGradleVersionFilteringChecker()};
        super(CollectionsKt.listOf((Object[])objectArray), stringLiteralSupporter);
    }

    private final KtFile createCopyOfScript(PsiFile originalFile, KtFile newFile) {
        PsiElement $this$copied$iv = (PsiElement)originalFile;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        PsiElement psiElement2 = (PsiElement)((PsiFile)psiElement);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile newFileCopy = (KtFile)psiElement2;
        KtScript ktScript = newFileCopy.getScript();
        if (ktScript == null || (ktScript = ktScript.getBlockExpression()) == null) {
            return null;
        }
        KtScript copyOfOriginalBlockExpression = ktScript;
        KtScript ktScript2 = newFile.getScript();
        if (ktScript2 == null || (ktScript2 = ktScript2.getBlockExpression()) == null) {
            return null;
        }
        KtScript copiedNewBlockExpression = ktScript2;
        copyOfOriginalBlockExpression.replace(copiedNewBlockExpression.copy());
        return newFileCopy;
    }

    @Override
    @NotNull
    protected PsiFile buildFileWithSuggestion(@NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull String suffix, @Nullable Set<Integer> matchedEnclosuresIndices) {
        KtFile ktFile;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String originalText = originalFile.getText();
        StringBuilder $this$buildFileWithSuggestion_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Set<Integer> set = matchedEnclosuresIndices;
        int matchedSize = set != null ? set.size() : 0;
        $this$buildFileWithSuggestion_u24lambda_u240.append(originalText, 0, suggestionOffset);
        $this$buildFileWithSuggestion_u24lambda_u240.append(suggestion2);
        $this$buildFileWithSuggestion_u24lambda_u240.append(' ');
        $this$buildFileWithSuggestion_u24lambda_u240.append(suffix);
        $this$buildFileWithSuggestion_u24lambda_u240.append(originalText, suggestionOffset + matchedSize, originalText.length());
        String copyText = stringBuilder.toString();
        if (KotlinPluginModeProvider.Companion.isK1Mode()) {
            String string = originalFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null)) {
                Project project2 = originalFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                String string2 = originalFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                KtBlockCodeFragment blockCodeFragment = new KtBlockCodeFragment(project2, string2, (CharSequence)copyText, null, (PsiElement)originalFile);
                return (PsiFile)blockCodeFragment;
            }
        }
        KtPsiFactory ktPsiFactory = KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)originalFile), (boolean)false, (boolean)false, (int)6, null);
        String string = originalFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        KtFile newFile = ktPsiFactory.createFile(string, copyText);
        newFile.setOriginalFile(originalFile);
        String string3 = originalFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string3, (String)".kts", (boolean)false, (int)2, null) && (ktFile = this.createCopyOfScript(originalFile, newFile)) != null) {
            KtFile it = ktFile;
            boolean bl2 = false;
            return (PsiFile)it;
        }
        return (PsiFile)newFile;
    }
}

