/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.json.completion.cloud;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/json/completion/cloud/JsonMultilineSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultilineSupporter;", "<init>", "()V", "isMultilineSuitable", "", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "hasBlockParent", "hasArrayParent", "trailingInParent", "intellij.ml.llm.json.completion"})
public final class JsonMultilineSupporter
implements MLCompletionMultilineSupporter {
    @Override
    public boolean isMultilineSuitable(@NotNull PsiElement element, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (element.getParent() instanceof JsonFile || element instanceof JsonFile) {
            return true;
        }
        if (this.hasBlockParent(element) && !(element.getPrevSibling() instanceof JsonProperty) && this.trailingInParent(element)) {
            return true;
        }
        return this.hasArrayParent(element) && this.trailingInParent(element);
    }

    private final boolean hasBlockParent(PsiElement element) {
        return element.getParent() instanceof JsonObject;
    }

    private final boolean hasArrayParent(PsiElement element) {
        return element.getParent() instanceof JsonArray;
    }

    private final boolean trailingInParent(PsiElement element) {
        PsiElement psiElement = element.getNextSibling();
        if (psiElement == null) {
            return true;
        }
        PsiElement nextSibling = psiElement;
        int n = PsiTreeUtilKt.getEndOffset((PsiElement)nextSibling);
        PsiElement psiElement2 = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
        return n == PsiTreeUtilKt.getEndOffset((PsiElement)psiElement2);
    }
}

