/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.introspector;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.TrigEvent;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.text.StringsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\r\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0016\u0010\u0010\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"ON_UPDATE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "manipulation", "", "getType", "Lcom/intellij/database/model/DasRoutine$Kind;", "type", "getDirection", "Lcom/intellij/database/model/ArgumentDirection;", "mode", "sqlString", "getSqlString", "(Ljava/lang/String;)Ljava/lang/String;", "TRIM_ZEROES", "intellij.database.dialects.mysqlbase"})
public final class MysqlBaseIntrospectorKt {
    private static final Pattern ON_UPDATE = Pattern.compile("(?i)on update (\\S+)");
    private static final Pattern TRIM_ZEROES = Pattern.compile("0*(\\d+)");

    private static final TrigEvent getEvent(String manipulation) {
        return StringsKt.equals((String)"INSERT", (String)manipulation, (boolean)true) ? TrigEvent.INSERT : (StringsKt.equals((String)"DELETE", (String)manipulation, (boolean)true) ? TrigEvent.DELETE : TrigEvent.UPDATE);
    }

    private static final DasRoutine.Kind getType(String type) {
        return StringsKt.equals((String)"FUNCTION", (String)type, (boolean)true) ? DasRoutine.Kind.FUNCTION : (StringsKt.equals((String)"PROCEDURE", (String)type, (boolean)true) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.NONE);
    }

    private static final ArgumentDirection getDirection(String mode) {
        return StringsKt.equals((String)"INOUT", (String)mode, (boolean)true) ? ArgumentDirection.INOUT : (StringsKt.equals((String)"OUT", (String)mode, (boolean)true) ? ArgumentDirection.OUT : ArgumentDirection.IN);
    }

    private static final String getSqlString(String $this$sqlString) {
        return "'" + StringsKt.replace$default((String)$this$sqlString, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    public static final /* synthetic */ String access$getSqlString(String $receiver) {
        return MysqlBaseIntrospectorKt.getSqlString($receiver);
    }

    public static final /* synthetic */ Pattern access$getON_UPDATE$p() {
        return ON_UPDATE;
    }

    public static final /* synthetic */ Pattern access$getTRIM_ZEROES$p() {
        return TRIM_ZEROES;
    }

    public static final /* synthetic */ DasRoutine.Kind access$getType(String type) {
        return MysqlBaseIntrospectorKt.getType(type);
    }

    public static final /* synthetic */ ArgumentDirection access$getDirection(String mode) {
        return MysqlBaseIntrospectorKt.getDirection(mode);
    }

    public static final /* synthetic */ TrigEvent access$getEvent(String manipulation) {
        return MysqlBaseIntrospectorKt.getEvent(manipulation);
    }
}

