/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.languagetool.tools.StringTools;

class PrepositionIssues {
    private static final String PREPOSITION_AFTER_MSG = "The preposition '$Prep' does not seem to fit after '$_'";
    static final NodePattern inNotAdj = NodePattern.N.inFormSequence(0, "in", "not").withNeighbor(2, NodePattern.N.potentialPos("JJ").noForm("only"));
    private static final NodePattern presentPerfect = NodePattern.N.withDependent("aux", NodePattern.N.pos("VB|VBZ").form("have|has")).and(NodePattern.or(NodePattern.N.pos("VBN").noDependents("aux.*", NodePattern.N.lemma("be")), NodePattern.N.withDependent("cop|aux", NodePattern.N.form("been"))));

    PrepositionIssues() {
    }

    static NodePattern grammarRule() {
        return NodePattern.or(PrepositionIssues.verbArgumentPrepositions(), PrepositionIssues.nounAdjunctPrepositions(), PrepositionIssues.typo(), NodePattern.N.form("between").directlyBefore(NodePattern.or(EnglishTreePatterns.singleYearCD, NodePattern.N.form("two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eightteen|nineteen|twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety|dozen|hundred|thousand|million|billion|(ga)?zillion")).directlyBefore(NodePattern.N.pos("IN").markAs("PREP").includeIntoReport())).andOptionally(NodePattern.N.withNeighbor(4, NodePattern.N.form("years?").markAs("YEAR"))).message("'$_' is typically used with 'and' for describing time intervals").and((node, match) -> {
            Node prep = match.getMarkedNode("PREP");
            Node year = match.findMarkedNode("YEAR");
            NodeCorrector removePrep = NodeCorrector.replace(prep, "and");
            NodeCorrector removeYear = year == null ? null : NodeCorrector.replace(year, "");
            return match.withCorrector(removePrep.join(removeYear));
        }), NodePattern.N.form("alongside").directlyBefore(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("obl")).beforeHead().correct(NodeCorrector.replace(""))).message("'Alongside' is typically used without a preposition"), NodePattern.N.inFormSequence(0, "in", "nowadays").correct(NodeCorrector.replace("")).message("'Nowadays' does not require the preposition 'in'"), NodePattern.N.form("near").directlyBefore(NodePattern.N.form("from").withHead("case", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")).markAs("Prep")).andOr(NodePattern.N.withDependent("case", NodePattern.N.form("in").markAs("In")).correct(NodeCorrector.replaceNodes(NodePointer.marked("In"), NodePointer.neighbor(-1), "").join(NodeCorrector.replace(NodePointer.marked("Prep"), ""))).message("'Near' does not need prepositions or determiners"), NodePattern.N.directlyAfter(NodePattern.N.form("very")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "to")).message(PREPOSITION_AFTER_MSG), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Prep"), "")).message(PREPOSITION_AFTER_MSG)), NodePattern.N.lemma("close").markAs("Target").withDependent("cop").and(EnglishTreePatterns.replacePrepInComplement("from", "to")).andOptionally(NodePattern.N.correct(NodeCorrector.replace("further"))).message(PREPOSITION_AFTER_MSG), NodePattern.N.lemma("obvious").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to"))).withDependent("obl", NodePattern.N.afterHead().and(EnglishTreePatterns.replacePreposition("for", "to"))).message("'obvious' typically goes with the preposition 'to'"), NodePattern.N.lemma("worry").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("about"))).withDependent("obl", NodePattern.not(Semantics.timeUnits).noForm("time|now").onlyPos("NN.*").and(EnglishTreePatterns.replacePreposition("for", "about"))).message("'worry' typically goes with the preposition 'about'"), EnglishTreePatterns.singleYearCD.noDependents("nmod").withHead(presentPerfect.noDependents(NodePattern.N.form("more"))).and(EnglishTreePatterns.replacePreposition("from", "since")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").withDependent("nmod", NodePattern.N.afterHead()))).andNot(NodePattern.N.withNextSibling(NodePattern.N.pos("CD"))).message("Use 'since' instead of 'from' with Present Perfect"), NodePattern.or(NodePattern.N.withHead("obl", NodePattern.N.withDependent("aux", NodePattern.N.noLemma("can").onlyPos("MD"))).noDependents("acl|advcl").andNot(NodePattern.N.withPhraseEnd(CommonPatterns.lastToken)).noDependents("nummod", NodePattern.N.afterHead()), CommonPatterns.skipUp("nmod", Semantics.timeUnits.withHead("obl", NodePattern.N.form("longer").withHead("advmod", NodePattern.N.pos("VB").and(EnglishTreePatterns.withModal)))), NodePattern.or(NodePattern.N.form("now"), Semantics.timeUnits.withDependent("amod", NodePattern.N.form("next"))).and(EnglishTreePatterns.replacePreposition("since", ""))).and(EnglishTreePatterns.replacePreposition("since", "from")).message("Use 'from' instead of 'since' when referring to present or future events"), Semantics.timeUnits.withDependent("nummod", NodePattern.N.beforeHead().noDependents()).and(EnglishTreePatterns.replacePreposition("since", "for")).message("Use 'for' instead of 'since' to express duration"), Semantics.timeUnits.withHead("obl", NodePattern.N.pos("VBD").noDependents("cop|aux|aux:pass")).withDependent("case", CommonPatterns.firstChildPhrase.andOr(NodePattern.N.form("before").markAs("Prep"), NodePattern.N.form("for").markAs("Prep").and(CommonPatterns.skipUp("case", NodePattern.N.withHead(NodePattern.N.lemma("move|come|arrive").markAs("SinglePastEvent")))))).noDependents(NodePattern.N.afterHead()).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "").join(NodeCorrector.insertAfter(" ago"))).andOptionally(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("SinglePastEvent").correct(EnglishTreePatterns.changeVerbLemma("live")))).message("Use 'ago' instead of '$Prep' for talking about events in the past"), NodePattern.N.lemma("angry").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("against|with").markAs("Prep")).andOr(NodePattern.or(Semantics.Animacy.humanLike.pattern, Semantics.Animacy.animal.pattern).withDependent("case", NodePattern.N.form("against")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "with", "at")).message("'angry' is typically used with the preposition 'with' or 'at'"), Semantics.Animacy.inanimate.pattern.correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at", "about")).message("'angry' is typically used with the prepositions 'at' or 'about' for inanimate objects"))), NodePattern.N.lemma("blind").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for").markAs("Prep")).andNot(NodePattern.or(Semantics.timeUnits, NodePattern.N.lemma("instant|time")))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "from")).message("'blind' is typically used with the preposition 'from'"), NodePattern.N.lemma("crazy").withHead("advmod|xcomp", NodePattern.N.lemma("make|drive")).directlyBefore(NodePattern.N.form("on").markAs("Prep").withHead("case", NodePattern.N.withDependent("det").noLemma("drug|medicine|narcotic|hallucinogen"))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "with")).message("Use 'crazy with' for causing strong negative emotions"), NodePattern.N.lemma("superior|inferior").andNot(NodePattern.N.inFormSequence(2, "even", "more|less", ".*")).andOr(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("than").markAs("Than")).andOptionally(NodePattern.N.withDependent("case", NodePattern.N.form("in|during")).withHead("obl", NodePattern.N.markAs("NoPrep")))), NodePattern.N.withDependent("advcl", NodePattern.N.withDependent("mark", NodePattern.N.form("than").markAs("Than"))).markAs("ToWhat")).andOptionally(NodePattern.N.withDependent("advmod", NodePattern.N.form("more").markAs("More").andOptionally(NodePattern.N.withDependent("advmod", NodePattern.N.form("much").markAs("Much"))))).and((node, match) -> {
            NodeCorrector thanCorrector;
            String msg;
            NodeCorrector muchFar;
            Node than = match.getMarkedNode("Than");
            Node more = match.findMarkedNode("More");
            Node much = match.findMarkedNode("Much");
            NodeCorrector removeMore = more == null ? null : NodeCorrector.replace(more, "");
            NodeCorrector nodeCorrector = muchFar = much == null ? null : NodeCorrector.replace(much, "far");
            if (match.findMarkedNode("NoPrep") == node) {
                msg = "'than' is not required after " + node.quotedPresentableText() + " before prepositional phrases";
                thanCorrector = NodeCorrector.replace(than, "");
            } else if (match.findMarkedNode("ToWhat") == node) {
                msg = "Use 'to what' after " + node.quotedPresentableText() + " with a dependent clause";
                thanCorrector = NodeCorrector.replace(than, "to what");
            } else {
                msg = "Use 'to' after " + node.quotedPresentableText();
                thanCorrector = NodeCorrector.replace(than, "to");
            }
            return match.withMessage(msg).withCorrector(thanCorrector.join(muchFar).join(removeMore));
        }), NodePattern.N.lemma("anxious").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("of").markAs("Prep").andNot(NodePattern.N.form("course").noDependents("det|nmod:poss|amod|obl|nmod|acl(:relcl)?")))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "about", "for")).message("Use 'anxious about' to express the cause of anxiety and 'anxious for' to express anticipation")).andNot(CommonPatterns.insideQuotes);
    }

    static Rule.PatternRule styleRule() {
        return new Rule.PatternRule("Style.UNCOMMON_PREPOSITION", "Uncommon preposition", "Some expressions are more commonly used with certain prepositions or without any.", null, () -> NodePattern.N.lemma("advertisement").withDependent("obl|nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of").correct(NodeCorrector.replace("for"))).andNot(Semantics.timeUnits).noForm("duration|standing|sorts|quality|character|nature").andNot(EnglishTreePatterns.typeSynonyms)).message("'advertisement' is more commonly used with the preposition 'for'"), new Example("Surely you saw an advertisement <b>of</b> the so-called \"anti-cellulite jeans\".", "Surely you saw an advertisement <b>for</b> the so-called \"anti-cellulite jeans\"."));
    }

    private static NodePattern typo() {
        Set<String> exclude = Set.of("up", "atop", "ago", "re");
        NodePattern foreignWord = NodePattern.or(NodePattern.N.inFormSequence(0, "vis", "-", ".", "-", "vis"), NodePattern.N.form("al").withHead(NodePattern.N.noPos())).trace("foreignWord");
        return NodePattern.or(NodePattern.N.inFormSequence(0, "in", "not|so").withNeighbor(2, NodePattern.or(CommonPatterns.comma, EnglishTreePatterns.sentenceBoundary)).and(EnglishTreePatterns.typoReplacement("if")), inNotAdj.andNot(NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("obl"))).andNot(NodePattern.N.withHead("mark", NodePattern.N.pos("VBG"))).and(EnglishTreePatterns.typoReplacement("is")), NodePattern.N.form("upto").correct(NodeCorrector.replace("up to")).message("'up to' is spelled separately"), NodePattern.N.form("en").andOr(NodePattern.N.withHead("case", NodePattern.N.noForm("route|suite|masse")), NodePattern.N.withHeadRelation("advmod").directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceAround().directlyBefore(NodePattern.N.pos("NN.*")))).andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE.noSpaceAround()).withNeighbor(2, NodePattern.N.formCaseSensitive("[A-Z]{2}"))).correct(NodeCorrector.replace("in", "on")).message("Did you mean another word?"), NodePattern.N.withHeadRelation("case").andOr(NodePattern.N.pos("NN"), NodePattern.N.noPos()).noPotentialPos("RB|IN|JJ").noDependents("punct").spaceAround().beforeHead().noForm("en|post|ref|given|courtesy|wich|vs?\\.|x|\\\\.+").noFormCaseSensitive("AI").andNot(NodePattern.N.form("o").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("CD")).directlyAfter(NodePattern.N.pos("CD")))).andNot(NodePattern.N.inFormSequence(0, "y", "u", "no")).andNot(NodePattern.N.inFormSequence(0, "co", "-").noSpaceAfter()).andNot(foreignWord).andNot(NodePattern.N.form("if").andOr(NodePattern.N.withHead("case", NodePattern.N.lemma("statement|operator|expression|condition|keyword|what")), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.withHeadRelation("case"), NodePattern.N.form("nested|sequential"), NodePattern.N.potentialPos("VB.?"))), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("case"), NodePattern.N.form("else|-"))))).andNot(NodePattern.N.form("board").directlyAfter(NodePattern.N.form("on"))).andNot(CommonPatterns.beforeSlashOrParenth).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations).noSpaceAfter()).and((node, match) -> {
            String msg;
            List fromSpeller = node.hasForm("form") ? List.of("from") : ((StreamEx)((StreamEx)((StreamEx)((StreamEx)node.similarWordsOfPos("IN").map(s -> s.equalsIgnoreCase("abaft") ? "about" : s.toLowerCase(Locale.ROOT)).filter(s -> !exclude.contains(s))).filter(s -> Levenshtein.WithDamerau.distance(s, node.lowForm()) <= 2)).distinct()).limit(3L)).toList();
            boolean singleSuggestion = fromSpeller.size() == 1;
            String string = msg = singleSuggestion ? "Did you mean '" + fromSpeller.getFirst() + "'?" : "Did you mean another word?";
            if (!singleSuggestion) {
                match = match.concedingToOtherGrammarCheckers();
            }
            return match.withMessage(msg).withCorrector(NodeCorrector.replace(node, fromSpeller));
        }).onlyWithSuggestions().andOptionally(NodePattern.N.form("o.?").correct(NodeCorrector.replace("or"))).andOptionally(NodePattern.N.form(".").and(CommonPatterns.highlightWithTrailingSpace())));
    }

    private static NodePattern nounAdjunctPrepositions() {
        return NodePattern.or(NodePattern.N.form("sight").directlyAfter(NodePattern.N.form("first")).withDependent("case", NodePattern.not(NodePattern.N.form("at").beforeHead()).includeIntoReport().correct(NodeCorrector.replace("at"))).message("'First sight' is typically used with the preposition 'at'"), NodePattern.N.form("way").withDependent("det", NodePattern.N.form("an?|the")).withDependent("amod", NodePattern.N.pos("JJ.*")).noDependents(NodePattern.N.afterHead()).noHeadRelation("nmod").andNot(EnglishValences.isArgument).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("compound:prt"))).andNot(NodePattern.N.withPrevSibling(EnglishValences.mayHaveArgument("with"))).andOptionally(NodePattern.N.directlyBefore(NodePattern.N)).and(EnglishTreePatterns.replacePreposition("with|at", "in")).message("'way' is typically used with the preposition 'in'"), NodePattern.N.form("end").inFormSequence(0, "end", "of").withDependent("case", NodePattern.N.beforeHead().form("in").andNot(NodePattern.N.directlyAfter(NodePattern.N.lemma("believe|result").pos("V.*"))).includeIntoReport().correct(NodeCorrector.replace("at"))).withDependent("det", NodePattern.N.form("the").beforeHead()).message("'The end of' is typically used with the preposition 'at' unless it means 'finally'"), NodePattern.N.form("beginning").withDependent("det", NodePattern.N.form("the").beforeHead()).andOr(NodePattern.N.inFormSequence(0, "beginning", "of").andNot(NodePattern.N.withHead("obl", NodePattern.N.lemma("usher"))).withDependent("case", NodePattern.N.beforeHead().form("in").correct(NodeCorrector.replace("at"))).message("'The beginning of' is typically used with the preposition 'at'"), CommonPatterns.firstPhrase.noDependents("nmod").withDependent("case", NodePattern.N.beforeHead().form("at").correct(NodeCorrector.replace("in"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("obl", NodePattern.or(NodePattern.N.form("[123][0-9]{3}"), Semantics.timeUnits).beforeHead()))).message("Use 'in the beginning' if you mean 'at first'")), Semantics.adverbialTimePoints.andOr(NodePattern.N.withHeadRelation("obl:tmod").directlyAfter(NodePattern.N.form("to").correct(NodeCorrector.replace(""))), NodePattern.N.withHead("obl", NodePattern.not(CommonPatterns.possiblySkipDown("obl", NodePattern.N.withDependent("case", NodePattern.N.form("from"))))).withDependent("case", NodePattern.N.form("to").markAs("To").correct(NodeCorrector.replace(""))).noDependents(NodePattern.N.before("To"))).withHead(NodePattern.N.noLemma("similar").noHeadRelation("acl(:relcl)?").andNot(EnglishValences.mayHaveArgument("to"))).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.form("back|forward"))).message("Excessive preposition?"), NodePattern.N.form("corner").withDependent("case", NodePattern.N.form("at").beforeHead().correct(NodeCorrector.replace("in"))).noDependents("amod|compound", NodePattern.N.form("top|bottom|lower|upper").beforeHead()).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("of").directlyBefore(NodePattern.N.label("FACILITY|LOCATION")))).message("'$_' is typically used with the preposition 'in' unless it refers to a crossroads"), NodePattern.N.inFormSequence(0, "point", "of", "view").withDependent("case", NodePattern.N.form("in|to").markAs("Prep").includeIntoReport().correct(NodeCorrector.replace("from"))).andNot(NodePattern.N.withHead(NodePattern.or(Semantics.differOrSame, EnglishTreePatterns.withToMark.pos("VB")))).noHeadRelation("nmod").withPhraseEnd(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.markAs("PhraseEnd"))).andOr(NodePattern.N.withDependent("nmod:poss").withHead("obl", NodePattern.N.noPos("VBN")).correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1)).join(NodeCorrector.replace(NodePointer.marked("Prep"), "in"))).and(NodePattern.markedNodeMatches("PhraseEnd", NodePattern.N.reportRangeTo("Prep"))), NodePattern.markedNodeMatches("PhraseEnd", NodePattern.N.reportRangeTo("Prep", ReportingKind.Hover))).message("'Point of view' typically goes with the preposition 'from'"), NodePattern.N.form("home").withHead("obl", NodePattern.N.noPos("NN").noLemma("close").and(CommonPatterns.skipUp("advmod", NodePattern.N.pos("VB.*").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("from")))))).withDependent("case", NodePattern.N.form("to").directlyBeforeHead().correct(NodeCorrector.replace(""))).message("'Home' typically goes without the preposition 'to'"), NodePattern.N.lemma("meeting").andNot(NodePattern.N.withHead("obl", EnglishValences.mayHaveArgument("on"))).withDependent("case", NodePattern.N.form("on").correct(NodeCorrector.replace("in", "at"))).message("Use 'in' for being in the meeting process and 'at' for presence at the meeting location"), NodePattern.N.lemma("island").withDependent("case", NodePattern.N.form("in").correct(NodeCorrector.replace("on"))).andNot(NodePattern.N.withHead("obl", EnglishValences.mayHaveArgument("in"))).noLabel("LOCATION").message("'Island' typically goes with the preposition 'on'"), NodePattern.N.form("birthday").withDependent("case", NodePattern.N.form("in").correct(NodeCorrector.replace("on"))).message("'Birthday' typically goes with the preposition 'on'"), NodePattern.N.withDependent("case", NodePattern.N.form("until|till").correct(NodeCorrector.replace("by"))).withHead("obl", NodePattern.N.lemma("send|receive|finish|begin|publish|release|launch|create|form|establish|build|develop|renovate|construct|design|elect|select|appoint").andOr(EnglishTreePatterns.imperativeVB, EnglishTreePatterns.withModal).andNot(EnglishTreePatterns.negated)).andOptionally(NodePattern.N.inFormSequence(2, "until", "the", "time").withDependent("acl:relcl").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "before"))).message("Use 'by' if you\u2019re referring to deadlines"), NodePattern.N.lemma("analysis").withDependent("obl|nmod", NodePattern.N.withDependent("case", NodePattern.N.form("about").correct(NodeCorrector.replace("of")))).message("'analysis' is typically used with the preposition 'of'"), NodePattern.N.lemma("job").markAs("Job").andNot(NodePattern.N.withHead("obl|nmod", NodePattern.or(EnglishValences.mayHaveArgument("at"), NodePattern.N.pos("JJR")))).withDependent("case", NodePattern.N.form("at").markAs("Prep")).noDependents("compound", NodePattern.N.form("time").withDependent("compound|amod", NodePattern.N.form("part|full"))).noDependents("amod").andOr(NodePattern.N.withDependent("det", NodePattern.N.form("the|an?").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "on"))), NodePattern.N.noDependents("det|nmod:poss").correct(NodeCorrector.insertBefore("the ").join(NodeCorrector.replace(NodePointer.marked("Prep"), "on")))).andOr(NodePattern.N.withDependent("det", NodePattern.N.form("the|an?").markAs("Det")).correct(NodeCorrector.replace(NodePointer.marked("Det"), "").join(NodeCorrector.replace(NodePointer.marked("Job"), "work"))), NodePattern.N.noDependents("det|nmod:poss").correct(NodeCorrector.replace(NodePointer.marked("Job"), "work"))).message("Did you mean 'on the job' or 'at work'?"), NodePattern.N.lemma("invoice").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of").markAs("Prep")).andNot(EnglishTreePatterns.typeSynonyms)).andOr(NodePattern.N.withDependent("det|nmod:poss"), NodePattern.N.withHead(NodePattern.N.pos("VB."))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "for")).message("'invoice' is typically used with the preposition 'for'"), NodePattern.N.lemma("pressure").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("in").correct(NodeCorrector.replace("under"))).andNot(NodePattern.N.withHead("obl|nmod", EnglishValences.mayHaveArgument("in"))).message("'pressure' is typically used with the preposition 'under'"), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("by").correct(NodeCorrector.replace("from")))).message("'pressure' is typically used with the preposition 'from'")), NodePattern.N.lemma("curator").withDependent("nmod", NodePattern.N.withDependent("det", NodePattern.N.form("the")).withDependent("case", NodePattern.N.form("on").correct(NodeCorrector.replace("of"))).noForm("spot|team|ground|edge|panel")).message("'curator' is typically used with the preposition 'of'"), NodePattern.N.lemma("album").withDependent("det|nmod:poss").withDependent("case", NodePattern.N.form("in").markAs("Prep")).noDependents("compound", NodePattern.N.form("photo")).andNot(NodePattern.N.withHead("obl", EnglishValences.mayHaveArgument("in"))).andNot(NodePattern.N.inSentenceWith(NodePattern.N.lemma("photo|picture|image"))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "on")).message("Use 'on' with music albums and 'in' with photo albums"), NodePattern.N.lemma("cover").withDependent("det|nmod:poss").withDependent("case", NodePattern.N.form("in").markAs("Prep")).andNot(NodePattern.N.withHead("obl", EnglishValences.mayHaveArgument("in"))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "on")).message("'cover' typically goes with the preposition 'in'"), Semantics.game.withHead("obj|xcomp", NodePattern.N.lemma("do|go").correct(EnglishTreePatterns.changeVerbLemma("play"))).noDependents("conj", NodePattern.not(Semantics.game)).message("Use the verb 'play' with games"), NodePattern.N.lemma("contribution").withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("on").markAs("Prep")).noLemma("behalf|account|part|basis|topic|subject|theme|aspect|issue|question|matter|range|variety|github|wiki(pedia)?|(web)?site|forum|front|night|day|time|level|earning|return|salary|wage|tax|deposit|pay|(of|de)fen[sc]e")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "to")).message("'contribution' is typically used with the preposition 'to'"), NodePattern.N.lemma("exception").andOr(NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of").markAs("Prep")).andNot(NodePattern.or(EnglishTreePatterns.typeSynonyms, NodePattern.N.form("nature|character|essence|quality|type|sort|description|aspect|kind|tone|caliber|course")))).noDependents("case", NodePattern.N.form("with")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "to")).message("Use 'to' after 'exception' for the general rule"), NodePattern.N.withHead("obj", NodePattern.N.lemma("make").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to").correct(NodeCorrector.replace("for")).message("Use 'for' after 'make an exception' for the beneficiary"))))), NodePattern.N.lemma("party").markAs("Party").withHead("obj", NodePattern.N.lemma("make|do").andOr(CommonPatterns.possiblySkipDown("obj", NodePattern.N.withDependent("obl|nmod", NodePattern.N.withDependent("case", NodePattern.N.form("for")))).correct(EnglishTreePatterns.changeVerbLemma("throw")).message("Use 'throw' for organizing a party for someone"), NodePattern.N.form("making|doing").correct(EnglishTreePatterns.changeVerbLemma("throw")).correct(EnglishTreePatterns.changeVerbLemma("have")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Party"), "partying")).message("Use 'throw' or 'have' for organizing a party and 'partying' for participating in it"), NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("throw")).correct(EnglishTreePatterns.changeVerbLemma("have")).message("Use 'throw' or 'have' for organizing a party")).andNot(NodePattern.N.form("make").withDependent("xcomp"))), NodePattern.N.inFormSequence(3, "at", "the", "first", "time").reportEverythingTouched().withDependent("acl:relcl").withDependent("case", NodePattern.N.form("at").correct(NodeCorrector.replace("")).message("'The first time' does not require a preposition")), NodePattern.N.form("time").withDependent("case", NodePattern.N.form("in").markAs("Prep")).withHead("obl", NodePattern.N.lemma("be")).noDependents(NodePattern.not(NodePattern.N.withHeadRelation("case"))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "on")).message("Being punctual is usually expressed as 'being on time'"), NodePattern.N.form("part").includeIntoReport().withHead("compound|nmod", NodePattern.N.pos("NNS?").markAs("Head")).includeIntoReport().andOr(NodePattern.N.withDependent("det|nmod:poss"), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("det|nmod:poss"))).directlyBefore(NodePattern.or(NodePattern.N.withHead("amod|compound", NodePattern.N.alreadyMarkedAs("Head")), NodePattern.N.alreadyMarkedAs("Head"))).andNot(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_NODE, NodePattern.or(NodePattern.N.pos("CD").trace("two part series"), NodePattern.N.form("auto(mobile|motive)?|aircraft|body").trace("auto part exports")))).correct(NodeCorrector.insertAfter(" of the")).message("Did you mean 'part of the $Head'?"), PrepositionIssues.transport());
    }

    private static NodePattern verbArgumentPrepositions() {
        NodeCorrector.Relative removeTo = NodeCorrector.replace(NodePointer.marked("To"), "");
        NodeCorrector.Relative insertThat = NodeCorrector.insertBeforePhrase("that ");
        NodeCorrector.Relative pronounObjToSubj = NodeCorrector.inflect("PRP_O(.+)", "PRP_S$1");
        String arriveInAtMsg = "Use 'in' for geographical entities and 'at' for specific points";
        String concentrateOnMsg = "use 'on' when focusing on something";
        String concentrateInMsg = "use 'in' for broad areas or periods of concentration";
        String concentrateAtMsg = "use 'at' for specific places or times of concentration";
        String concentrateInOnMsg = StringTools.uppercaseFirstChar((String)concentrateInMsg) + ", " + concentrateOnMsg;
        String concentrateAtOnMsg = StringTools.uppercaseFirstChar((String)concentrateAtMsg) + ", " + concentrateOnMsg;
        String concentrateAtInOnMsg = StringTools.uppercaseFirstChar((String)concentrateAtMsg) + ", " + concentrateInMsg + ", " + concentrateOnMsg;
        NodePattern XtoY = EnglishTreePatterns.withToMark.andOr(NodePattern.N.withHead(NodePattern.or(NodePattern.N.pos("NN.*"), NodePattern.N.form("much")).withHeadRelation("root|nsubj|nmod")).and(NodePattern.N.withDependent("obl", NodePattern.N.pos("N.*"))), NodePattern.N.withDependent("advcl"));
        return NodePattern.or(NodePattern.N.lemma("include").and(EnglishTreePatterns.replacePrepInComplement("into", "in")).message("The verb 'include' is typically used with the preposition 'in'"), NodePattern.N.lemma("listen|reply").noDependents("obl", CommonPatterns.possiblySkipDown("case", NodePattern.N.form("to|for"))).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andOr(NodePattern.N.withDependent("obj", NodePattern.N.pos("NN.*|PRP.*|WP").andNot(CommonPatterns.insideQuotes)).and(EnglishTreePatterns.insertPrepBeforeObject("to").includeIntoReport(ReportingKind.Hover)).noDependents("conj", NodePattern.N.before("Obj")), NodePattern.N.withHeadRelation("acl:relcl").correct(NodeCorrector.insertAfter(" to")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("WP"))).message("The verb '$_' requires the preposition 'to'"), NodePattern.N.lemma("call").noHeadRelation("acl(:relcl)?").noDependents("obj|aux:pass|compound:prt").and(EnglishTreePatterns.replacePrepInComplement("to", "")).andNot(NodePattern.N.withDependent("obl", Semantics.humanLikePattern).andOr(NodePattern.N.withDependent("advcl|xcomp", EnglishTreePatterns.withToMark), NodePattern.N.withDependent("obl", NodePattern.N.potentialPos("VB").withDependent("case", NodePattern.N.form("for"))))).noDependents("advmod", NodePattern.N.pos("RB").directlyAfterHead().before("Prep")).andNot(NodePattern.N.withHeadRelation("advcl").withDependent(".*", NodePattern.N.beforeHead().noPos())).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound"))).message("The verb 'call' is typically used without a preposition"), NodePattern.N.lemma("provide").andNot(NodePattern.N.withHeadRelation("acl:relcl|xcomp")).noDependents("aux:pass|i?obj").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("with").markAs("With"))).andNot(NodePattern.N.pos("VBN").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?")).andOr(EnglishTreePatterns.replacePrepInComplement("to", "").message("The object of 'provide' typically goes without the preposition"), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("With"), "")).message("Remove 'with' or add an object after 'provide'")), NodePattern.N.lemma("suggest").andOr(NodePattern.N.withDependent("xcomp", NodePattern.N.noDependents("cop|aux|aux:pass|xcomp").markAs("Subordinate").withDependent("mark", NodePattern.N.form("to").markAs("To"))).withDependent("i?obj", NodePattern.or(NodePattern.N.pos("NN.*").andOptionally(NodePattern.N.pos("NNP?").correct(removeTo.join(insertThat).join(NodeCorrector.inflect(NodePointer.marked("Subordinate"), "VB", "VBZ")))).correct(removeTo.join(insertThat)).message("'Suggest' is not typically used with a base verb form"), NodePattern.N.andOptionally(NodePattern.N.pos("PRP_.3S.*").correct(removeTo.join(pronounObjToSubj).join(insertThat).join(NodeCorrector.inflect(NodePointer.marked("Subordinate"), "VB", "VBZ")))).correct(removeTo.join(insertThat).join(pronounObjToSubj)).message("'Suggest' typically goes without an indirect object"))), NodePattern.N.withDependent("obj", NodePattern.N.markAs("Obj")).withDependent("iobj", NodePattern.N.markAs("IObj").andOr(NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Obj").withDependent("acl.*|advcl|[xc]comp")).correct(NodeCorrector.insertBeforePhrase("to ")), PrepositionIssues.iobjToObl()).andOptionally(NodePattern.N.pos("PRP.*").correct(NodeCorrector.replace("")))).message("Use the preposition 'to' for the addressee of the suggestion")), NodePattern.N.form("married").andOr(NodePattern.N.withDependent("cop", NodePattern.N.lemma("be")), NodePattern.N.withDependent("aux:pass", NodePattern.N.lemma("get"))).withDependent("obl", EnglishTreePatterns.replacePreposition("with", "to").noPos("NNS").noLemma("son|daughter|kid|child|toddler|newborn|teenager").andNot(Semantics.plainGroup)).message("'Married' is typically used with the preposition 'to'"), NodePattern.N.lemma("discuss").noDependents("aux:pass").and(EnglishTreePatterns.replacePrepInComplement("about", "")).andOptionally(NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("talk"))).andNot(XtoY).message(PREPOSITION_AFTER_MSG), NodePattern.N.lemma("consider").withDependent("advcl|obl", NodePattern.N.withDependent("mark|case", NodePattern.N.form("about").markAs("Prep").correct(NodeCorrector.replace("")))).andNot(XtoY).message(PREPOSITION_AFTER_MSG), NodePattern.N.lemma("mention").noDependents("aux:pass").andOr(NodePattern.N.withDependent("advcl", NodePattern.N.withDependent("mark", NodePattern.N.form("about").markAs("Prep").correct(NodeCorrector.replace("that")))), EnglishTreePatterns.replacePrepInComplement("about", "")).message(PREPOSITION_AFTER_MSG), NodePattern.N.lemma("watch").noDependents("obj").andOr(NodePattern.N.withDependent("obl", NodePattern.N.pos("IN")), NodePattern.N.noHeadRelation("acl:relcl")).and(EnglishTreePatterns.replacePrepInComplement("at", "")).correct(EnglishTreePatterns.changeVerbLemma("look")).message(PREPOSITION_AFTER_MSG), NodePattern.N.lemma("travel").withDependent("obl:tmod", Semantics.timeUnits.afterHead().noDependents("det|nmod:npmod").noDependents("case", NodePattern.N.form("for")).correct(NodeCorrector.insertBeforePhrase("for "))).message("Use 'for' to indicate the duration of the trip"), NodePattern.N.lemma("leave").withDependent("obl", NodePattern.N.pos("NNP").label("GEO_POLITICAL_ENTITY|LOCATION").and(EnglishTreePatterns.replacePreposition("to", "for")).and(EnglishTreePatterns.replacePreposition("to", ""))).message("Use 'for' if you mean the destination"), NodePattern.N.lemma("graduate").withDependent("obj", NodePattern.or(Semantics.educationalInstitution, NodePattern.N.pos("NNP").label("ORGANIZATION|LOCATION"))).andNot(EnglishParameters.VARIANT.withValue("US|CA")).and(EnglishTreePatterns.insertPrepBeforeObject("from")).message("'Graduate' typically goes with the preposition 'from'"), NodePattern.N.lemma("knock").withDependent("obj", NodePattern.N.lemma("door|window|wall|wood")).noDependents("compound:prt", NodePattern.N.afterHead()).noDependents("advmod|xcomp", NodePattern.N.afterHead().pos("JJ")).noDependents("obl", NodePattern.N.afterHead().withDependent("case")).and(EnglishTreePatterns.insertPrepBeforeObject("on")).message("The preposition 'on' after 'knock' might be missing"), NodePattern.N.lemma("congratulate|congratulation").withDependent("obl|nmod", EnglishTreePatterns.replacePreposition("with|for", "on").noForm("heart")).message("'Congratulate' typically goes with the preposition 'on'"), NodePattern.N.lemma("work").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("at|for|with"))).withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("by").markAs("Prep")).andOr(NodePattern.N.label("ORGANIZATION|PRODUCT").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at", "for")), NodePattern.N.label("PERSON").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at", "for", "with")))).andNot(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("(aux|nsubj):pass|cop|compound:prt"), NodePattern.N.withHeadRelation("acl|csubj")))).message("The preposition 'by' doesn\u2019t seem to fit after '$_'"), NodePattern.N.lemma("depend").andOr(NodePattern.N.withDependent("advmod|obl", NodePattern.N.form("(up)?on").markAs("Prep").directlyAfterHead().noDependents().andNot(CommonPatterns.lastToken).correct(NodeCorrector.replace(""))).noDependents("cop|aux|aux:pass").noDependents("conj|obj").andNot(CommonPatterns.skipUp("[xc]comp", NodePattern.N.withHeadRelation("acl:relcl"))).andNot(NodePattern.N.inPhrase(Questions.question)).andNot(NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("advcl|[xc]comp|parataxis").withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", Questions.whPhrase))).andNot(NodePattern.N.withHeadRelation("parataxis").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("acl:relcl")))).andNot(CommonPatterns.insideQuotes).message("Remove the preposition '$Prep' or add a noun after it"), NodePattern.N.noDependents("advmod|obl", CommonPatterns.possiblySkipDown("case", NodePattern.N.form("(up)?on"))).andOr(EnglishTreePatterns.replacePrepInComplement("of|from", "on"), NodePattern.or(NodePattern.N.withDependent("ccomp|acl", NodePattern.N.afterHead().withDependent("mark|advmod", Questions.whWord.markAs("InsertPrep"))), NodePattern.N.withDependent("obj", NodePattern.N.markAs("InsertPrep"))).directlyBefore("InsertPrep").correct(NodeCorrector.insertAfter(" on"))).message("The verb 'depend' is typically used with the preposition 'on'")), NodePattern.N.lemma("accompany").noDependents("obj").withDependent("obl", EnglishTreePatterns.replacePreposition("with", "by")).message("The verb 'accompany' is typically used with the preposition 'by'"), NodePattern.N.lemma("admit").noDependents("obj").withDependent("obl", NodePattern.or(Semantics.educationalInstitution, NodePattern.N.lemma("hospital|clinic|program(me)?"), NodePattern.N.pos("NNP").label("ORGANIZATION|LOCATION|GEO_POLITICAL_ENTITY")).and(EnglishTreePatterns.replacePreposition("at", "to"))).message("The verb 'admit' is typically used with the preposition 'to' for educational and medical institutions"), NodePattern.N.lemma("apply").withDependent("obl", NodePattern.or(NodePattern.or(Semantics.educationalInstitution, NodePattern.N.lemma("company"), NodePattern.N.pos("NNP").label("ORGANIZATION|LOCATION|GEO_POLITICAL_ENTITY")).and(EnglishTreePatterns.replacePreposition("for", "to")), NodePattern.N.lemma("benefit|fund(s|ing)?|grant|(citizen|fellow|scholar|member|intern)ship|loan|status|position|post|visa|permit|passport|card|license|admission|asylum|aid|assistance|welfare").and(EnglishTreePatterns.replacePreposition("to", "for")).andNot(NodePattern.N.withDependent("case", NodePattern.N.form("to")).after(NodePattern.N.form("up"))).andNot(NodePattern.N.withHead("obl", NodePattern.or(NodePattern.N.withDependent("nsubj", NodePattern.N.lemma("same")), NodePattern.N.withDependent("obj")))))).and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", Semantics.Animacy.humanLike.pattern))).message("You can apply 'for' a position or benefit, but you apply 'to' an educational institution or company"), NodePattern.N.lemma("arrive").withDependent("obl", NodePattern.or(NodePattern.N.withDependent("case", NodePattern.N.form("in").markAs("Prep")).andOr(NodePattern.N.lemma("downtown|uptown").markAs("$_").andOr(NodePattern.N.withDependent("det", NodePattern.N.form("the|an?").markAs("Det")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "").join(NodeCorrector.replace(NodePointer.marked("Det"), ""))), NodePattern.N.noDependents("det").correct(NodeCorrector.replace(NodePointer.marked("Prep"), ""))).message("'$_' does not require a preposition"), NodePattern.N.lemma("park|restaurant|caf[e|\u00e9]").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at")).message(arriveInAtMsg)), NodePattern.N.withDependent("case", NodePattern.N.form("at").markAs("Prep")).andOr(NodePattern.N.lemma("village|town|city|country|state|province"), NodePattern.N.pos("NNP").label("GEO_POLITICAL_ENTITY|LOCATION")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "in")).message(arriveInAtMsg))), NodePattern.N.lemma("associate").withDependent("obl", NodePattern.N.noForm("extent|degree|close").and(EnglishTreePatterns.replacePreposition("to", "with"))).message("The verb 'associate' typically goes with the preposition 'with'"), NodePattern.N.lemma("believe").andOr(NodePattern.N.withDependent("obl", NodePattern.N.afterHead().withDependent("case", NodePattern.N.beforeHead().form("to").markAs("Prep")).noForm("best").andOptionally(NodePattern.or(Semantics.Animacy.humanLike.pattern, NodePattern.N.form("that|this|it|what")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), ""))).andOptionally(NodePattern.N.noForm("that|this").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "in"))).message("Use 'believe' without a preposition for acceptance of someone\u2019s statements; use 'believe in' for faith in someone or something")).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("in"))), NodePattern.N.withDependent("advcl", NodePattern.N.pos("VBG").noDependents("aux").withDependent("mark", NodePattern.N.form("to").correct(NodeCorrector.replace("in")))).message("Use 'believe in' to express faith in something")), NodePattern.N.lemma("bring").withDependent("obj", NodePattern.N.pos("PRP")).withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("at|in").markAs("Prep")).noForm("loop|cash|money|case|line").noPos("CD").andOr(Semantics.partsOfBuilding.correct(NodeCorrector.replace(NodePointer.marked("Prep"), "to", "into")).message("The verb 'bring' typically goes with the preposition 'to' or 'into'"), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Prep"), "to")).message("The verb 'bring' typically goes with the preposition 'to'"))).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to|into"))), NodePattern.N.lemma("bring").markAs("Verb").withDependent("obl", NodePattern.N.form("agenda").withDependent("case", NodePattern.N.form("to").markAs("Prep"))).correct(EnglishTreePatterns.changeVerbLemma("put").join(NodeCorrector.replace(NodePointer.marked("Prep"), "on"))).message("Use 'put on' for adding something to an agenda"), NodePattern.N.lemma("bring").withDependent("obl", NodePattern.N.form("party").withDependent("case", NodePattern.N.form("at").correct(NodeCorrector.replace("to")))).withDependent("obj").message("The verb 'bring' typically goes with the preposition 'to'"), NodePattern.N.lemma("come").andOr(NodePattern.N.withDependent("obl", NodePattern.or(Semantics.partsOfBuilding, Semantics.typesOfBuildings).withDependent("case", NodePattern.N.form("in").andNot(NodePattern.N.directlyAfter(NodePattern.N.lemma("once"))).correct(NodeCorrector.replace("into", "to")))).message("The verb 'come' typically goes with the preposition 'into' or 'to'"), NodePattern.N.lemma("come").andNot(NodePattern.N.withDependent("mark|advmod", NodePattern.N.form("when")).withDependent("nsubj", NodePattern.N.form("it")).pos("VBZ")).withDependent("obl|xcomp|advcl", Semantics.isTransport.lemmaPattern.withDependent("case|mark", NodePattern.N.form("to").correct(NodeCorrector.replace("by")))).message("Use 'by' for means of transportation")), NodePattern.N.lemma("concentrate").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("with").markAs("Prep")).andOr(NodePattern.or(Semantics.typesOfBuildings, Semantics.partsOfBuilding, NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION"), NodePattern.N.lemma("region|area")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "in")).message(concentrateInOnMsg), NodePattern.N.form("school|work|moment").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at", "on")).message(concentrateAtOnMsg), Semantics.educationalInstitution.andOr(NodePattern.N.pos("NN").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at", "in", "on")).message(concentrateAtInOnMsg), NodePattern.N.pos("NNS").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "in", "on")).message(concentrateInOnMsg)), NodePattern.N.lemma("end|beginning|start|time|night").correct(NodeCorrector.replace(NodePointer.marked("Prep"), "at")).message(concentrateAtOnMsg), Semantics.timeUnits.correct(NodeCorrector.replace(NodePointer.marked("Prep"), "in")).message(concentrateInOnMsg), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Prep"), "on")).message(StringTools.uppercaseFirstChar((String)concentrateOnMsg)))), NodePattern.N.lemma("cover").noDependents("compound:prt", NodePattern.N.form("up")).withDependent("obl.*", NodePattern.N.lemma("snow|dust|dirt|mud|blood|sweat|paint|fur|hair|oil|graffiti|sand|sauce").withDependent("case", NodePattern.N.form("by").correct(NodeCorrector.replace("in", "with")))).message("Use 'in' or 'with' when referring to a substance that sticks to another or forms a layer"), NodePattern.N.lemma("crave").pos("VB.*").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for").markAs("Prep")).andNot(NodePattern.or(Semantics.timeUnits, NodePattern.N.lemma("time|ages|while|sake|long")))).andNot(NodePattern.N.withHead("obj", NodePattern.N.pos("VBZ"))).noDependents("conj", NodePattern.N.pos("JJ")).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "")).message("The verb 'crave' is typically used without preposition before its object"), NodePattern.N.lemma("thank").andOr(CommonPatterns.firstWord, NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).withDependent("obj", NodePattern.N.withDependent("det", NodePattern.N.form("the")).pos("NN.*").andNot(Semantics.humanLikePattern)).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for"))).andOr(NodePattern.N.withDependent("parataxis", NodePattern.not(Semantics.toHaveOpinion)).correct(NodeCorrector.replace("Thanks to")).message("Use 'Thanks to' to express cause of something positive"), NodePattern.N.correct(NodeCorrector.replace("Thanks for", "Thanks to")).message("Use 'Thanks for' to express gratitude, use 'Thanks to' to express cause of something positive")), NodePattern.N.lemma("look").withDependent("advmod|obl", NodePattern.N.form("outside|inside").andOr(NodePattern.N.withDependent("case", NodePattern.N.form("at").markAs("Prep")), NodePattern.N.withPrevSibling(NodePattern.N.form("on").withHead("advmod|compound:prt", NodePattern.N.noHeadRelation("acl|acl:relcl")).markAs("Prep"))).noDependents("obl").message("'$_' as an adverb requires no preposition")).andNot(NodePattern.or(NodePattern.N.withHead("advcl", NodePattern.N.form("worth")), NodePattern.N.withPrevSibling(NodePattern.N.form("worth")))).correct(NodeCorrector.replace(NodePointer.marked("Prep"), "")), NodePattern.N.lemma("open").withDependent("obj", NodePattern.N.lemma("(text|work)?book")).and(CommonPatterns.possiblySkipDown("obj", NodePattern.N.withDependent("obl|nmod", NodePattern.N.lemma("page").withDependent("case", NodePattern.or(NodePattern.N.form("for|on|to").and(EnglishParameters.VARIANT.withValue("GB.*")).correct(NodeCorrector.replace("at")).message("British English uses 'open at page'"), NodePattern.N.form("for|on|at").andNot(EnglishParameters.VARIANT.withValue("GB.*")).correct(NodeCorrector.replace("to")).message("The usual collocation is 'open to page'")))))), NodePattern.N.lemma("ask").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to").correct(NodeCorrector.replace("")).message("The verb 'ask' requires no preposition").andNot(TreeMigration.revise("Needed for an FP example fixed in tree-exp", CommonPatterns.firstWord)).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("acl:relcl")))).noLemma("party|dance|prom|meeting")), NodePattern.N.lemma("influence").pos("VB.*").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("on").correct(NodeCorrector.replace("")).message("The verb 'influence' requires no preposition"))).noDependents("obj"), PrepositionIssues.beenInTo());
    }

    private static NodePattern beenInTo() {
        NodePattern place = NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION").markAs("Place");
        NodePattern clause = NodePattern.or(NodePattern.or(NodePattern.N.withDependent("obl:tmod", NodePattern.N.form("times?")), NodePattern.N.withDependent("advmod", NodePattern.N.form("once|twice|never|ever|just|recently|even|before"))).and(NodePattern.markedNodeMatches("Place", EnglishTreePatterns.replacePreposition("in", "to"))).message("Use 'been to' if you mean 'visited'"), NodePattern.N.withDependent("obl", Semantics.timeUnits.withDependent("case", NodePattern.N.form("for"))).and(NodePattern.markedNodeMatches("Place", EnglishTreePatterns.replacePreposition("to", "in"))).message("Use 'been in' if you mean 'stayed'")).andNot(EnglishTreePatterns.negated);
        return NodePattern.N.form("been").andOr(NodePattern.N.withHead("cop", place.and(clause)), NodePattern.N.withDependent("obl", place).and(clause));
    }

    private static NodePattern transport() {
        return NodePattern.or(NodePattern.N.lemma("bus|train|boat|ferry|ship|(aero|air)?plane|tram|(bi|tri|mono|motor)cycle|skateboard|(motor)?bike|horse").noPos("VB.*").withHead(EnglishTreePatterns.verbalClause.andNot(NodePattern.N.directlyBefore(NodePattern.N.form("at")))).andOr(NodePattern.N.withDependent("det|nmod:poss").andOr(EnglishTreePatterns.replacePreposition("in|at", "on"), NodePattern.N.withHead(NodePattern.N.lemma("get|go|ride|drive|jump|travel|hop|arrive|move|leave|come|fly")).and(EnglishTreePatterns.replacePreposition("with", "on"))).message("Use the preposition 'on' with '$_'"), NodePattern.N.pos("NN").noDependents("det|nmod:poss|amod").and(NodePattern.N.withHead(NodePattern.N.lemma("get|go|ride|drive|jump|travel|hop|arrive|move|leave|come|fly")).and(EnglishTreePatterns.replacePreposition("in|at|on|with", "by")).message("Use the preposition 'by' with '$_'")).andOptionally(NodePattern.N.withDependent("case", NodePattern.N.form("on")).noDependents("conj").and(Articles.forceA()))), NodePattern.N.lemma("car|taxi|truck|(mini)?van|stroller|canoe|kayak").andOr(NodePattern.N.withHead(CommonPatterns.skipUp("xcomp", NodePattern.N.lemma("get|go|ride|drive|jump|travel|hop|arrive|move|leave|come|fly|sit|sleep|wait|trap|stay|smoke"))), NodePattern.N.withDependent("cop", NodePattern.N.lemma("be"))).andOr(NodePattern.N.withDependent("det|nmod:poss").and(EnglishTreePatterns.replacePreposition("on|at", "in")).message("Use the preposition 'in' with '$_'"), NodePattern.N.withHead(CommonPatterns.skipUp("xcomp", NodePattern.N.lemma("get|go|ride|drive|jump|travel|hop|arrive|move|leave|come|fly"))).withOnlyDependents(NodePattern.N.withHeadRelation("case")).and(EnglishTreePatterns.replacePreposition("in|on", "by")).message("Use the preposition 'by' with '$_'")));
    }

    private static NodePattern iobjToObl() {
        return NodePattern.custom((iobj, match) -> {
            Node predicate = Objects.requireNonNull(iobj.head());
            Node object = predicate.findSingleDependent("obj");
            if (object == null) {
                return null;
            }
            NodeCorrector remove = NodeCorrector.replaceNodes(iobj.phraseStart(), iobj.phraseEnd(), "");
            NodeCorrector insert = NodeCorrector.insertAfter(object.phraseEnd(), " to " + iobj.phraseText());
            return match.withCorrector(insert.join(remove));
        });
    }
}

