/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.lang.NotebookLanguage;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u0002\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"isNotebook", "", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)Z", "language", "Lcom/intellij/lang/Language;", "getLanguage", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/lang/Language;", "getIntervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "editor", "index", "", "getAllIntervalPointers", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookMarkdownEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookMarkdownEditorManager.kt\ncom/intellij/jupyter/core/editor/NotebookMarkdownEditorManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1586#2:84\n1661#2,3:85\n1#3:88\n*S KotlinDebug\n*F\n+ 1 NotebookMarkdownEditorManager.kt\ncom/intellij/jupyter/core/editor/NotebookMarkdownEditorManagerKt\n*L\n82#1:84\n82#1:85,3\n*E\n"})
public final class NotebookMarkdownEditorManagerKt {
    public static final boolean isNotebook(@NotNull Editor $this$isNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotebook, (String)"<this>");
        Language language = NotebookMarkdownEditorManagerKt.getLanguage($this$isNotebook);
        return Intrinsics.areEqual((Object)(language != null ? language.getBaseLanguage() : null), (Object)NotebookLanguage.INSTANCE);
    }

    @Nullable
    public static final Language getLanguage(@NotNull Editor $this$language) {
        Intrinsics.checkNotNullParameter((Object)$this$language, (String)"<this>");
        return (Language)ActionsKt.runReadAction(() -> NotebookMarkdownEditorManagerKt._get_language_$lambda$0($this$language));
    }

    @Nullable
    public static final NotebookIntervalPointer getIntervalPointer(@NotNull Editor editor, int index) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)NotebookCellLines.Companion.get(editor).getIntervals(), (int)index);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return NotebookIntervalPointerFactory.Companion.get(editor).create(interval2);
    }

    @NotNull
    public static final List<NotebookIntervalPointer> getAllIntervalPointers(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return NotebookMarkdownEditorManagerKt.getAllIntervalPointers(project2, document);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<NotebookIntervalPointer> getAllIntervalPointers(@NotNull Project project, @NotNull Document document) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(project, document);
        if (notebookIntervalPointerFactory == null) {
            return CollectionsKt.emptyList();
        }
        NotebookIntervalPointerFactory factory = notebookIntervalPointerFactory;
        Iterable $this$map$iv = NotebookCellLines.Companion.get(document).getIntervals();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(factory.create((NotebookCellLines.Interval)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Language _get_language_$lambda$0(Editor $this_language) {
        Project project;
        Project project3 = $this_language.getProject();
        project3 = project3;
        if (project2 == null) return null;
        Project it = project = project3;
        boolean bl = false;
        if (it.isDisposed()) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        Project project3 = project;
        project3 = project3;
        if (project4 == null) return null;
        Project p0 = project3;
        boolean bl3 = false;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)p0);
        project3 = psiDocumentManager;
        if (psiDocumentManager == null) return null;
        PsiFile psiFile = project3.getPsiFile($this_language.getDocument());
        project3 = psiFile;
        if (psiFile == null) return null;
        Language language = project3.getLanguage();
        return language;
    }
}

