/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.http;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterSSLWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import com.intellij.util.ui.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 (2\u00020\u0001:\u0003()*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJH\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 26\u0010!\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000f0\u0011H\u0007J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R(\u0010\n\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper;", "", "<init>", "()V", "defaultHostKeyVerifier", "Lorg/apache/http/conn/ssl/DefaultHostnameVerifier;", "getDefaultHostKeyVerifier", "()Lorg/apache/http/conn/ssl/DefaultHostnameVerifier;", "defaultHostKeyVerifier$delegate", "Lkotlin/Lazy;", "usersTrustDecisions", "", "Lkotlin/Pair;", "", "Ljava/security/cert/Certificate;", "", "hostKeyConfirmationHandler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "host", "commonName", "Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$ConfirmationHandlerResult;", "wrapApacheHttpBuilder", "Lorg/apache/http/impl/client/HttpClientBuilder;", "builder", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "uriHost", "setHostKeyConfirmationHandler", "", "disposable", "Lcom/intellij/openapi/Disposable;", "handler", "verifyHostKey", "session", "Ljavax/net/ssl/SSLSession;", "verifyHostKeyCustom", "certificate", "defaultHostKeyConfirmationHandler", "Companion", "ConfirmationHandlerResult", "JupyterX509TrustManager", "intellij.jupyter.core"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nJupyterSSLWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterSSLWrapper.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n18#2:212\n1#3:213\n*S KotlinDebug\n*F\n+ 1 JupyterSSLWrapper.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper\n*L\n109#1:212\n*E\n"})
public final class JupyterSSLWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy defaultHostKeyVerifier$delegate = LazyKt.lazy(JupyterSSLWrapper::defaultHostKeyVerifier_delegate$lambda$0);
    @NotNull
    private final Map<Pair<String, Certificate>, Boolean> usersTrustDecisions = new ConcurrentHashMap();
    @NotNull
    private volatile Function2<? super String, ? super String, ConfirmationHandlerResult> hostKeyConfirmationHandler = (Function2)new Function2<String, String, ConfirmationHandlerResult>((Object)this){

        public final ConfirmationHandlerResult invoke(String p0, String p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return JupyterSSLWrapper.access$defaultHostKeyConfirmationHandler((JupyterSSLWrapper)this.receiver, p0, p1);
        }
    };

    private final DefaultHostnameVerifier getDefaultHostKeyVerifier() {
        Lazy lazy = this.defaultHostKeyVerifier$delegate;
        return (DefaultHostnameVerifier)lazy.getValue();
    }

    @NotNull
    public final HttpClientBuilder wrapApacheHttpBuilder(@NotNull HttpClientBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        HttpClientBuilder httpClientBuilder = builder.setSSLContext(CertificateManager.Companion.getInstance().getSslContext()).setSSLHostnameVerifier(this::verifyHostKey);
        Intrinsics.checkNotNullExpressionValue((Object)httpClientBuilder, (String)"setSSLHostnameVerifier(...)");
        return httpClientBuilder;
    }

    @NotNull
    public final SSLSocketFactory sslSocketFactory(@NotNull String uriHost) {
        Intrinsics.checkNotNullParameter((Object)uriHost, (String)"uriHost");
        SSLContext sslContext = SSLContext.getInstance("TLS");
        JupyterX509TrustManager[] jupyterX509TrustManagerArray = new JupyterX509TrustManager[]{new JupyterX509TrustManager(uriHost)};
        sslContext.init(new KeyManager[0], jupyterX509TrustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSocketFactory(...)");
        return sSLSocketFactory;
    }

    @TestOnly
    public final void setHostKeyConfirmationHandler(@NotNull Disposable disposable, @NotNull Function2<? super String, ? super String, Boolean> handler2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Disposer.register((Disposable)disposable, () -> JupyterSSLWrapper.setHostKeyConfirmationHandler$lambda$0(this));
        this.hostKeyConfirmationHandler = (arg_0, arg_1) -> JupyterSSLWrapper.setHostKeyConfirmationHandler$lambda$1(handler2, arg_0, arg_1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifyHostKey(String host, SSLSession session) {
        if (this.getDefaultHostKeyVerifier().verify(host, session)) return true;
        Certificate[] certificateArray = session.getPeerCertificates();
        Intrinsics.checkNotNullExpressionValue((Object)certificateArray, (String)"getPeerCertificates(...)");
        if (!this.verifyHostKeyCustom(host, (Certificate)ArraysKt.firstOrNull((Object[])certificateArray))) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean verifyHostKeyCustom(String host, Certificate certificate) {
        $this$verifyHostKeyCustom_u24lambda_u240 = this;
        $i$a$-run-JupyterSSLWrapper$verifyHostKeyCustom$1 = false;
        decision = $this$verifyHostKeyCustom_u24lambda_u240.usersTrustDecisions.get(TuplesKt.to((Object)host, (Object)certificate));
        if (decision != null) {
            return decision;
        }
        if (certificate == null) ** GOTO lbl-1000
        $i$a$-run-JupyterSSLWrapper$verifyHostKeyCustom$1 = certificate;
        $i$f$asSafely = false;
        v0 = $this$asSafely$iv;
        if (!(v0 instanceof X509Certificate)) {
            v0 = null;
        }
        if ((var4_3 = (X509Certificate)v0) == null) ** GOTO lbl-1000
        p0 = var4_3;
        $i$a$-let-JupyterSSLWrapper$verifyHostKeyCustom$commonName$1 = false;
        $i$f$asSafely = new CertificateWrapper((X509Certificate)p0).getSubjectFields();
        if ($i$f$asSafely != null && (var7_10 = (String)$i$f$asSafely.get(CertificateWrapper.CommonField.COMMON_NAME.getShortName())) != null) {
            v1 = var7_10;
        } else lbl-1000:
        // 3 sources

        {
            v1 = "<null>";
        }
        commonName = v1;
        var4_3 = (ConfirmationHandlerResult)this.hostKeyConfirmationHandler.invoke((Object)host, (Object)commonName);
        decision = var4_3.component1();
        remember = var4_3.component2();
        if (remember) {
            this.usersTrustDecisions.putIfAbsent((Pair<String, Certificate>)TuplesKt.to((Object)host, (Object)certificate), decision);
        }
        return decision;
    }

    private final ConfirmationHandlerResult defaultHostKeyConfirmationHandler(String host, String commonName) {
        var remember2 = new DoNotAskOption.Adapter(){
            private boolean result;

            public final boolean getResult() {
                return this.result;
            }

            public final void setResult(boolean bl) {
                this.result = bl;
            }

            public boolean isSelectedByDefault() {
                return true;
            }

            public String getDoNotShowMessage() {
                return JupyterBundle.message("dialog.message.certificate.wrong.hostname.do.not.ask", new Object[0]);
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                this.result = isSelected;
            }
        };
        boolean decision = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), () -> JupyterSSLWrapper.defaultHostKeyConfirmationHandler$lambda$0(host, commonName, remember2));
        return new ConfirmationHandlerResult(decision, remember2.getResult());
    }

    private static final DefaultHostnameVerifier defaultHostKeyVerifier_delegate$lambda$0() {
        return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
    }

    private static final void setHostKeyConfirmationHandler$lambda$0(JupyterSSLWrapper this$0) {
        this$0.hostKeyConfirmationHandler = (Function2)new Function2<String, String, ConfirmationHandlerResult>((Object)this$0){

            public final ConfirmationHandlerResult invoke(String p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return JupyterSSLWrapper.access$defaultHostKeyConfirmationHandler((JupyterSSLWrapper)this.receiver, p0, p1);
            }
        };
    }

    private static final ConfirmationHandlerResult setHostKeyConfirmationHandler$lambda$1(Function2 $handler, String host, String commonName) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)commonName, (String)"commonName");
        return new ConfirmationHandlerResult((Boolean)$handler.invoke((Object)host, (Object)commonName), false);
    }

    private static final boolean defaultHostKeyConfirmationHandler$lambda$0(String $host, String $commonName, defaultHostKeyConfirmationHandler.remember.1 $remember) {
        Object[] objectArray = new Object[]{$host, $commonName};
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(JupyterBundle.message("dialog.message.certificate.wrong.hostname.title", new Object[0]), JupyterBundle.message("dialog.message.certificate.wrong.hostname.message", objectArray)).doNotAsk((DoNotAskOption)$remember)).icon(UIUtil.getWarningIcon())).noText(JupyterBundle.message("dialog.message.certificate.wrong.hostname.button.abort", new Object[0]))).yesText(JupyterBundle.message("dialog.message.certificate.wrong.hostname.button.continue", new Object[0]))).guessWindowAndAsk();
    }

    @JvmStatic
    @NotNull
    public static final JupyterSSLWrapper getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final <T> T adjustingSslUi(@NotNull HttpSession.Request.Context context, @NotNull Function0<? extends T> handler2) {
        return Companion.adjustingSslUi(context, handler2);
    }

    public static final /* synthetic */ ConfirmationHandlerResult access$defaultHostKeyConfirmationHandler(JupyterSSLWrapper $this, String host, String commonName) {
        return $this.defaultHostKeyConfirmationHandler(host, commonName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J-\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper;", "adjustingSslUi", "T", "context", "Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession$Request$Context;", "handler", "Lkotlin/Function0;", "(Lcom/intellij/jupyter/core/jupyter/connections/http/HttpSession$Request$Context;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterSSLWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterSSLWrapper.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,211:1\n42#2,3:212\n*S KotlinDebug\n*F\n+ 1 JupyterSSLWrapper.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$Companion\n*L\n36#1:212,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterSSLWrapper getInstance() {
            boolean $i$f$service = false;
            Class<JupyterSSLWrapper> serviceClass$iv = JupyterSSLWrapper.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JupyterSSLWrapper)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T adjustingSslUi(@NotNull HttpSession.Request.Context context, @NotNull Function0<? extends T> handler2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(handler2, (String)"handler");
            boolean $i$f$adjustingSslUi = false;
            if (context.getMayInteractUi()) {
                return (T)handler2.invoke();
            }
            ThreadLocal strategyRef = CertificateManager.Companion.getInstance().getTrustManager().myUntrustedCertificateStrategy;
            strategyRef.set(UntrustedCertificateStrategy.REJECT);
            try {
                Object object = handler2.invoke();
                return (T)object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                strategyRef.remove();
                InlineMarker.finallyEnd((int)1);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$ConfirmationHandlerResult;", "", "decision", "", "remember", "<init>", "(ZZ)V", "getDecision", "()Z", "getRemember", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.jupyter.core"})
    private static final class ConfirmationHandlerResult {
        private final boolean decision;
        private final boolean remember;

        public ConfirmationHandlerResult(boolean decision, boolean remember2) {
            this.decision = decision;
            this.remember = remember2;
        }

        public final boolean getDecision() {
            return this.decision;
        }

        public final boolean getRemember() {
            return this.remember;
        }

        public final boolean component1() {
            return this.decision;
        }

        public final boolean component2() {
            return this.remember;
        }

        @NotNull
        public final ConfirmationHandlerResult copy(boolean decision, boolean remember2) {
            return new ConfirmationHandlerResult(decision, remember2);
        }

        public static /* synthetic */ ConfirmationHandlerResult copy$default(ConfirmationHandlerResult confirmationHandlerResult, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = confirmationHandlerResult.decision;
            }
            if ((n & 2) != 0) {
                bl2 = confirmationHandlerResult.remember;
            }
            return confirmationHandlerResult.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ConfirmationHandlerResult(decision=" + this.decision + ", remember=" + this.remember + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.decision);
            result2 = result2 * 31 + Boolean.hashCode(this.remember);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfirmationHandlerResult)) {
                return false;
            }
            ConfirmationHandlerResult confirmationHandlerResult = (ConfirmationHandlerResult)other;
            if (this.decision != confirmationHandlerResult.decision) {
                return false;
            }
            return this.remember == confirmationHandlerResult.remember;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ3\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ/\u0010\u0013\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0014\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0015JL\u0010\u0007\u001a\u00020\b2,\u0010\u0016\u001a(\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b \u0017*\u0014\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\n2\u000e\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00040\u0004H\u0096\u0001\u00a2\u0006\u0002\u0010\u0015JL\u0010\u0013\u001a\u00020\b2,\u0010\u0016\u001a(\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b \u0017*\u0014\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\n2\u000e\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00040\u0004H\u0096\u0001\u00a2\u0006\u0002\u0010\u0015J4\u0010\u0019\u001a(\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b \u0017*\u0014\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nH\u0096\u0001\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$JupyterX509TrustManager;", "Ljavax/net/ssl/X509ExtendedTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "uriHost", "", "<init>", "(Ljava/lang/String;)V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "socket", "Ljava/net/Socket;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/net/Socket;)V", "engine", "Ljavax/net/ssl/SSLEngine;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljavax/net/ssl/SSLEngine;)V", "checkServerTrusted", "verifyHostName", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "p0", "kotlin.jvm.PlatformType", "p1", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterSSLWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterSSLWrapper.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$JupyterX509TrustManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,211:1\n23#2:212\n*S KotlinDebug\n*F\n+ 1 JupyterSSLWrapper.kt\ncom/intellij/jupyter/core/jupyter/connections/http/JupyterSSLWrapper$JupyterX509TrustManager\n*L\n198#1:212\n*E\n"})
    private static final class JupyterX509TrustManager
    extends X509ExtendedTrustManager
    implements X509TrustManager {
        private final /* synthetic */ ConfirmingTrustManager $$delegate_0;
        @NotNull
        private final String uriHost;

        public JupyterX509TrustManager(@NotNull String uriHost) {
            Intrinsics.checkNotNullParameter((Object)uriHost, (String)"uriHost");
            this.$$delegate_0 = CertificateManager.Companion.getInstance().getTrustManager();
            this.uriHost = uriHost;
        }

        @Override
        public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable Socket socket) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType, @Nullable SSLEngine engine) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @Nullable String authType, @NotNull Socket socket) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            this.verifyHostName(chain, authType);
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain, @Nullable String authType, @NotNull SSLEngine engine) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            this.verifyHostName(chain, authType);
        }

        private final void verifyHostName(X509Certificate[] chain, String authType) {
            block6: {
                String string;
                this.checkServerTrusted(chain, authType);
                String $this$verifyHostName_u24lambda_u240 = this.uriHost;
                boolean bl2 = false;
                if (StringsKt.startsWith$default((String)$this$verifyHostName_u24lambda_u240, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$verifyHostName_u24lambda_u240, (String)"]", (boolean)false, (int)2, null)) {
                    String string2 = $this$verifyHostName_u24lambda_u240.substring(1, $this$verifyHostName_u24lambda_u240.length() - 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = $this$verifyHostName_u24lambda_u240;
                }
                String host = string;
                try {
                    Class<?> hostnameCheckerCls = this.getClass().getClassLoader().loadClass("sun.security.util.HostnameChecker");
                    Object[] bl2 = new Class[]{Byte.TYPE};
                    Method method = hostnameCheckerCls.getMethod("getInstance", (Class<?>[])bl2);
                    bl2 = new Object[]{hostnameCheckerCls.getField("TYPE_TLS").get(null)};
                    Object hostnameChecker = method.invoke(null, bl2);
                    bl2 = new Class[]{String.class, X509Certificate.class};
                    Method method2 = hostnameCheckerCls.getMethod("match", (Class<?>[])bl2);
                    bl2 = new Object[2];
                    bl2[0] = host;
                    if ((X509Certificate)ArraysKt.firstOrNull((Object[])chain) == null) {
                        Object cfr_ignored_0 = bl2[1];
                        throw new SSLPeerUnverifiedException("");
                    }
                    method2.invoke(hostnameChecker, bl2);
                }
                catch (ReflectiveOperationException err) {
                    if (!(err instanceof InvocationTargetException)) {
                        JupyterX509TrustManager $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(JupyterX509TrustManager.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Failed to reflectively access internal Java SSL tools. Not all security checks can be performed", (Throwable)err);
                    }
                    if ((((InvocationTargetException)err).getTargetException() instanceof SSLPeerUnverifiedException || ((InvocationTargetException)err).getTargetException() instanceof CertificateException) && !(chain.length == 0) && Companion.getInstance().verifyHostKeyCustom(host, (Certificate)ArraysKt.first((Object[])chain))) break block6;
                    Throwable throwable = ((InvocationTargetException)err).getTargetException();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getTargetException(...)");
                    throw throwable;
                }
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] p0, String p1) {
            this.$$delegate_0.checkClientTrusted(p0, p1);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] p0, String p1) {
            this.$$delegate_0.checkServerTrusted(p0, p1);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.$$delegate_0.getAcceptedIssuers();
        }
    }
}

