/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionParameterSettingsUtils;", "", "<init>", "()V", "isConfiguredServer", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSettings", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "intellij.jupyter.core"})
public final class JupyterConnectionParameterSettingsUtils {
    @NotNull
    public static final JupyterConnectionParameterSettingsUtils INSTANCE = new JupyterConnectionParameterSettingsUtils();

    private JupyterConnectionParameterSettingsUtils() {
    }

    public final boolean isConfiguredServer(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.getSettings(project, virtualFile) instanceof JupyterConfiguredServerConfig;
    }

    @Nullable
    public final JupyterServerConfig getSettings(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookVirtualFile2 = backedNotebookVirtualFile;
        return JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFileOrDefault(notebookVirtualFile2, project);
    }
}

