/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.intellij.jupyter.core.jupyter.convert.FontRegSummary;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a[\u0010\u0002\u001a\u00020\u00032Q\u0010\u0004\u001aM\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0005H\u0000\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"log", "Lcom/intellij/openapi/diagnostic/Logger;", "registerBundledFonts", "Lcom/intellij/jupyter/core/jupyter/convert/FontRegSummary;", "adder", "Lkotlin/Function3;", "Lkotlin/Function0;", "Ljava/io/InputStream;", "Lkotlin/ParameterName;", "name", "supplier", "", "family", "debugLabel", "", "inferAliasFamily", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nBundledFonts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundledFonts.kt\ncom/intellij/jupyter/core/jupyter/convert/BundledFontsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n1915#2,2:219\n1915#2,2:221\n1#3:223\n57#4:224\n35#4,2:225\n*S KotlinDebug\n*F\n+ 1 BundledFonts.kt\ncom/intellij/jupyter/core/jupyter/convert/BundledFontsKt\n*L\n163#1:219,2\n193#1:221,2\n11#1:224\n11#1:225,2\n*E\n"})
public final class BundledFontsKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final FontRegSummary registerBundledFonts(@NotNull Function3<? super Function0<? extends InputStream>, ? super String, ? super String, Unit> adder) {
        Intrinsics.checkNotNullParameter(adder, (String)"adder");
        log.debug("registerBundledFonts: start");
        Ref.IntRef count = new Ref.IntRef();
        Ref.IntRef interCount = new Ref.IntRef();
        Ref.IntRef jbCount = new Ref.IntRef();
        Object[] objectArray = new List[8];
        Object[] objectArray2 = new String[]{"/fonts/inter/Inter-Regular.otf", "/fonts/inter/Inter-Regular.ttf"};
        objectArray[0] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[1] = CollectionsKt.listOf((Object)"/fonts/inter/Inter-Medium.ttf");
        objectArray2 = new String[]{"/fonts/inter/Inter-SemiBold.otf", "/fonts/inter/Inter-SemiBold.ttf"};
        objectArray[2] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[3] = CollectionsKt.listOf((Object)"/fonts/inter/Inter-Bold.ttf");
        objectArray2 = new String[]{"/fonts/inter/Inter-Italic.otf", "/fonts/inter/Inter-Italic.ttf"};
        objectArray[4] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[5] = CollectionsKt.listOf((Object)"/fonts/inter/Inter-MediumItalic.ttf");
        objectArray2 = new String[]{"/fonts/inter/Inter-SemiBoldItalic.otf", "/fonts/inter/Inter-SemiBoldItalic.ttf"};
        objectArray[6] = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[7] = CollectionsKt.listOf((Object)"/fonts/inter/Inter-BoldItalic.ttf");
        List interFaces = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = interFaces;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            List paths = (List)element$iv;
            boolean bl = false;
            BundledFontsKt.registerBundledFonts$tryAddFont(adder, count, interCount, jbCount, paths, "Inter");
        }
        Object[] $i$f$forEach22 = new List[]{CollectionsKt.listOf((Object)"/fonts/jetbrains-mono/JetBrainsMono-Regular.ttf"), CollectionsKt.listOf((Object)"/fonts/jetbrains-mono/JetBrainsMono-Medium.ttf"), CollectionsKt.listOf((Object)"/fonts/jetbrains-mono/JetBrainsMono-Bold.ttf"), CollectionsKt.listOf((Object)"/fonts/jetbrains-mono/JetBrainsMono-Italic.ttf"), CollectionsKt.listOf((Object)"/fonts/jetbrains-mono/JetBrainsMono-MediumItalic.ttf"), CollectionsKt.listOf((Object)"/fonts/jetbrains-mono/JetBrainsMono-BoldItalic.ttf"), CollectionsKt.listOf((Object)"/fonts/JetBrainsMono/JetBrainsMono-Regular.ttf"), CollectionsKt.listOf((Object)"/fonts/JetBrainsMono/JetBrainsMono-Medium.ttf"), CollectionsKt.listOf((Object)"/fonts/JetBrainsMono/JetBrainsMono-Bold.ttf"), CollectionsKt.listOf((Object)"/fonts/JetBrainsMono/JetBrainsMono-Italic.ttf"), CollectionsKt.listOf((Object)"/fonts/JetBrainsMono/JetBrainsMono-MediumItalic.ttf"), CollectionsKt.listOf((Object)"/fonts/JetBrainsMono/JetBrainsMono-BoldItalic.ttf"), CollectionsKt.listOf((Object)"/JetBrainsMono/JetBrainsMono-Regular.ttf"), CollectionsKt.listOf((Object)"/JetBrainsMono/JetBrainsMono-Medium.ttf"), CollectionsKt.listOf((Object)"/JetBrainsMono/JetBrainsMono-Bold.ttf"), CollectionsKt.listOf((Object)"/JetBrainsMono/JetBrainsMono-Italic.ttf"), CollectionsKt.listOf((Object)"/JetBrainsMono/JetBrainsMono-MediumItalic.ttf"), CollectionsKt.listOf((Object)"/JetBrainsMono/JetBrainsMono-BoldItalic.ttf")};
        List jbMonoFaces = CollectionsKt.listOf((Object[])$i$f$forEach22);
        Iterable $this$forEach$iv2 = jbMonoFaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            List paths = (List)element$iv;
            boolean bl = false;
            BundledFontsKt.registerBundledFonts$tryAddFont(adder, count, interCount, jbCount, paths, "JetBrains Mono");
        }
        log.debug("registerBundledFonts: registered " + count.element + " face(s)");
        return new FontRegSummary(count.element, interCount.element, jbCount.element);
    }

    @Nullable
    public static final String inferAliasFamily(@NotNull String debugLabel, @NotNull String family) {
        String string;
        String fileName;
        Intrinsics.checkNotNullParameter((Object)debugLabel, (String)"debugLabel");
        Intrinsics.checkNotNullParameter((Object)family, (String)"family");
        String base = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)debugLabel, (char)'(', null, (int)2, null))).toString();
        String string2 = fileName = StringsKt.substringAfterLast$default((String)base, (char)'/', null, (int)2, null);
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String lower = string3;
        if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"thin", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lower, (CharSequence)"bold", (boolean)false, (int)2, null)) {
            string = "100";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"extralight", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"extra-light", (boolean)false, (int)2, null)) {
            string = "200";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"light", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lower, (CharSequence)"extra", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lower, (CharSequence)"semi", (boolean)false, (int)2, null)) {
            string = "300";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"regular", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"roman", (boolean)false, (int)2, null)) {
            string = "400";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"medium", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)lower, (CharSequence)"semi", (boolean)false, (int)2, null)) {
            string = "500";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"semibold", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"semi-bold", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"demibold", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"demi-bold", (boolean)false, (int)2, null)) {
            string = "600";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"extrabold", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"extra-bold", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"black", (boolean)false, (int)2, null)) {
            string = "800";
        } else if (StringsKt.contains$default((CharSequence)lower, (CharSequence)"bold", (boolean)false, (int)2, null)) {
            string = "700";
        } else {
            return null;
        }
        String weight = string;
        String italic = StringsKt.contains$default((CharSequence)lower, (CharSequence)"italic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"ital", (boolean)false, (int)2, null) ? " Italic" : "";
        return family + " " + weight + italic;
    }

    private static final InputStream registerBundledFonts$tryAddFromClasspath$lambda$0(ClassLoader $cl, String $p1, String $path) {
        InputStream inputStream = $cl.getResourceAsStream($p1);
        if (inputStream == null && (inputStream = $cl.getResourceAsStream($path)) == null) {
            throw new IllegalStateException("Font resource disappeared: " + $path);
        }
        return inputStream;
    }

    private static final InputStream registerBundledFonts$tryAddFromFilesystem$lambda$3(Path $flatCandidate) {
        Intrinsics.checkNotNull((Object)$flatCandidate);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($flatCandidate, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    private static final InputStream registerBundledFonts$tryAddFromFilesystem$lambda$4(Path $altExtCandidate) {
        Intrinsics.checkNotNull((Object)$altExtCandidate);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($altExtCandidate, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    private static final InputStream registerBundledFonts$tryAddFromFilesystem$lambda$5(Path $candidate) {
        Intrinsics.checkNotNull((Object)$candidate);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($candidate, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    private static final InputStream registerBundledFonts$tryAddFromFilesystem$lambda$6(Path $alt) {
        Intrinsics.checkNotNull((Object)$alt);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($alt, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    private static final void registerBundledFonts$success(Ref.IntRef count, Ref.IntRef interCount, Ref.IntRef jbCount, String family, String label) {
        int n = count.element;
        count.element = n + 1;
        if (Intrinsics.areEqual((Object)family, (Object)"Inter")) {
            n = interCount.element;
            interCount.element = n + 1;
        } else if (Intrinsics.areEqual((Object)family, (Object)"JetBrains Mono")) {
            n = jbCount.element;
            jbCount.element = n + 1;
        }
        log.debug("Registered font: family='" + family + "', path='" + label + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean registerBundledFonts$tryAddFromClasspath(Function3<? super Function0<? extends InputStream>, ? super String, ? super String, Unit> $adder, Ref.IntRef count, Ref.IntRef interCount, Ref.IntRef jbCount, List<String> paths, String family) {
        ClassLoader[] classLoaderArray = new ClassLoader[]{FontRegSummary.class.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()};
        List loaders = CollectionsKt.listOfNotNull((Object[])classLoaderArray);
        for (String path : paths) {
            for (ClassLoader cl : loaders) {
                String p1 = StringsKt.removePrefix((String)path, (CharSequence)"/");
                Function0 supplier = () -> BundledFontsKt.registerBundledFonts$tryAddFromClasspath$lambda$0(cl, p1, path);
                try {
                    Closeable closeable = (Closeable)supplier.invoke();
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                $adder.invoke((Object)supplier, (Object)family, (Object)(path + " (classpath)"));
                BundledFontsKt.registerBundledFonts$success(count, interCount, jbCount, family, path + " (classpath)");
                return true;
            }
        }
        return false;
    }

    private static final boolean registerBundledFonts$tryAddFromFilesystem(Function3<? super Function0<? extends InputStream>, ? super String, ? super String, Unit> $adder, Ref.IntRef count, Ref.IntRef interCount, Ref.IntRef jbCount, List<String> paths, String family) {
        boolean bl;
        try {
            String javaHome = System.getProperty("java.home");
            String userDir = System.getProperty("user.dir");
            List list = CollectionsKt.createListBuilder();
            List $this$registerBundledFonts_u24tryAddFromFilesystem_u24lambda_u242 = list;
            boolean bl2 = false;
            if (javaHome != null) {
                Object object = new String[]{"lib", "fonts"};
                Path path = Paths.get(javaHome, (String[])object);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                $this$registerBundledFonts_u24tryAddFromFilesystem_u24lambda_u242.add(path);
                object = new String[]{"Contents", "Home", "lib", "fonts"};
                Path path2 = Paths.get(javaHome, (String[])object);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                $this$registerBundledFonts_u24tryAddFromFilesystem_u24lambda_u242.add(path2);
            }
            if (userDir != null) {
                Path path = Paths.get(userDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                $this$registerBundledFonts_u24tryAddFromFilesystem_u24lambda_u242.add(path);
            }
            List baseDirs = CollectionsKt.build((List)list);
            for (String path : paths) {
                String rel = StringsKt.removePrefix((String)path, (CharSequence)"/");
                for (Path base : baseDirs) {
                    String alternateExtension;
                    String fileName = StringsKt.substringAfterLast$default((String)rel, (char)'/', null, (int)2, null);
                    Path flatCandidate = base.resolve(fileName);
                    Intrinsics.checkNotNull((Object)flatCandidate);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isRegularFile(flatCandidate, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isReadable(flatCandidate)) {
                        $adder.invoke(() -> BundledFontsKt.registerBundledFonts$tryAddFromFilesystem$lambda$3(flatCandidate), (Object)family, (Object)(flatCandidate + " (JBR)"));
                        BundledFontsKt.registerBundledFonts$success(count, interCount, jbCount, family, flatCandidate + " (JBR)");
                        return true;
                    }
                    String string = StringsKt.endsWith$default((String)fileName, (String)".ttf", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)fileName, (String)".ttf", (String)".otf", (boolean)false, (int)4, null) : (alternateExtension = StringsKt.endsWith$default((String)fileName, (String)".otf", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)fileName, (String)".otf", (String)".ttf", (boolean)false, (int)4, null) : null);
                    if (alternateExtension != null) {
                        Path altExtCandidate = base.resolve(alternateExtension);
                        Intrinsics.checkNotNull((Object)altExtCandidate);
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        if (Files.isRegularFile(altExtCandidate, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Files.isReadable(altExtCandidate)) {
                            $adder.invoke(() -> BundledFontsKt.registerBundledFonts$tryAddFromFilesystem$lambda$4(altExtCandidate), (Object)family, (Object)(altExtCandidate + " (JBR)"));
                            BundledFontsKt.registerBundledFonts$success(count, interCount, jbCount, family, altExtCandidate + " (JBR)");
                            return true;
                        }
                    }
                    Path candidate = base.resolve(rel);
                    Intrinsics.checkNotNull((Object)candidate);
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    if (Files.isRegularFile(candidate, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && Files.isReadable(candidate)) {
                        $adder.invoke(() -> BundledFontsKt.registerBundledFonts$tryAddFromFilesystem$lambda$5(candidate), (Object)family, (Object)(candidate + " (filesystem)"));
                        BundledFontsKt.registerBundledFonts$success(count, interCount, jbCount, family, candidate + " (filesystem)");
                        return true;
                    }
                    String withoutFontsPrefix = StringsKt.startsWith$default((String)rel, (String)"fonts/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)rel, (CharSequence)"fonts/") : rel;
                    Path alt = base.resolve(withoutFontsPrefix);
                    Intrinsics.checkNotNull((Object)alt);
                    LinkOption[] linkOptionArray4 = new LinkOption[]{};
                    if (!Files.isRegularFile(alt, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) || !Files.isReadable(alt)) continue;
                    $adder.invoke(() -> BundledFontsKt.registerBundledFonts$tryAddFromFilesystem$lambda$6(alt), (Object)family, (Object)(alt + " (filesystem, alt)"));
                    BundledFontsKt.registerBundledFonts$success(count, interCount, jbCount, family, alt + " (filesystem, alt)");
                    return true;
                }
            }
            bl = false;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private static final boolean registerBundledFonts$tryAddFont(Function3<? super Function0<? extends InputStream>, ? super String, ? super String, Unit> $adder, Ref.IntRef count, Ref.IntRef interCount, Ref.IntRef jbCount, List<String> paths, String family) {
        if (BundledFontsKt.registerBundledFonts$tryAddFromClasspath($adder, count, interCount, jbCount, paths, family)) {
            return true;
        }
        if (BundledFontsKt.registerBundledFonts$tryAddFromFilesystem($adder, count, interCount, jbCount, paths, family)) {
            return true;
        }
        log.debug("Could not find font for family='" + family + "' in paths=" + paths);
        return false;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

