/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.convert.BundledFontsKt;
import com.intellij.jupyter.core.jupyter.convert.ConversionMode;
import com.intellij.jupyter.core.jupyter.convert.FontRegSummary;
import com.intellij.jupyter.core.jupyter.convert.HtmlSanitizerKt;
import com.intellij.jupyter.core.jupyter.convert.JupyterNotebookToHtmlConverterKt;
import com.intellij.jupyter.core.jupyter.convert.JupyterNotebookToPdfConverter;
import com.intellij.jupyter.core.jupyter.convert.JupyterNotebookToPdfConverterKt;
import com.intellij.jupyter.core.jupyter.convert.LaTexToPdf;
import com.intellij.jupyter.core.jupyter.convert.PageSize;
import com.intellij.jupyter.core.jupyter.convert.SmartTableHeadersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchemaFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.svgsupport.BatikSVGDrawer;
import com.openhtmltopdf.util.XRLog;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J:\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ0\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010$J\"\u0010%\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020'0&2\u0006\u0010 \u001a\u00020!H\u0082@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/jupyter/core/jupyter/convert/JupyterNotebookToPdfConverter;", "", "<init>", "()V", "OPTIMIZE_IMAGES_ENABLED", "", "JPEG_QUALITY", "", "PNG_RECOMPRESS_THRESHOLD_KB", "", "MAX_IMAGE_WIDTH_PX", "", "AUTO_NOWRAP_HEADERS", "disablePdfBoxFontCache", "", "suppressOpenhtmltopdfLogging", "readNotebookResilient", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertToPdf", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "outputStream", "Ljava/io/OutputStream;", "conversionMode", "Lcom/intellij/jupyter/core/jupyter/convert/ConversionMode;", "pageSize", "Lcom/intellij/jupyter/core/jupyter/convert/PageSize;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/io/OutputStream;Lcom/intellij/jupyter/core/jupyter/convert/ConversionMode;Lcom/intellij/jupyter/core/jupyter/convert/PageSize;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertHtmlToPdf", "html", "", "baseUrl", "useFastMode", "(Ljava/lang/String;Ljava/io/OutputStream;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "optimizeImagesAndExternalize", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookToPdfConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookToPdfConverter.kt\ncom/intellij/jupyter/core/jupyter/convert/JupyterNotebookToPdfConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,465:1\n1#2:466\n375#3:467\n375#3:468\n375#3:469\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookToPdfConverter.kt\ncom/intellij/jupyter/core/jupyter/convert/JupyterNotebookToPdfConverter\n*L\n149#1:467\n161#1:468\n178#1:469\n*E\n"})
public final class JupyterNotebookToPdfConverter {
    @NotNull
    public static final JupyterNotebookToPdfConverter INSTANCE = new JupyterNotebookToPdfConverter();
    private static final boolean OPTIMIZE_IMAGES_ENABLED = true;
    private static final float JPEG_QUALITY = 0.85f;
    private static final long PNG_RECOMPRESS_THRESHOLD_KB = 100L;
    private static final int MAX_IMAGE_WIDTH_PX = 1200;
    private static final boolean AUTO_NOWRAP_HEADERS = true;

    private JupyterNotebookToPdfConverter() {
    }

    private final void disablePdfBoxFontCache() {
        try {
            String prev1 = System.getProperty("pdfbox.fontcache");
            String prev2 = System.getProperty("org.apache.pdfbox.fontcache");
            String prev3 = System.getProperty("org.apache.pdfbox.rendering.useDiskFontCache");
            System.setProperty("pdfbox.fontcache", "none");
            System.setProperty("org.apache.pdfbox.fontcache", "none");
            System.setProperty("org.apache.pdfbox.rendering.useDiskFontCache", "false");
            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("[init] PDFBox font cache props set (was pdfbox.fontcache=" + prev1 + ", org.apache.pdfbox.fontcache=" + prev2 + ", useDiskFontCache=" + prev3 + ")");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void suppressOpenhtmltopdfLogging() {
        try {
            XRLog.setLoggingEnabled((boolean)false);
            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("[init] Disabled XRLog to suppress openhtmltopdf logging output");
        }
        catch (Throwable e) {
            JupyterNotebookToPdfConverterKt.access$getLog$p().error("[init] Failed to configure XRLog: " + e.getMessage());
        }
    }

    private final JupyterNotebook readNotebookResilient(VirtualFile virtualFile) {
        JupyterNotebook jupyterNotebook;
        try {
            byte[] byArray = virtualFile.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.UTF_8;
            String text = new String(byArray2, charset);
            JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(text);
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode json = (ObjectNode)jsonNode;
            JupyterNotebookSchema schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(json);
            jupyterNotebook = new JupyterNotebookBase(json, schema);
        }
        catch (Exception e) {
            throw new IOException("Cannot read notebook " + virtualFile.getPath() + " for PDF export", e);
        }
        return jupyterNotebook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object convertToPdf(@NotNull Project project, @NotNull VirtualFile notebookFile, @NotNull OutputStream outputStream, @NotNull ConversionMode conversionMode, @NotNull PageSize pageSize, @NotNull Continuation<? super Unit> $completion) {
        block36: {
            block35: {
                if (!($completion instanceof convertToPdf.1)) ** GOTO lbl-1000
                var27_7 = $completion;
                if ((var27_7.label & -2147483648) != 0) {
                    var27_7.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        Object L$8;
                        Object L$9;
                        Object L$10;
                        Object L$11;
                        Object L$12;
                        Object L$13;
                        Object L$14;
                        Object L$15;
                        boolean Z$0;
                        int I$0;
                        int I$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ JupyterNotebookToPdfConverter this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.convertToPdf(null, null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var28_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("convertToPdf: start for " + notebookFile.getPath());
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Parsing notebook JSON ...");
                        notebook = this.readNotebookResilient(notebookFile);
                        var8_13 = this;
                        try {
                            $this$convertToPdf_u24lambda_u240 = var8_13;
                            $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$2 = false;
                            $this$convertToPdf_u24lambda_u240 = Result.constructor-impl((Object)Boxing.boxInt((int)notebook.computeCells().size()));
                        }
                        catch (Throwable $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$2) {
                            $this$convertToPdf_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$2));
                        }
                        var8_13 = $this$convertToPdf_u24lambda_u240;
                        if (Result.isSuccess-impl((Object)var8_13)) {
                            it = ((Number)var8_13).intValue();
                            $i$a$-onSuccess-JupyterNotebookToPdfConverter$convertToPdf$3 = false;
                            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Notebook parsed: " + it + " cells");
                        }
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)notebookFile);
                        $continuation.L$2 = outputStream;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)conversionMode);
                        $continuation.L$4 = pageSize;
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)notebook);
                        $continuation.label = 1;
                        v0 = JupyterNotebookToHtmlConverterKt.convertToHtml(project, notebook, pageSize, conversionMode, (Continuation<? super Pair<String, Boolean>>)$continuation);
                        if (v0 == var28_9) {
                            return var28_9;
                        }
                        ** GOTO lbl52
                    }
                    case 1: {
                        notebook = (JupyterNotebook)$continuation.L$5;
                        pageSize = (PageSize)$continuation.L$4;
                        conversionMode = (ConversionMode)$continuation.L$3;
                        outputStream = (OutputStream)$continuation.L$2;
                        notebookFile = (VirtualFile)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl52:
                        // 2 sources

                        var8_13 = (Pair)v0;
                        html = (String)var8_13.component1();
                        hasHugeCells = (Boolean)var8_13.component2();
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("HTML generation: length=" + html.length() + ", hasHugeCells=" + (hasHugeCells != false));
                        $i$f$currentCoroutineContext = false;
                        JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                        htmlForPdf = new Ref.ObjectRef();
                        htmlForPdf.element = html;
                        tempDirForImages = new Ref.ObjectRef();
                        baseUrlForPdf = new Ref.ObjectRef();
                        var14_33 = this;
                        $this$convertToPdf_u24lambda_u242 = (JupyterNotebookToPdfConverter)var14_33;
                        $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$4 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)notebookFile);
                        $continuation.L$2 = outputStream;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)conversionMode);
                        $continuation.L$4 = pageSize;
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)notebook);
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)html);
                        $continuation.L$7 = htmlForPdf;
                        $continuation.L$8 = tempDirForImages;
                        $continuation.L$9 = baseUrlForPdf;
                        $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)$this$convertToPdf_u24lambda_u242);
                        $continuation.Z$0 = hasHugeCells;
                        $continuation.I$0 = $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$4;
                        $continuation.label = 2;
                        v1 = super.optimizeImagesAndExternalize(html, (Continuation<? super Pair<String, ? extends Path>>)$continuation);
                        ** if (v1 != var28_9) goto lbl87
lbl86:
                        // 1 sources

                        return var28_9;
lbl87:
                        // 1 sources

                        ** GOTO lbl106
                    }
                    case 2: {
                        $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$4 = $continuation.I$0;
                        hasHugeCells = $continuation.Z$0;
                        $this$convertToPdf_u24lambda_u242 = (JupyterNotebookToPdfConverter)$continuation.L$10;
                        baseUrlForPdf = (Ref.ObjectRef)$continuation.L$9;
                        tempDirForImages = (Ref.ObjectRef)$continuation.L$8;
                        htmlForPdf = (Ref.ObjectRef)$continuation.L$7;
                        html = (String)$continuation.L$6;
                        notebook = (JupyterNotebook)$continuation.L$5;
                        pageSize = (PageSize)$continuation.L$4;
                        conversionMode = (ConversionMode)$continuation.L$3;
                        outputStream = (OutputStream)$continuation.L$2;
                        notebookFile = (VirtualFile)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl106:
                            // 2 sources

                            pair = (Pair)v1;
                            var18_50 = $continuation;
                            $i$f$currentCoroutineContext = false;
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            htmlForPdf.element = pair.getFirst();
                            tempDirForImages.element = pair.getSecond();
                            v2 = (Path)tempDirForImages.element;
                            baseUrlForPdf.element = v2 != null && (v2 = v2.toUri()) != null ? v2.toString() : null;
                            $this$convertToPdf_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$4) {
                            $this$convertToPdf_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$4));
                        }
                        var14_33 = $this$convertToPdf_u24lambda_u242;
                        v3 = Result.exceptionOrNull-impl((Object)var14_33);
                        if (v3 != null) {
                            e = $this$convertToPdf_u24lambda_u242 = v3;
                            $i$a$-onFailure-JupyterNotebookToPdfConverter$convertToPdf$5 = false;
                            JupyterNotebookToPdfConverterKt.access$getLog$p().error("Image optimization failed: " + e.getMessage());
                        }
                        htmlAnnotated = SmartTableHeadersKt.annotateTablesForSmartHeaders((String)htmlForPdf.element, pageSize);
                        htmlFinal = LaTexToPdf.INSTANCE.stripLatexAltText(htmlAnnotated);
                        xhtml = HtmlSanitizerKt.sanitizeHtmlToXhtml(htmlFinal);
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("XHTML sanitization complete: length=" + xhtml.length());
                        $i$f$currentCoroutineContext = false;
                        JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)notebookFile);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)outputStream);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)conversionMode);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)pageSize);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)notebook);
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)html);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)htmlForPdf);
                        $continuation.L$8 = tempDirForImages;
                        $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)baseUrlForPdf);
                        $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)htmlAnnotated);
                        $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)htmlFinal);
                        $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)xhtml);
                        $continuation.Z$0 = hasHugeCells;
                        $continuation.label = 3;
                        v4 = this.convertHtmlToPdf(xhtml, outputStream, (String)baseUrlForPdf.element, hasHugeCells != false, (Continuation<? super Unit>)$continuation);
                        ** if (v4 != var28_9) goto lbl156
lbl155:
                        // 1 sources

                        return var28_9;
lbl156:
                        // 1 sources

                        ** GOTO lbl176
                    }
                    case 3: {
                        hasHugeCells = $continuation.Z$0;
                        xhtml = (String)$continuation.L$12;
                        htmlFinal = (String)$continuation.L$11;
                        htmlAnnotated = (String)$continuation.L$10;
                        baseUrlForPdf = (Ref.ObjectRef)$continuation.L$9;
                        tempDirForImages = (Ref.ObjectRef)$continuation.L$8;
                        htmlForPdf = (Ref.ObjectRef)$continuation.L$7;
                        html = (String)$continuation.L$6;
                        notebook = (JupyterNotebook)$continuation.L$5;
                        pageSize = (PageSize)$continuation.L$4;
                        conversionMode = (ConversionMode)$continuation.L$3;
                        outputStream = (OutputStream)$continuation.L$2;
                        notebookFile = (VirtualFile)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl176:
                        // 2 sources

                        v5 = (Path)tempDirForImages.element;
                        if (v5 == null) break;
                        dir = v5;
                        $i$a$-let-JupyterNotebookToPdfConverter$convertToPdf$6 = 0;
                        var21_56 = JupyterNotebookToPdfConverter.INSTANCE;
                        $this$convertToPdf_u24lambda_u244_u240 = var21_56;
                        $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)notebookFile);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)outputStream);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)conversionMode);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)pageSize);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)notebook);
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)html);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)htmlForPdf);
                        $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)tempDirForImages);
                        $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)baseUrlForPdf);
                        $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)htmlAnnotated);
                        $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)htmlFinal);
                        $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)xhtml);
                        $continuation.L$13 = dir;
                        $continuation.L$14 = SpillingKt.nullOutSpilledVariable((Object)$this$convertToPdf_u24lambda_u244_u240);
                        $continuation.Z$0 = hasHugeCells;
                        $continuation.I$0 = $i$a$-let-JupyterNotebookToPdfConverter$convertToPdf$6;
                        $continuation.I$1 = $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1;
                        $continuation.label = 4;
                        v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dir, null){
                            int label;
                            final /* synthetic */ Path $dir;
                            {
                                this.$dir = $dir;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        PathsKt.deleteRecursively((Path)this.$dir);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        ** if (v6 != var28_9) goto lbl208
lbl207:
                        // 1 sources

                        return var28_9;
lbl208:
                        // 1 sources

                        ** GOTO lbl232
                    }
                    case 4: {
                        $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1 = $continuation.I$1;
                        $i$a$-let-JupyterNotebookToPdfConverter$convertToPdf$6 = $continuation.I$0;
                        hasHugeCells = $continuation.Z$0;
                        $this$convertToPdf_u24lambda_u244_u240 = (JupyterNotebookToPdfConverter)$continuation.L$14;
                        dir = (Path)$continuation.L$13;
                        xhtml = (String)$continuation.L$12;
                        htmlFinal = (String)$continuation.L$11;
                        htmlAnnotated = (String)$continuation.L$10;
                        baseUrlForPdf = (Ref.ObjectRef)$continuation.L$9;
                        tempDirForImages = (Ref.ObjectRef)$continuation.L$8;
                        htmlForPdf = (Ref.ObjectRef)$continuation.L$7;
                        html = (String)$continuation.L$6;
                        notebook = (JupyterNotebook)$continuation.L$5;
                        pageSize = (PageSize)$continuation.L$4;
                        conversionMode = (ConversionMode)$continuation.L$3;
                        outputStream = (OutputStream)$continuation.L$2;
                        notebookFile = (VirtualFile)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl232:
                            // 2 sources

                            $this$convertToPdf_u24lambda_u244_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1) {
                            $this$convertToPdf_u24lambda_u244_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1));
                        }
                        var21_56 = $this$convertToPdf_u24lambda_u244_u240;
                        if (Result.isSuccess-impl((Object)var21_56)) {
                            it = (Unit)var21_56;
                            $i$a$-onSuccess-JupyterNotebookToPdfConverter$convertToPdf$6$2 = false;
                            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Cleaned up temp image directory: " + dir);
                        }
                        v7 = Result.exceptionOrNull-impl((Object)var21_56);
                        if (v7 != null) {
                            e = var22_59 = v7;
                            $i$a$-onFailure-JupyterNotebookToPdfConverter$convertToPdf$6$3 = false;
                            JupyterNotebookToPdfConverterKt.access$getLog$p().error("Failed to delete temp image directory: " + e.getMessage());
                        }
                        Result.box-impl((Object)var21_56);
                        break block36;
                    }
                }
                break block36;
                catch (Throwable var17_48) {
                    v8 = (Path)tempDirForImages.element;
                    if (v8 == null) break block35;
                    dir = v8;
                    $i$a$-let-JupyterNotebookToPdfConverter$convertToPdf$6 = 0;
                    var22_60 = JupyterNotebookToPdfConverter.INSTANCE;
                    $this$convertToPdf_u24lambda_u244_u240 = var22_60;
                    $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)notebookFile);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)outputStream);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)conversionMode);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)pageSize);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)notebook);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)html);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)htmlForPdf);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)tempDirForImages);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)baseUrlForPdf);
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)htmlAnnotated);
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)htmlFinal);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)xhtml);
                    $continuation.L$13 = var17_48;
                    $continuation.L$14 = dir;
                    $continuation.L$15 = SpillingKt.nullOutSpilledVariable((Object)$this$convertToPdf_u24lambda_u244_u240);
                    $continuation.Z$0 = hasHugeCells;
                    $continuation.I$0 = $i$a$-let-JupyterNotebookToPdfConverter$convertToPdf$6;
                    $continuation.I$1 = $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1;
                    $continuation.label = 5;
                    v9 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
                    ** if (v9 != var28_9) goto lbl288
lbl287:
                    // 1 sources

                    return var28_9;
lbl288:
                    // 1 sources

                    ** GOTO lbl313
                }
                {
                    case 5: {
                        $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1 = $continuation.I$1;
                        $i$a$-let-JupyterNotebookToPdfConverter$convertToPdf$6 = $continuation.I$0;
                        hasHugeCells = $continuation.Z$0;
                        $this$convertToPdf_u24lambda_u244_u240 = (JupyterNotebookToPdfConverter)$continuation.L$15;
                        dir = (Path)$continuation.L$14;
                        var17_49 = (Throwable)$continuation.L$13;
                        xhtml = (String)$continuation.L$12;
                        htmlFinal = (String)$continuation.L$11;
                        htmlAnnotated = (String)$continuation.L$10;
                        baseUrlForPdf = (Ref.ObjectRef)$continuation.L$9;
                        tempDirForImages = (Ref.ObjectRef)$continuation.L$8;
                        htmlForPdf = (Ref.ObjectRef)$continuation.L$7;
                        html = (String)$continuation.L$6;
                        notebook = (JupyterNotebook)$continuation.L$5;
                        pageSize = (PageSize)$continuation.L$4;
                        conversionMode = (ConversionMode)$continuation.L$3;
                        outputStream = (OutputStream)$continuation.L$2;
                        notebookFile = (VirtualFile)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl313:
                        // 2 sources

                        $this$convertToPdf_u24lambda_u244_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                        {
                            catch (Throwable $i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1) {
                                $this$convertToPdf_u24lambda_u244_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JupyterNotebookToPdfConverter$convertToPdf$6$1));
                            }
                        }
                        var22_60 = $this$convertToPdf_u24lambda_u244_u240;
                        if (Result.isSuccess-impl((Object)var22_60)) {
                            it = (Unit)var22_60;
                            $i$a$-onSuccess-JupyterNotebookToPdfConverter$convertToPdf$6$2 = false;
                            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Cleaned up temp image directory: " + dir);
                        }
                        v10 = Result.exceptionOrNull-impl((Object)var22_60);
                        if (v10 != null) {
                            e = var23_64 = v10;
                            $i$a$-onFailure-JupyterNotebookToPdfConverter$convertToPdf$6$3 = false;
                            JupyterNotebookToPdfConverterKt.access$getLog$p().error("Failed to delete temp image directory: " + e.getMessage());
                        }
                        Result.box-impl((Object)var22_60);
                        break;
                    }
                }
            }
            throw var17_49;
        }
        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("convertToPdf: finished ");
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object convertToPdf$default(JupyterNotebookToPdfConverter jupyterNotebookToPdfConverter, Project project, VirtualFile virtualFile, OutputStream outputStream, ConversionMode conversionMode, PageSize pageSize, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            conversionMode = ConversionMode.EntireNotebook;
        }
        if ((n & 0x10) != 0) {
            pageSize = PageSize.Letter;
        }
        return jupyterNotebookToPdfConverter.convertToPdf(project, virtualFile, outputStream, conversionMode, pageSize, (Continuation<? super Unit>)continuation);
    }

    private final Object convertHtmlToPdf(String html, OutputStream outputStream, String baseUrl, boolean useFastMode, Continuation<? super Unit> $completion) {
        JupyterNotebookToPdfConverter jupyterNotebookToPdfConverter = this;
        try {
            JupyterNotebookToPdfConverter $this$convertHtmlToPdf_u24lambda_u240 = jupyterNotebookToPdfConverter;
            boolean bl = false;
            String jre = System.getProperty("java.runtime.version");
            String jh = System.getProperty("java.home");
            String headless = System.getProperty("java.awt.headless");
            String os = System.getProperty("os.name");
            boolean cssHasGenericFallback = StringsKt.contains$default((CharSequence)html, (CharSequence)"sans-serif", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)html, (CharSequence)"monospace", (boolean)false, (int)2, null);
            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Env: os='" + os + "', java.home='" + jh + "', runtime='" + jre + "', headless='" + headless + "', cssHasGenericFallback=" + cssHasGenericFallback);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String baseUrlForPdf = baseUrl;
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(outputStream, html, useFastMode, baseUrlForPdf, null){
            int label;
            final /* synthetic */ OutputStream $outputStream;
            final /* synthetic */ String $html;
            final /* synthetic */ boolean $useFastMode;
            final /* synthetic */ String $baseUrlForPdf;
            {
                this.$outputStream = $outputStream;
                this.$html = $html;
                this.$useFastMode = $useFastMode;
                this.$baseUrlForPdf = $baseUrlForPdf;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Closeable closeable = this.$outputStream;
                        String string = this.$html;
                        boolean bl = this.$useFastMode;
                        String string2 = this.$baseUrlForPdf;
                        Throwable throwable = null;
                        try {
                            OutputStream os = (OutputStream)closeable;
                            boolean bl2 = false;
                            PdfRendererBuilder builder = new PdfRendererBuilder();
                            FontRegSummary reg = BundledFontsKt.registerBundledFonts((Function3<? super Function0<? extends InputStream>, ? super String, ? super String, Unit>)((Function3)(arg_0, arg_1, arg_2) -> convertHtmlToPdf.3.invokeSuspend$lambda$0$0(builder, arg_0, arg_1, arg_2)));
                            JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Font registration: " + reg.getTotal() + " faces (Inter=" + reg.getInter() + ", JBMono=" + reg.getJbMono() + ")");
                            if (reg.getTotal() == 0) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().warn("No bundled fonts registered for PDF export; proceeding with generic fallbacks/system fonts.");
                            }
                            if (reg.getJbMono() == 0) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().error("JetBrains Mono font not registered! Code will use system monospace fallback. This likely means font resources are not on the classpath.");
                            }
                            String htmlToUse = string;
                            if (reg.getInter() == 0 && reg.getJbMono() > 0) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().warn("Inter fonts not found; switching body font-family to 'JetBrains Mono' to avoid system fallback");
                                htmlToUse = StringsKt.replace$default((String)htmlToUse, (String)"font-family: 'Inter';", (String)"font-family: 'JetBrains Mono';", (boolean)false, (int)4, null);
                            }
                            if (reg.getJbMono() == 0) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().warn("JetBrains Mono not registered; replacing with 'monospace' fallback in CSS");
                                htmlToUse = StringsKt.replace$default((String)htmlToUse, (String)"font-family: 'JetBrains Mono'", (String)"font-family: monospace", (boolean)false, (int)4, null);
                            }
                            if (reg.getTotal() > 0 && (StringsKt.contains$default((CharSequence)htmlToUse, (CharSequence)", sans-serif", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)htmlToUse, (CharSequence)", monospace", (boolean)false, (int)2, null))) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Stripping generic CSS fallbacks ('sans-serif','monospace') from export HTML to prevent system fallback");
                                htmlToUse = StringsKt.replace$default((String)StringsKt.replace$default((String)htmlToUse, (String)", sans-serif", (String)"", (boolean)false, (int)4, null), (String)", monospace", (String)"", (boolean)false, (int)4, null);
                            }
                            if (bl) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Enabling fast mode for huge cells");
                                builder.useFastMode();
                            }
                            try {
                                BatikSVGDrawer svgDrawer = new BatikSVGDrawer();
                                builder.useSVGDrawer((SVGDrawer)svgDrawer);
                                JupyterNotebookToPdfConverterKt.access$getLog$p().debug("SVG support enabled via BatikSVGDrawer");
                            }
                            catch (Throwable e) {
                                JupyterNotebookToPdfConverterKt.access$getLog$p().error("Failed to enable SVG support!", e);
                            }
                            builder.withHtmlContent(htmlToUse, string2);
                            builder.toStream(os);
                            builder.run();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final InputStream invokeSuspend$lambda$0$0$0(Function0 $supplier) {
                return (InputStream)$supplier.invoke();
            }

            private static final InputStream invokeSuspend$lambda$0$0$1(Function0 $supplier) {
                return (InputStream)$supplier.invoke();
            }

            private static final Unit invokeSuspend$lambda$0$0(PdfRendererBuilder $builder, Function0 supplier, String family, String debugLabel) {
                $builder.useFont(() -> convertHtmlToPdf.3.invokeSuspend$lambda$0$0$0(supplier), family);
                JupyterNotebookToPdfConverterKt.access$getLog$p().debug("[PDF-FONT] Registered: family='" + family + "', file='" + debugLabel + "'");
                String alias = BundledFontsKt.inferAliasFamily(debugLabel, family);
                if (alias != null) {
                    $builder.useFont(() -> convertHtmlToPdf.3.invokeSuspend$lambda$0$0$1(supplier), alias);
                    JupyterNotebookToPdfConverterKt.access$getLog$p().debug("[PDF-FONT] Registered alias: '" + alias + "' for " + debugLabel);
                }
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object optimizeImagesAndExternalize(String html, Continuation<? super Pair<String, ? extends Path>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends String, ? extends Path>>, Object>(html, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            float F$0;
            long J$0;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $html;
            {
                this.$html = $html;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var30_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Optimizing images (downscale/recompress) and externalizing data URIs ...");
                        baseDir = Files.createTempDirectory("jup-pdf-res", new FileAttribute[0]);
                        jpegQ = RangesKt.coerceIn((float)0.85f, (float)0.1f, (float)1.0f);
                        pngThresholdKb = RangesKt.coerceAtLeast((long)100L, (long)0L);
                        maxWidthPx = RangesKt.coerceAtLeast((int)1200, (int)256);
                        cache = new ConcurrentHashMap<String, Path>();
                        var10_9 = new RegexOption[]{RegexOption.IGNORE_CASE, RegexOption.DOT_MATCHES_ALL};
                        imgRe = new Regex("(<img[^>]+src=\")(data:image/(?:png|jpeg);base64,[^\"]+)(\"[^>]*>)", SetsKt.setOf((Object[])var10_9));
                        matches = SequencesKt.toList((Sequence)Regex.findAll$default((Regex)imgRe, (CharSequence)this.$html, (int)0, (int)2, null));
                        if (matches.isEmpty()) {
                            return TuplesKt.to((Object)this.$html, (Object)baseDir);
                        }
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Processing " + matches.size() + " images in parallel ...");
                        $this$map$iv = matches;
                        $i$f$map = false;
                        var14_14 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var19_29 = (MatchResult)item$iv$iv;
                            var29_32 = destination$iv$iv;
                            $i$a$-map-JupyterNotebookToPdfConverter$optimizeImagesAndExternalize$2$jobs$1 = false;
                            var29_32.add(BuildersKt.async$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends Pair<? extends IntRange, ? extends String>, ? extends Boolean>>, Object>((MatchResult)m, maxWidthPx, pngThresholdKb, jpegQ, cache, baseDir, null){
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                Object L$4;
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ MatchResult $m;
                                final /* synthetic */ int $maxWidthPx;
                                final /* synthetic */ long $pngThresholdKb;
                                final /* synthetic */ float $jpegQ;
                                final /* synthetic */ ConcurrentHashMap<String, Path> $cache;
                                final /* synthetic */ Path $baseDir;
                                {
                                    this.$m = $m;
                                    this.$maxWidthPx = $maxWidthPx;
                                    this.$pngThresholdKb = $pngThresholdKb;
                                    this.$jpegQ = $jpegQ;
                                    this.$cache = $cache;
                                    this.$baseDir = $baseDir;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = (CoroutineScope)this.L$0;
                                    var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            $i$f$currentCoroutineContext = false;
                                            JobKt.ensureActive((CoroutineContext)this.getContext());
                                            full = (String)this.$m.getGroupValues().get(2);
                                            v0 = optimizeImagesAndExternalize.2.access$invokeSuspend$decodeDataUrl(full);
                                            if (v0 == null) {
                                                return TuplesKt.to(null, (Object)Boxing.boxBoolean((boolean)false));
                                            }
                                            decoded = v0;
                                            mime = (String)decoded.component1();
                                            bytes0 = (byte[])decoded.component2();
                                            $i$f$currentCoroutineContext = false;
                                            JobKt.ensureActive((CoroutineContext)this.getContext());
                                            this.L$0 = $this$async;
                                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)full);
                                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)decoded);
                                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)mime);
                                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)bytes0);
                                            this.label = 1;
                                            v1 = optimizeImagesAndExternalize.2.access$invokeSuspend$resampleAndMaybeReencode(this.$maxWidthPx, this.$pngThresholdKb, this.$jpegQ, bytes0, mime, (Continuation)this);
                                            if (v1 == var15_3) {
                                                return var15_3;
                                            }
                                            ** GOTO lbl36
                                        }
                                        case 1: {
                                            bytes0 = (byte[])this.L$4;
                                            mime = (String)this.L$3;
                                            decoded = (Pair)this.L$2;
                                            full = (String)this.L$1;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl36:
                                            // 2 sources

                                            var7_14 = (Pair)v1;
                                            bytes1 = (byte[])var7_14.component1();
                                            mime1 = (String)var7_14.component2();
                                            v2 = optimizeImagesAndExternalize.2.access$invokeSuspend$writeImage(this.$cache, this.$baseDir, bytes1, mime1);
                                            if (v2 == null) {
                                                var11_17 = $this$async;
                                                var12_18 = this.$m;
                                                $this$invokeSuspend_u24lambda_u240 = var11_17;
                                                $i$a$-run-JupyterNotebookToPdfConverter$optimizeImagesAndExternalize$2$jobs$1$1$path$1 = false;
                                                JupyterNotebookToPdfConverterKt.access$getLog$p().warn("Image optimization failed for image at " + var12_18.getRange() + ", keeping original data URI");
                                                return TuplesKt.to(null, (Object)Boxing.boxBoolean((boolean)false));
                                            }
                                            path = v2;
                                            return TuplesKt.to((Object)TuplesKt.to((Object)this.$m.getRange(), (Object)("" + this.$m.getGroupValues().get(1) + path.getFileName() + this.$m.getGroupValues().get(3))), (Object)Boxing.boxBoolean((boolean)true));
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Pair<Pair<IntRange, String>, Boolean>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        jobs = (List)destination$iv$iv;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                        this.L$1 = baseDir;
                        this.L$2 = SpillingKt.nullOutSpilledVariable(cache);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)imgRe);
                        this.L$4 = matches;
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)jobs);
                        this.F$0 = jpegQ;
                        this.J$0 = pngThresholdKb;
                        this.I$0 = maxWidthPx;
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)jobs, (Continuation)((Continuation)this));
                        if (v0 == var30_3) {
                            return var30_3;
                        }
                        ** GOTO lbl57
                    }
                    case 1: {
                        maxWidthPx = this.I$0;
                        pngThresholdKb = this.J$0;
                        jpegQ = this.F$0;
                        jobs = (List)this.L$5;
                        matches = (List)this.L$4;
                        imgRe = (Regex)this.L$3;
                        cache = (ConcurrentHashMap<String, Path>)this.L$2;
                        baseDir = (Path)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl57:
                        // 2 sources

                        results = (List)v0;
                        $this$mapNotNull$iv = results;
                        $i$f$mapNotNull = false;
                        $i$f$mapTo = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        var21_34 = $this$forEach$iv$iv$iv.iterator();
                        while (var21_34.hasNext()) {
                            element$iv$iv = element$iv$iv$iv = var21_34.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            it = (Pair)element$iv$iv;
                            $i$a$-mapNotNull-JupyterNotebookToPdfConverter$optimizeImagesAndExternalize$2$replacements$1 = false;
                            if ((Pair)it.getFirst() == null) continue;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        replacements = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                        $this$count$iv = results;
                        $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            v1 = 0;
                        } else {
                            count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it = (Pair)element$iv;
                                $i$a$-count-JupyterNotebookToPdfConverter$optimizeImagesAndExternalize$2$failedCount$1 = false;
                                if (!((Boolean)it.getSecond() == false) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            v1 = failedCount = count$iv;
                        }
                        if (failedCount > 0) {
                            JupyterNotebookToPdfConverterKt.access$getLog$p().warn("Image optimization: " + failedCount + " of " + matches.size() + " images failed and were kept as data URIs");
                        }
                        sb = new StringBuilder();
                        lastIdx = 0;
                        for (MatchResult m : matches) {
                            replacement = (String)replacements.get(m.getRange());
                            if (replacement == null) continue;
                            sb.append(this.$html, lastIdx, m.getRange().getFirst());
                            sb.append(replacement);
                            lastIdx = m.getRange().getLast() + 1;
                        }
                        sb.append(this.$html, lastIdx, this.$html.length());
                        JupyterNotebookToPdfConverterKt.access$getLog$p().debug("Image optimization: externalized " + replacements.size() + " data URI image(s) to " + baseDir);
                        return TuplesKt.to((Object)sb.toString(), (Object)baseDir);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<String, ? extends Path>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CharSequence invokeSuspend$sha1$lambda$0(byte it) {
                String string = "%02x";
                Object[] objectArray = new Object[]{it};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }

            private static final String invokeSuspend$sha1(byte[] bytes) {
                byte[] byArray = MessageDigest.getInstance("SHA-1").digest(bytes);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, optimizeImagesAndExternalize.2::invokeSuspend$sha1$lambda$0, (int)30, null);
            }

            private static final Pair<String, byte[]> invokeSuspend$decodeDataUrl(String url) {
                Object object;
                int comma = StringsKt.indexOf$default((CharSequence)url, (char)',', (int)0, (boolean)false, (int)6, null);
                if (comma <= 0) {
                    return null;
                }
                String string = url.substring(5, comma);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String header = string;
                String mime = StringsKt.substringBefore$default((String)header, (char)';', null, (int)2, null);
                String string2 = url.substring(comma + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String payload = string2;
                try {
                    object = payload;
                    Regex regex = new Regex("\\s");
                    String string3 = "";
                    object = Base64.getDecoder().decode(regex.replace((CharSequence)object, string3));
                }
                catch (Exception e) {
                    JupyterNotebookToPdfConverterKt.access$getLog$p().warn("Failed to decode base64 image: " + e.getMessage());
                    return null;
                }
                Object bytes = object;
                return TuplesKt.to((Object)mime, (Object)bytes);
            }

            private static final Path invokeSuspend$writeImage(ConcurrentHashMap<String, Path> cache, Path baseDir, byte[] bytes, String mime) {
                Path path;
                String id = optimizeImagesAndExternalize.2.invokeSuspend$sha1(bytes);
                Path path2 = cache.get(id);
                if (path2 != null) {
                    Path it = path2;
                    boolean bl = false;
                    return it;
                }
                String ext = StringsKt.contains((CharSequence)mime, (CharSequence)"jpeg", (boolean)true) || StringsKt.contains((CharSequence)mime, (CharSequence)"jpg", (boolean)true) ? "jpg" : "png";
                Path file = baseDir.resolve(id + "." + ext);
                try {
                    Files.write(file, bytes, new OpenOption[0]);
                    cache.putIfAbsent(id, file);
                    path = cache.get(id);
                }
                catch (Exception e) {
                    JupyterNotebookToPdfConverterKt.access$getLog$p().error("Failed to write externalized image to " + file + ": " + e.getMessage());
                    path = null;
                }
                return path;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final Object invokeSuspend$resampleAndMaybeReencode(int maxWidthPx, long pngThresholdKb, float jpegQ, byte[] bytes, String mime, Continuation<? super Pair<byte[], String>> $completion) {
                BufferedImage bufferedImage;
                try {
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                }
                catch (Throwable throwable) {
                    bufferedImage = null;
                }
                BufferedImage img = bufferedImage;
                if (img == null) {
                    return TuplesKt.to((Object)bytes, (Object)mime);
                }
                BufferedImage target = img;
                boolean $i$f$currentCoroutineContext = false;
                JobKt.ensureActive((CoroutineContext)$completion.getContext());
                if (img.getWidth() > maxWidthPx) {
                    int nh = RangesKt.coerceAtLeast((int)((int)((double)img.getHeight() * (double)maxWidthPx / (double)img.getWidth())), (int)1);
                    BufferedImage bufferedImage2 = UIUtil.createImage((int)maxWidthPx, (int)nh, (int)(img.getColorModel().hasAlpha() ? 2 : 1));
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"createImage(...)");
                    BufferedImage scaled = bufferedImage2;
                    Graphics2D g = scaled.createGraphics();
                    try {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        g.drawImage(img, 0, 0, maxWidthPx, nh, null);
                    }
                    finally {
                        g.dispose();
                    }
                    target = scaled;
                }
                $i$f$currentCoroutineContext = false;
                JobKt.ensureActive((CoroutineContext)$completion.getContext());
                if (!target.getColorModel().hasAlpha() && StringsKt.equals((String)mime, (String)"image/png", (boolean)true) && (long)bytes.length >= pngThresholdKb * (long)1024) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
                    if (writers.hasNext()) {
                        ImageWriter w = writers.next();
                        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
                        w.setOutput(ios);
                        ImageWriteParam iwp = w.getDefaultWriteParam();
                        iwp.setCompressionMode(2);
                        iwp.setCompressionQuality(jpegQ);
                        try {
                            w.write(null, new IIOImage(target, null, null), iwp);
                            ios.close();
                            w.dispose();
                            return TuplesKt.to((Object)baos.toByteArray(), (Object)"image/jpeg");
                        }
                        catch (Exception e) {
                            JupyterNotebookToPdfConverterKt.access$getLog$p().warn("JPEG recompression failed: " + e.getMessage());
                        }
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)target, "png", baos);
                    return TuplesKt.to((Object)baos.toByteArray(), (Object)"image/png");
                }
                catch (Exception e) {
                    JupyterNotebookToPdfConverterKt.access$getLog$p().warn("PNG encoding failed: " + e.getMessage());
                    return TuplesKt.to((Object)bytes, (Object)mime);
                }
            }

            public static final /* synthetic */ Pair access$invokeSuspend$decodeDataUrl(String url) {
                return optimizeImagesAndExternalize.2.invokeSuspend$decodeDataUrl(url);
            }

            public static final /* synthetic */ Object access$invokeSuspend$resampleAndMaybeReencode(int maxWidthPx, long pngThresholdKb, float jpegQ, byte[] bytes, String mime, Continuation $completion) {
                return optimizeImagesAndExternalize.2.invokeSuspend$resampleAndMaybeReencode(maxWidthPx, pngThresholdKb, jpegQ, bytes, mime, (Continuation<? super Pair<byte[], String>>)$completion);
            }

            public static final /* synthetic */ Path access$invokeSuspend$writeImage(ConcurrentHashMap cache, Path baseDir, byte[] bytes, String mime) {
                return optimizeImagesAndExternalize.2.invokeSuspend$writeImage(cache, baseDir, bytes, mime);
            }
        }), $completion);
    }

    public static final /* synthetic */ Object access$convertHtmlToPdf(JupyterNotebookToPdfConverter $this, String html, OutputStream outputStream, String baseUrl, boolean useFastMode, Continuation $completion) {
        return $this.convertHtmlToPdf(html, outputStream, baseUrl, useFastMode, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$optimizeImagesAndExternalize(JupyterNotebookToPdfConverter $this, String html, Continuation $completion) {
        return $this.optimizeImagesAndExternalize(html, (Continuation<? super Pair<String, ? extends Path>>)$completion);
    }

    static {
        INSTANCE.disablePdfBoxFontCache();
        INSTANCE.suppressOpenhtmltopdfLogging();
    }
}

