/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterTypes;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterDiffLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "<init>", "()V", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Lorg/jetbrains/annotations/NotNull;", "markerTypes", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "isMarkerElement", "", "createLineSeparator", "intellij.jupyter.core"})
public final class JupyterDiffLineMarkerProvider
implements LineMarkerProvider {
    @NotNull
    private final EditorColorsScheme scheme;
    @NotNull
    private final Set<IElementType> markerTypes;

    public JupyterDiffLineMarkerProvider() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        this.scheme = editorColorsScheme;
        Object[] objectArray = new IElementType[]{JupyterTypes.MARKDOWN_MARKER, JupyterTypes.CODE_MARKER, JupyterTypes.RAW_MARKER, JupyterTypes.CELL_MARKER};
        this.markerTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.isMarkerElement(element) ? this.createLineSeparator(element) : null;
    }

    private final boolean isMarkerElement(PsiElement element) {
        return element instanceof LeafPsiElement && this.markerTypes.contains(((LeafPsiElement)element).getElementType());
    }

    private final LineMarkerInfo<?> createLineSeparator(PsiElement element) {
        TextRange textRange = element.getTextRange();
        return (LineMarkerInfo)new LineMarkerInfo<PsiElement>(this, element, textRange){
            {
                this.separatorColor = JupyterDiffLineMarkerProvider.access$getScheme$p($receiver).getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
                this.separatorPlacement = SeparatorPlacement.TOP;
            }

            public MarkupEditorFilter getEditorFilter() {
                MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsDiffFilter();
                Intrinsics.checkNotNullExpressionValue((Object)markupEditorFilter, (String)"createIsDiffFilter(...)");
                return markupEditorFilter;
            }
        };
    }

    public static final /* synthetic */ EditorColorsScheme access$getScheme$p(JupyterDiffLineMarkerProvider $this) {
        return $this.scheme;
    }
}

