/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCell;
import com.intellij.jupyter.core.editor.markdown.NotebookStructureElement;
import com.intellij.jupyter.core.editor.settings.JupyterDSettingsMarkdownRenderMode;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.markdown.JupyterMarkdownHtmlPane;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputApi;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.JupyterWebOutputPanel;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterMarkdownHelperKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.CustomFoldingEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.InputComponent;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.notebooks.visualization.ui.TextEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 S2\u00020\u00012\u00020\u0002:\u0001SB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u001dH\u0002J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0010H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010,\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0006H\u0016J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\u001dH\u0016J(\u00102\u001a\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001204\u0012\u0006\u0012\u0004\u0018\u000105032\b\u00106\u001a\u0004\u0018\u000107H\u0002J3\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u000105032\u000b\u00109\u001a\u00070:\u00a2\u0006\u0002\b;2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0002J\u001a\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020\u00062\b\b\u0002\u0010@\u001a\u00020\u0006H\u0003J\u0010\u0010A\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010B\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J0\u0010C\u001a\u00020\u001d\"\b\b\u0000\u0010D*\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0014\u0010E\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000107\u0012\u0004\u0012\u0002HD0FH\u0002J\b\u0010G\u001a\u00020HH\u0002J\u0012\u0010I\u001a\u00020J2\b\u00106\u001a\u0004\u0018\u000107H\u0002J \u0010K\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020L2\u0006\u0010M\u001a\u0002002\u0006\u0010N\u001a\u000200H\u0002J\"\u0010O\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/InputComponent;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "foldingEnabled", "", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;Z)V", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "contributedPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "foldedRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "renderedComponent", "Ljavax/swing/JComponent;", "component", "getComponent", "()Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "markdownEditorCell", "Lcom/intellij/jupyter/core/editor/markdown/MarkdownEditorCell;", "foldAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lorg/jetbrains/annotations/NotNull;", "unfoldAction", "dispose", "", "updateGutterAction", "unfold", "removeHeadingFolding", "ctx", "Lcom/intellij/notebooks/visualization/UpdateContext;", "removeExistingHiddenCellHint", "removeExistingRegion", "foldingModel", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "foldRegion", "getComponentForTest", "calculateBounds", "Ljava/awt/Rectangle;", "updateInput", "updateFolding", "folded", "browserClicked", "clickCount", "", "requestCaret", "createRenderedComponent", "Lkotlin/Pair;", "Ljavax/swing/JLayer;", "Lcom/intellij/openapi/Disposable;", "dimension", "Ljava/awt/Dimension;", "createMarkdownRenderer", "markdownText", "", "Lcom/intellij/openapi/util/NlsSafe;", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "switchPresentation", "rendered", "forceRecreate", "switchToRenderedPresentation", "switchToTextPresentation", "replaceCurrentComponent", "T", "componentFactory", "Lkotlin/Function1;", "createTextComponent", "Lcom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent;", "createFoldingComponent", "Lcom/intellij/notebooks/visualization/ui/CustomFoldingEditorCellViewComponent;", "removeOldFoldRegionIfExist", "Lcom/intellij/openapi/editor/FoldingModel;", "startLine", "lastLine", "updateView", "section", "Lcom/intellij/jupyter/core/editor/markdown/NotebookStructureElement$NotebookSection;", "sectionFolded", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownEditorCellViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownEditorCellViewComponent.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent\n+ 2 EditorCell.kt\ncom/intellij/notebooks/visualization/ui/EditorCell\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n95#2:384\n95#2:386\n95#2:387\n1#3:385\n*S KotlinDebug\n*F\n+ 1 MarkdownEditorCellViewComponent.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent\n*L\n64#1:384\n67#1:386\n71#1:387\n*E\n"})
public final class MarkdownEditorCellViewComponent
extends EditorCellViewComponent
implements InputComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorCell cell;
    private final boolean foldingEnabled;
    @NotNull
    private final AtomicBoolean isDisposed;
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private InlayPresentation contributedPresentation;
    @Nullable
    private FoldRegion foldedRegion;
    @Nullable
    private JComponent renderedComponent;
    @Nullable
    private final MarkdownEditorCell markdownEditorCell;
    @NotNull
    private final DumbAwareAction foldAction;
    @NotNull
    private final DumbAwareAction unfoldAction;
    @NotNull
    private static final DumbAwareAction EMPTY_ACTION;

    public MarkdownEditorCellViewComponent(@NotNull EditorCell cell, boolean foldingEnabled) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.cell = cell;
        this.foldingEnabled = foldingEnabled;
        this.isDisposed = new AtomicBoolean(false);
        this.editor = this.cell.getEditor();
        EditorCell this_$iv = this.cell;
        boolean $i$f$getExtension = false;
        this.markdownEditorCell = (MarkdownEditorCell)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
        DumbAwareAction dumbAwareAction = DumbAwareAction.SimpleDumbAwareAction.create((Icon)AllIcons.General.ChevronDown, arg_0 -> MarkdownEditorCellViewComponent.foldAction$lambda$1(arg_0 -> MarkdownEditorCellViewComponent.foldAction$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        this.foldAction = dumbAwareAction;
        DumbAwareAction dumbAwareAction2 = DumbAwareAction.SimpleDumbAwareAction.create((Icon)AllIcons.General.ChevronRight, arg_0 -> MarkdownEditorCellViewComponent.unfoldAction$lambda$1(arg_0 -> MarkdownEditorCellViewComponent.unfoldAction$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction2, (String)"create(...)");
        this.unfoldAction = dumbAwareAction2;
        MarkdownEditorCellViewComponent.switchPresentation$default(this, true, false, 2, null);
        MarkdownEditorCell markdownEditorCell = this.markdownEditorCell;
        if (markdownEditorCell != null) {
            MarkdownEditorCell markdownEditorCell2;
            MarkdownEditorCell $this$_init__u24lambda_u240 = markdownEditorCell2 = markdownEditorCell;
            boolean bl = false;
            $this$_init__u24lambda_u240.getSectionFolded().afterChange((Disposable)this, arg_0 -> MarkdownEditorCellViewComponent.lambda$0$0(this, arg_0));
            $this$_init__u24lambda_u240.getRendered().afterChange((Disposable)this, arg_0 -> MarkdownEditorCellViewComponent.lambda$0$1(this, arg_0));
        }
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.cell.isHovered()), (Disposable)((Disposable)this), arg_0 -> MarkdownEditorCellViewComponent._init_$lambda$1(this, arg_0));
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.cell.isSelected()), (Disposable)((Disposable)this), arg_0 -> MarkdownEditorCellViewComponent._init_$lambda$2(this, arg_0));
    }

    private final EditorCellViewComponent getComponent() {
        return (EditorCellViewComponent)CollectionsKt.firstOrNull((List)this.getChildren());
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.renderedComponent = null;
        UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.dispose$lambda$0(this, arg_0), (int)3, null);
    }

    private final void updateGutterAction() {
        boolean sectionFolded;
        MarkdownEditorCell markdownEditorCell = this.markdownEditorCell;
        NotebookStructureElement.NotebookSection section = markdownEditorCell != null ? markdownEditorCell.getSection() : null;
        MarkdownEditorCell markdownEditorCell2 = this.markdownEditorCell;
        boolean bl = markdownEditorCell2 != null && (markdownEditorCell2 = markdownEditorCell2.getSectionFolded()) != null ? ((Boolean)markdownEditorCell2.get()).booleanValue() : (sectionFolded = false);
        if (this.foldingEnabled && section != null) {
            if (sectionFolded) {
                this.cell.getGutterAction().set((Object)this.unfoldAction);
            } else {
                this.cell.getGutterAction().set((Object)this.foldAction);
            }
        } else {
            boolean isSelectedOrHovered;
            boolean bl2 = isSelectedOrHovered = this.cell.isSelected().get() != false || this.cell.isHovered().get() != false;
            if (isSelectedOrHovered) {
                this.cell.getGutterAction().set((Object)EMPTY_ACTION);
            } else {
                this.cell.getGutterAction().set(null);
            }
        }
    }

    public final void unfold() {
        UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.unfold$lambda$0(this, arg_0), (int)3, null);
    }

    public final void removeHeadingFolding(@NotNull UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        FoldRegion foldRegion = this.foldedRegion;
        if (foldRegion != null) {
            ctx.addFoldingOperation(arg_0 -> MarkdownEditorCellViewComponent.removeHeadingFolding$lambda$0(this, foldRegion, arg_0));
        }
        this.foldedRegion = null;
    }

    private final void removeExistingHiddenCellHint() {
        InlayPresentation inlayPresentation = this.contributedPresentation;
        if (inlayPresentation != null) {
            InlayPresentation presentation = inlayPresentation;
            boolean bl = false;
            EditorCellViewComponent editorCellViewComponent = this.getComponent();
            if (editorCellViewComponent != null) {
                editorCellViewComponent.removeInlayBelow(presentation);
            }
        }
        this.contributedPresentation = null;
    }

    private final void removeExistingRegion(FoldingModelEx foldingModel, FoldRegion foldRegion) {
        foldingModel.removeFoldRegion(foldRegion);
        foldRegion.dispose();
    }

    @TestOnly
    @Nullable
    public final JComponent getComponentForTest() {
        EditorCellViewComponent editorCellViewComponent = this.getComponent();
        CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent = editorCellViewComponent instanceof CustomFoldingEditorCellViewComponent ? (CustomFoldingEditorCellViewComponent)editorCellViewComponent : null;
        return customFoldingEditorCellViewComponent != null ? customFoldingEditorCellViewComponent.getComponentForTest() : null;
    }

    @NotNull
    public Rectangle calculateBounds() {
        Object object = this.getComponent();
        if (object == null || (object = object.calculateBounds()) == null) {
            object = new Rectangle(0, 0, 0, 0);
        }
        return object;
    }

    public void updateInput(@NotNull UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MarkdownEditorCell markdownEditorCell = this.markdownEditorCell;
        boolean isRendered = markdownEditorCell != null && (markdownEditorCell = markdownEditorCell.getRendered()) != null ? (Boolean)markdownEditorCell.get() : false;
        this.switchPresentation(isRendered, true);
    }

    public void updateFolding(@NotNull UpdateContext ctx, boolean folded) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MarkdownEditorCellViewComponent.switchPresentation$default(this, !folded, false, 2, null);
        if (folded) {
            EditorCellViewComponent editorCellViewComponent = this.getComponent();
            Intrinsics.checkNotNull((Object)editorCellViewComponent, (String)"null cannot be cast to non-null type com.intellij.notebooks.visualization.ui.TextEditorCellViewComponent");
            TextEditorCellViewComponent textComponent = (TextEditorCellViewComponent)editorCellViewComponent;
            textComponent.updateFolding(ctx, true);
        }
    }

    public final void browserClicked(int clickCount) {
        block1: {
            block0: {
                if (clickCount <= 1 || !JupyterMarkdownHelperKt.getMarkdownRendered(this.cell) || ((Boolean)this.cell.getNotebook().getReadOnly().get()).booleanValue()) break block0;
                JupyterMarkdownHelperKt.setMarkdownRendered(this.cell, false);
                NotebookEditorModeKt.setMode((Editor)((Editor)this.editor), (NotebookEditorMode)NotebookEditorMode.EDIT);
                this.editor.getSettings().setCaretRowShown(true);
                this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                break block1;
            }
            EditorCellView editorCellView = this.cell.getView();
            if (editorCellView == null || (editorCellView = editorCellView.getInput()) == null) break block1;
            editorCellView.requestCaret();
        }
    }

    public void requestCaret() {
        IntRange lines = this.cell.getInterval().getLines();
        int offset = this.editor.getDocument().getLineStartOffset(lines.getFirst() + 1);
        this.editor.getCaretModel().moveToOffset(offset);
    }

    private final Pair<JLayer<JComponent>, Disposable> createRenderedComponent(Dimension dimension) {
        Pair<JComponent, Disposable> pair;
        Pair<JComponent, Disposable> pair2 = (Pair<JComponent, Disposable>)this.cell.getSource().get();
        if (StringsKt.isBlank((CharSequence)pair2)) {
            boolean bl = false;
            pair = JupyterBundle.message("markdown.empty.cell.placeholder", new Object[0]);
        } else {
            pair = pair2;
        }
        String markdownText = (String)pair;
        pair2 = this.createMarkdownRenderer(markdownText, this.editor, this.cell.getIntervalPointer());
        JComponent createdComponent = (JComponent)pair2.component1();
        Disposable rendererDisposable = (Disposable)pair2.component2();
        this.renderedComponent = createdComponent;
        if (dimension != null) {
            createdComponent.setSize(dimension);
        }
        JLayer<Component> component2 = new JLayer<Component>(createdComponent, (LayerUI)new LayerUI<JComponent>(this){
            final /* synthetic */ MarkdownEditorCellViewComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void installUI(JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.installUI(c);
                JLayer l = (JLayer)c;
                l.setLayerEventMask(16L);
            }

            public void uninstallUI(JComponent c) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                super.uninstallUI(c);
                JLayer l = (JLayer)c;
                l.setLayerEventMask(0L);
            }

            protected void processMouseEvent(MouseEvent e, JLayer<? extends JComponent> l) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter(l, (String)"l");
                if (e.getID() == 500) {
                    this.this$0.browserClicked(e.getClickCount());
                }
            }
        });
        component2.setOpaque(false);
        return TuplesKt.to(component2, (Object)rendererDisposable);
    }

    private final Pair<JComponent, Disposable> createMarkdownRenderer(String markdownText, EditorImpl editor, NotebookIntervalPointer intervalPointer) {
        return switch (WhenMappings.$EnumSwitchMapping$0[JupyterSettings.Companion.getInstance().getMarkdownRenderMode().ordinal()]) {
            case 1 -> {
                JBScrollPane var4_4;
                JBScrollPane $this$createMarkdownRenderer_u24lambda_u240 = var4_4 = new JBScrollPane((Component)new JupyterMarkdownHtmlPane(editor, markdownText));
                boolean $i$a$-apply-MarkdownEditorCellViewComponent$createMarkdownRenderer$1 = false;
                $this$createMarkdownRenderer_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder());
                yield TuplesKt.to((Object)var4_4, null);
            }
            case 2 -> {
                ObjectNode node = new ObjectNode(new JsonNodeFactory(false));
                ArrayNode mdField = node.putArray("text/markdown");
                mdField.add(markdownText);
                JupyterCell jupyterCell = JupyterCellLinesExtensionsKt.toJupyterCell(intervalPointer, editor);
                String v1 = node.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                JupyterCell v2 = jupyterCell;
                Intrinsics.checkNotNull((Object)v2);
                String v3 = v2.getId() + "_0";
                NotebookCellLines.Interval v4 = intervalPointer.get();
                Intrinsics.checkNotNull((Object)v4);
                JupyterWebOutputInfo.Output outputInfo = new JupyterWebOutputInfo.Output(v1, v3, v4.getOrdinal(), 0, false, jupyterCell.getId());
                yield JupyterWebOutputApi.Companion.get((Editor)editor).createComponent(outputInfo);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @RequiresEdt
    private final void switchPresentation(boolean rendered, boolean forceRecreate) {
        if (this.isDisposed.get()) {
            return;
        }
        UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this.editor)), (boolean)false, (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.switchPresentation$lambda$0(rendered, this, forceRecreate, arg_0), (int)3, null);
    }

    static /* synthetic */ void switchPresentation$default(MarkdownEditorCellViewComponent markdownEditorCellViewComponent, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        markdownEditorCellViewComponent.switchPresentation(bl, bl2);
    }

    private final void switchToRenderedPresentation(UpdateContext ctx) {
        this.replaceCurrentComponent(ctx, arg_0 -> MarkdownEditorCellViewComponent.switchToRenderedPresentation$lambda$0(this, arg_0));
    }

    private final void switchToTextPresentation(UpdateContext ctx) {
        if (this.getComponent() instanceof TextEditorCellViewComponent) {
            return;
        }
        this.replaceCurrentComponent(ctx, arg_0 -> MarkdownEditorCellViewComponent.switchToTextPresentation$lambda$0(this, arg_0));
    }

    private final <T extends EditorCellViewComponent> void replaceCurrentComponent(UpdateContext ctx, Function1<? super Dimension, ? extends T> componentFactory) {
        JupyterWebOutputPanel newRendered;
        JupyterWebOutputPanel prevRendered;
        EditorCellViewComponent prevFolding = this.getComponent();
        JComponent jComponent = this.renderedComponent;
        JupyterWebOutputPanel jupyterWebOutputPanel = prevRendered = jComponent instanceof JupyterWebOutputPanel ? (JupyterWebOutputPanel)jComponent : null;
        if (prevFolding != null) {
            this.remove(prevFolding);
        }
        JupyterWebOutputPanel jupyterWebOutputPanel2 = prevRendered;
        EditorCellViewComponent newComponent = (EditorCellViewComponent)componentFactory.invoke((Object)(jupyterWebOutputPanel2 != null ? jupyterWebOutputPanel2.getSize() : null));
        JComponent jComponent2 = this.renderedComponent;
        JupyterWebOutputPanel jupyterWebOutputPanel3 = newRendered = jComponent2 instanceof JupyterWebOutputPanel ? (JupyterWebOutputPanel)jComponent2 : null;
        if (newRendered != null && prevRendered != null) {
            newRendered.setNotInitializedSize(prevRendered.getPreferredSize());
        }
        this.add(newComponent);
        newComponent.updateCellFolding(ctx);
    }

    private final TextEditorCellViewComponent createTextComponent() {
        MarkdownEditorCell markdownEditorCell;
        TextEditorCellViewComponent textEditorCellViewComponent;
        TextEditorCellViewComponent it = textEditorCellViewComponent = new TextEditorCellViewComponent(this.cell);
        boolean bl = false;
        MarkdownEditorCell markdownEditorCell2 = this.markdownEditorCell;
        this.updateView((EditorCellViewComponent)it, markdownEditorCell2 != null ? markdownEditorCell2.getSection() : null, (markdownEditorCell = this.markdownEditorCell) != null && (markdownEditorCell = markdownEditorCell.getSectionFolded()) != null ? ((Boolean)markdownEditorCell.get()).booleanValue() : false);
        return textEditorCellViewComponent;
    }

    private final CustomFoldingEditorCellViewComponent createFoldingComponent(Dimension dimension) {
        CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent;
        block0: {
            MarkdownEditorCell markdownEditorCell;
            Pair<JLayer<JComponent>, Disposable> pair = this.createRenderedComponent(dimension);
            JLayer rendererComponent = (JLayer)pair.component1();
            Disposable rendererDisposable = (Disposable)pair.component2();
            CustomFoldingEditorCellViewComponent it = customFoldingEditorCellViewComponent = new CustomFoldingEditorCellViewComponent(this.cell, (JComponent)rendererComponent);
            boolean bl = false;
            MarkdownEditorCell markdownEditorCell2 = this.markdownEditorCell;
            this.updateView((EditorCellViewComponent)it, markdownEditorCell2 != null ? markdownEditorCell2.getSection() : null, (markdownEditorCell = this.markdownEditorCell) != null && (markdownEditorCell = markdownEditorCell.getSectionFolded()) != null ? ((Boolean)markdownEditorCell.get()).booleanValue() : false);
            CustomFoldingEditorCellViewComponent component2 = customFoldingEditorCellViewComponent;
            boolean bl2 = false;
            Disposable disposable = rendererDisposable;
            if (disposable == null) break block0;
            Disposable it2 = disposable;
            boolean bl3 = false;
            Disposer.register((Disposable)((Disposable)component2), (Disposable)it2);
        }
        return customFoldingEditorCellViewComponent;
    }

    private final void removeOldFoldRegionIfExist(FoldingModel foldingModel, int startLine, int lastLine) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int maxLineNumber = Math.max(0, document.getLineCount() - 1);
        int startLine2 = Math.max(0, Math.min(maxLineNumber, startLine));
        int endLine = Math.max(startLine2, Math.min(maxLineNumber, lastLine));
        int startOffset = document.getLineStartOffset(startLine2);
        int endOffset = document.getLineEndOffset(endLine);
        FoldRegion foldRegion = foldingModel.getFoldRegion(startOffset, endOffset);
        if (foldRegion == null) {
            return;
        }
        FoldRegion foldRegion2 = foldRegion;
        foldingModel.removeFoldRegion(foldRegion2);
    }

    private final void updateView(EditorCellViewComponent component2, NotebookStructureElement.NotebookSection section, boolean sectionFolded) {
        ActionsKt.runInEdt$default(null, () -> MarkdownEditorCellViewComponent.updateView$lambda$0(sectionFolded, section, this, component2), (int)1, null);
    }

    private static final Unit foldAction$lambda$0(MarkdownEditorCellViewComponent this$0, AnActionEvent it) {
        block0: {
            EditorCell this_$iv = this$0.cell;
            boolean $i$f$getExtension = false;
            Object object = (MarkdownEditorCell)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
            if (object == null || (object = ((MarkdownEditorCell)object).getSection()) == null) break block0;
            ((NotebookStructureElement.NotebookSection)object).fold();
        }
        return Unit.INSTANCE;
    }

    private static final void foldAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit unfoldAction$lambda$0(MarkdownEditorCellViewComponent this$0, AnActionEvent it) {
        block0: {
            EditorCell this_$iv = this$0.cell;
            boolean $i$f$getExtension = false;
            Object object = (MarkdownEditorCell)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
            if (object == null || (object = ((MarkdownEditorCell)object).getSection()) == null) break block0;
            ((NotebookStructureElement.NotebookSection)object).unfold();
        }
        return Unit.INSTANCE;
    }

    private static final void unfoldAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit lambda$0$0(MarkdownEditorCellViewComponent this$0, boolean sectionFolded) {
        block0: {
            EditorCellViewComponent editorCellViewComponent = this$0.getComponent();
            if (editorCellViewComponent == null) break block0;
            EditorCellViewComponent it = editorCellViewComponent;
            boolean bl = false;
            this$0.updateView(it, this$0.markdownEditorCell.getSection(), sectionFolded);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$1(MarkdownEditorCellViewComponent this$0, boolean rendered) {
        MarkdownEditorCellViewComponent.switchPresentation$default(this$0, rendered, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MarkdownEditorCellViewComponent this$0, boolean it) {
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MarkdownEditorCellViewComponent this$0, boolean it) {
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit dispose$lambda$0(MarkdownEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.removeHeadingFolding(ctx);
        return Unit.INSTANCE;
    }

    private static final Unit unfold$lambda$0(MarkdownEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.removeHeadingFolding(ctx);
        this$0.removeExistingHiddenCellHint();
        return Unit.INSTANCE;
    }

    private static final Unit removeHeadingFolding$lambda$0(MarkdownEditorCellViewComponent this$0, FoldRegion $foldRegion, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        this$0.removeExistingRegion(foldingModel, $foldRegion);
        return Unit.INSTANCE;
    }

    private static final Unit switchPresentation$lambda$0(boolean $rendered, MarkdownEditorCellViewComponent this$0, boolean $forceRecreate, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if ($rendered && !((Boolean)NotebookEditorKt.getNotebookEditor((Editor)((Editor)this$0.editor)).getSingleFileDiffMode().get()).booleanValue()) {
            if (!$forceRecreate && this$0.getComponent() instanceof CustomFoldingEditorCellViewComponent) {
                return Unit.INSTANCE;
            }
            this$0.switchToRenderedPresentation(ctx);
        } else {
            this$0.switchToTextPresentation(ctx);
        }
        return Unit.INSTANCE;
    }

    private static final CustomFoldingEditorCellViewComponent switchToRenderedPresentation$lambda$0(MarkdownEditorCellViewComponent this$0, Dimension it) {
        return this$0.createFoldingComponent(it);
    }

    private static final TextEditorCellViewComponent switchToTextPresentation$lambda$0(MarkdownEditorCellViewComponent this$0, Dimension it) {
        return this$0.createTextComponent();
    }

    private static final Unit updateView$lambda$0$0$0(MarkdownEditorCellViewComponent this$0, int $startLine, int $lastLine, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        this$0.removeOldFoldRegionIfExist((FoldingModel)foldingModel, $startLine, $lastLine);
        CustomFoldRegion region2 = foldingModel.addCustomLinesFolding($startLine, $lastLine, new CustomFoldRegionRenderer(){

            public int calcWidthInPixels(CustomFoldRegion region2) {
                Intrinsics.checkNotNullParameter((Object)region2, (String)"region");
                return 1;
            }

            public int calcHeightInPixels(CustomFoldRegion region2) {
                Intrinsics.checkNotNullParameter((Object)region2, (String)"region");
                return 1;
            }

            public void paint(CustomFoldRegion region2, Graphics2D g, Rectangle2D targetRegion, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter((Object)region2, (String)"region");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            }
        });
        if (region2 != null) {
            region2.putUserData(NotebookCellInlayManager.Companion.getFOLDING_MARKER_KEY(), (Object)true);
            this$0.foldedRegion = (FoldRegion)region2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$0$0$1(MarkdownEditorCellViewComponent this$0, MouseEvent mouseEvent, Point point) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
            Object object = this$0.markdownEditorCell;
            if (object == null || (object = ((MarkdownEditorCell)object).getSection()) == null) break block0;
            ((NotebookStructureElement.NotebookSection)object).unfold();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$0$0(NotebookStructureElement.NotebookSection $section, MarkdownEditorCellViewComponent this$0, EditorCellViewComponent $component, UpdateContext ctx) {
        EditorCell lastCell;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        NotebookStructureElement notebookStructureElement = (NotebookStructureElement)CollectionsKt.firstOrNull($section.getChildren());
        EditorCell firstCell = notebookStructureElement != null ? notebookStructureElement.getFirst() : null;
        NotebookStructureElement notebookStructureElement2 = (NotebookStructureElement)CollectionsKt.lastOrNull($section.getChildren());
        Object object = lastCell = notebookStructureElement2 != null ? notebookStructureElement2.getLast() : null;
        if (firstCell != null && lastCell != null) {
            InlayPresentation presentation;
            int startLine = firstCell.getInterval().getLines().getFirst();
            int lastLine = lastCell.getInterval().getLines().getLast();
            ctx.addFoldingOperation(arg_0 -> MarkdownEditorCellViewComponent.updateView$lambda$0$0$0(this$0, startLine, lastLine, arg_0));
            this$0.removeExistingHiddenCellHint();
            PresentationFactory factory = new PresentationFactory((Editor)this$0.editor);
            Object[] objectArray = new Object[]{$section.getSize()};
            InlayPresentation inlayPresentation = factory.smallText(JupyterBundle.message("jupyter.folding.cells.hidden", objectArray));
            Cursor cursor = Cursor.getPredefinedCursor(12);
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
            this$0.contributedPresentation = presentation = factory.onClick(factory.withCursorOnHover(inlayPresentation, cursor), MouseButton.Left, (arg_0, arg_1) -> MarkdownEditorCellViewComponent.updateView$lambda$0$0$1(this$0, arg_0, arg_1));
            $component.addInlayBelow(presentation);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateView$lambda$0(boolean $sectionFolded, NotebookStructureElement.NotebookSection $section, MarkdownEditorCellViewComponent this$0, EditorCellViewComponent $component) {
        if ($sectionFolded) {
            if ($section != null && $section.isNotEmpty()) {
                UpdateManager.update$default((UpdateManager)UpdateManagerKt.getUpdateManager((Editor)((Editor)this$0.editor)), (boolean)false, (boolean)false, arg_0 -> MarkdownEditorCellViewComponent.updateView$lambda$0$0($section, this$0, $component, arg_0), (int)3, null);
            }
        } else {
            this$0.unfold();
        }
        this$0.updateGutterAction();
        return Unit.INSTANCE;
    }

    private static final Unit EMPTY_ACTION$lambda$0(AnActionEvent it) {
        return Unit.INSTANCE;
    }

    private static final void EMPTY_ACTION$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        DumbAwareAction dumbAwareAction = DumbAwareAction.SimpleDumbAwareAction.create((Icon)AllIcons.Empty, arg_0 -> MarkdownEditorCellViewComponent.EMPTY_ACTION$lambda$1(MarkdownEditorCellViewComponent::EMPTY_ACTION$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        EMPTY_ACTION = dumbAwareAction;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/MarkdownEditorCellViewComponent$Companion;", "", "<init>", "()V", "EMPTY_ACTION", "Lcom/intellij/openapi/project/DumbAwareAction;", "getEMPTY_ACTION", "()Lcom/intellij/openapi/project/DumbAwareAction;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DumbAwareAction getEMPTY_ACTION() {
            return EMPTY_ACTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterDSettingsMarkdownRenderMode.values().length];
            try {
                nArray[JupyterDSettingsMarkdownRenderMode.SWING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterDSettingsMarkdownRenderMode.NOTEBOOK_CEF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

