/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.state;

import com.intellij.jupyter.core.console.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorState;
import com.intellij.notebooks.visualization.ui.NotebookPositionKeeper;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/state/JupyterEditorStateManager;", "", "<init>", "()V", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "writeState", "", "state", "targetElement", "getTextEditorProvider", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterEditorStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterEditorStateManager.kt\ncom/intellij/jupyter/core/jupyter/editor/state/JupyterEditorStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1586#2:112\n1661#2,3:113\n1586#2:116\n1661#2,2:117\n1586#2:119\n1661#2,3:120\n1663#2:123\n1915#2,2:124\n1915#2:126\n1915#2,2:127\n1916#2:129\n*S KotlinDebug\n*F\n+ 1 JupyterEditorStateManager.kt\ncom/intellij/jupyter/core/jupyter/editor/state/JupyterEditorStateManager\n*L\n21#1:112\n21#1:113,3\n24#1:116\n24#1:117,2\n29#1:119\n29#1:120,3\n24#1:123\n69#1:124,2\n77#1:126\n84#1:127,2\n77#1:129\n*E\n"})
public final class JupyterEditorStateManager {
    @NotNull
    public static final JupyterEditorStateManager INSTANCE = new JupyterEditorStateManager();

    private JupyterEditorStateManager() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        NotebookPositionKeeper.Position position;
        Element element;
        List cellStates;
        Element element2;
        List collapsedSections;
        Iterable<Integer> iterable;
        Iterable<Integer> destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (JupyterConsoleUtil.INSTANCE.isJupyterConsoleFile(file)) {
            return (FileEditorState)new TextEditorState();
        }
        FileEditorState textEditorState = this.getTextEditorProvider().readState(sourceElement, project, file);
        Element element3 = sourceElement.getChild("jupyter");
        if (element3 != null && (element3 = element3.getChild("collapsedSections")) != null) {
            void $this$mapTo$iv$iv;
            Element element4 = element3;
            boolean bl = false;
            List list = element4.getChildren("section");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element5 = (Element)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getAttribute("cellOrdinal").getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                iterable.add(Integer.parseInt(string));
            }
            v3 = (List)destination$iv$iv;
        } else {
            v3 = collapsedSections = CollectionsKt.emptyList();
        }
        if ((element2 = sourceElement.getChild("jupyter")) != null && (element2 = element2.getChild("cells")) != null) {
            void $this$mapTo$iv$iv;
            Element element6 = element2;
            boolean bl = false;
            List list = element6.getChildren("cell");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JupyterEditorState.OutputsState outputsState;
                void cellElement;
                iterable = (Element)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                if (cellElement.getChild("outputs") != null) {
                    Collection<JupyterEditorState.OutputState> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Element outputsElement;
                    boolean bl4 = false;
                    Object object = outputsElement.getAttribute("scrollingEnabled");
                    boolean bl5 = !(object != null && (object = object.getValue()) != null ? !Boolean.parseBoolean((String)object) : false);
                    List list2 = outputsElement.getChildren("output");
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
                    Iterable iterable3 = list2;
                    boolean bl6 = bl5;
                    boolean $i$f$map2 = false;
                    void var26_35 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        Object object2;
                        Object object3;
                        void it;
                        Element element7 = (Element)item$iv$iv2;
                        collection2 = destination$iv$iv3;
                        boolean bl7 = false;
                        Dimension size = it.getAttribute("width") != null && it.getAttribute("height") != null ? new Dimension(it.getAttribute("width").getIntValue(), it.getAttribute("height").getIntValue()) : null;
                        Object object4 = it.getAttribute("resized");
                        collection2.add(new JupyterEditorState.OutputState(size, object4 != null && (object4 = object4.getValue()) != null ? Boolean.parseBoolean((String)object4) : false, (object3 = it.getAttribute("collapsed")) != null && (object3 = object3.getValue()) != null ? Boolean.parseBoolean((String)object3) : false, (object2 = it.getAttribute("maximized")) != null && (object2 = object2.getValue()) != null ? Boolean.parseBoolean((String)object2) : false));
                    }
                    collection2 = (List)destination$iv$iv3;
                    List list3 = collection2;
                    boolean bl8 = bl6;
                    outputsState = new JupyterEditorState.OutputsState(bl8, list3);
                } else {
                    outputsState = null;
                }
                JupyterEditorState.OutputsState outputsState2 = outputsState;
                collection.add(new JupyterEditorState.CellState(outputsState2));
            }
            v13 = (List)destination$iv$iv2;
        } else {
            v13 = cellStates = CollectionsKt.emptyList();
        }
        if ((element = sourceElement.getChild("jupyter")) != null && (element = element.getChild("position")) != null) {
            Integer viewportShift;
            Element element8 = element;
            boolean bl = false;
            Attribute attribute = element8.getAttribute("topLeftCornerOffset");
            Integer topLeftCornerOffset = attribute != null ? Integer.valueOf(attribute.getIntValue()) : null;
            Attribute attribute2 = element8.getAttribute("viewportShift");
            Integer n = viewportShift = attribute2 != null ? Integer.valueOf(attribute2.getIntValue()) : null;
            position = topLeftCornerOffset != null && viewportShift != null ? new NotebookPositionKeeper.Position(topLeftCornerOffset.intValue(), viewportShift.intValue()) : null;
        } else {
            position = null;
        }
        NotebookPositionKeeper.Position position2 = position;
        return new JupyterEditorState(textEditorState, collapsedSections, cellStates, position2);
    }

    public final void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        if (!(state instanceof JupyterEditorState)) {
            return;
        }
        TextEditorProvider textEditorProvider = this.getTextEditorProvider();
        textEditorProvider.writeState(((JupyterEditorState)state).getTextEditorState(), project, targetElement);
        Element jupyterElement = new Element("jupyter");
        if (!((Collection)((JupyterEditorState)state).getCollapsedSections()).isEmpty()) {
            Element e = new Element("collapsedSections");
            $this$forEach$iv = ((JupyterEditorState)state).getCollapsedSections();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                Element sectionElement = new Element("section");
                sectionElement.setAttribute("cellOrdinal", String.valueOf(it));
                e.addContent(sectionElement);
            }
            jupyterElement.addContent(e);
        }
        Element cellsElement = new Element("cells");
        $this$forEach$iv = ((JupyterEditorState)state).getCellStates();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterEditorState.CellState cell = (JupyterEditorState.CellState)element$iv;
            boolean bl = false;
            Element cellElement = new Element("cell");
            Element outputsElement = new Element("outputs");
            JupyterEditorState.OutputsState outputsState = cell.getOutputs();
            boolean scrollingEnabled = !(outputsState != null ? !outputsState.getScrollingEnabled() : false);
            outputsElement.setAttribute("scrollingEnabled", String.valueOf(scrollingEnabled));
            cellElement.addContent(outputsElement);
            cellsElement.addContent(cellElement);
            Object object = cell.getOutputs();
            if (object == null || (object = ((JupyterEditorState.OutputsState)object).getItems()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Dimension size;
                JupyterEditorState.OutputState it = (JupyterEditorState.OutputState)element$iv2;
                boolean bl2 = false;
                if (it.getSize() == null) continue;
                boolean bl3 = false;
                Element outputElement = new Element("output");
                outputElement.setAttribute("width", String.valueOf(size.width));
                outputElement.setAttribute("height", String.valueOf(size.height));
                outputElement.setAttribute("resized", String.valueOf(it.getResized()));
                outputElement.setAttribute("collapsed", String.valueOf(it.getCollapsed()));
                outputElement.setAttribute("maximized", String.valueOf(it.getMaximized()));
                outputsElement.addContent(outputElement);
            }
        }
        jupyterElement.addContent(cellsElement);
        if (((JupyterEditorState)state).getPosition() != null) {
            Element position = new Element("position");
            position.setAttribute("topLeftCornerOffset", String.valueOf(((JupyterEditorState)state).getPosition().getTopLeftCornerOffset()));
            position.setAttribute("viewportShift", String.valueOf(((JupyterEditorState)state).getPosition().getViewportShift()));
            jupyterElement.addContent(position);
        }
        targetElement.addContent(jupyterElement);
    }

    private final TextEditorProvider getTextEditorProvider() {
        return TextEditorProvider.Companion.getInstance();
    }
}

