/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.messages;

import com.intellij.jupyter.core.jupyter.messages.MessageSink;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageBuffer;", "T", "Lcom/intellij/jupyter/core/jupyter/messages/MessageSink;", "getSink", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "messageQueue", "Lkotlin/collections/ArrayDeque;", "sendMessageToSink", "", "message", "(Ljava/lang/Object;)V", "purgeIfPossible", "purge", "sink", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterMessageBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterMessageBuffer.kt\ncom/intellij/jupyter/core/jupyter/messages/JupyterMessageBuffer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n13#2:48\n1#3:49\n*S KotlinDebug\n*F\n+ 1 JupyterMessageBuffer.kt\ncom/intellij/jupyter/core/jupyter/messages/JupyterMessageBuffer\n*L\n20#1:48\n*E\n"})
public final class JupyterMessageBuffer<T>
implements MessageSink<T> {
    @NotNull
    private final Function0<MessageSink<T>> getSink;
    @NotNull
    private final ArrayDeque<T> messageQueue;

    public JupyterMessageBuffer(@NotNull Function0<? extends MessageSink<T>> getSink) {
        Intrinsics.checkNotNullParameter(getSink, (String)"getSink");
        this.getSink = getSink;
        this.messageQueue = new ArrayDeque();
    }

    @Override
    public synchronized void sendMessageToSink(T message) {
        MessageSink sink = (MessageSink)this.getSink.invoke();
        if (sink == null) {
            if (this.messageQueue.size() > 100) {
                this.messageQueue.removeFirst();
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JupyterMessageBuffer.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.trace("Too many messages in queue, deleting first");
            }
            this.messageQueue.add(message);
            return;
        }
        this.purge(sink);
        sink.sendMessageToSink(message);
    }

    public final synchronized void purgeIfPossible() {
        block0: {
            MessageSink messageSink = (MessageSink)this.getSink.invoke();
            if (messageSink == null) break block0;
            MessageSink it = messageSink;
            boolean bl = false;
            this.purge(it);
        }
    }

    public final synchronized void purge(@NotNull MessageSink<T> sink) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        if (!((Collection)this.messageQueue).isEmpty()) {
            for (Object oldMessage : this.messageQueue) {
                sink.sendMessageToSink(oldMessage);
            }
            this.messageQueue.clear();
        }
    }
}

