/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.schema.v4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.core.jupyter.nbformat.outputs.JacksonUtil;
import com.intellij.jupyter.core.jupyter.nbformat.schema.DisplayDataContainerBase;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/schema/v4/V4DisplayDataContainer;", "Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/DisplayDataContainerBase;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "<init>", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "getJson", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getAsMultiline", "", "", "mimeType", "getAsJsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "setAsJsonNode", "", "value", "has", "", "size", "", "getSize", "()I", "items", "", "getItems", "()Ljava/lang/Iterable;", "textPlain", "getTextPlain", "()Ljava/lang/String;", "toV4Json", "intellij.jupyter.core"})
public final class V4DisplayDataContainer
extends DisplayDataContainerBase
implements DisplayDataContainer {
    @NotNull
    private final ObjectNode json;

    public V4DisplayDataContainer(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
    }

    @Override
    @NotNull
    public ObjectNode getJson() {
        return this.json;
    }

    @Override
    @Nullable
    public List<String> getAsMultiline(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return this.getMultiline(this.getJson(), mimeType);
    }

    @Override
    @Nullable
    public JsonNode getAsJsonNode(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return this.getJson().get(mimeType);
    }

    @Override
    public void setAsJsonNode(@NotNull String mimeType, @Nullable JsonNode value) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        JsonNode jsonNode = value != null ? this.getJson().set(mimeType, value) : this.getJson().remove(mimeType);
    }

    @Override
    public boolean has(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return this.getJson().has(mimeType);
    }

    @Override
    public int getSize() {
        return this.getJson().size();
    }

    @Override
    @NotNull
    public Iterable<String> getItems() {
        Iterator iterator = this.getJson().fieldNames();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
        return SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
    }

    @Override
    @Nullable
    public String getTextPlain() {
        return JacksonUtil.INSTANCE.getMime(this.getJson(), MimeType.TEXT_PLAIN);
    }

    @Override
    @NotNull
    public ObjectNode toV4Json() {
        return this.getJson();
    }
}

