/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.model;

import com.intellij.database.dialects.db2.model.Db2Check;
import com.intellij.database.dialects.db2.model.Db2ForeignKey;
import com.intellij.database.dialects.db2.model.Db2Index;
import com.intellij.database.dialects.db2.model.Db2LikeDefType;
import com.intellij.database.dialects.db2.model.Db2LikeRoutine;
import com.intellij.database.dialects.db2.model.Db2Module;
import com.intellij.database.dialects.db2.model.Db2Schema;
import com.intellij.database.dialects.db2.model.Db2Sequence;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.GeneratedModelUtil;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2GeneratedModelUtil
extends GeneratedModelUtil {
    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull Db2Sequence element) {
        if (element == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)Db2GeneratedModelUtil.resolveType(element));
        if (list == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean getAutoCreated(@NotNull Db2Index element) {
        if (element == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(2);
        }
        return element.isNameSurrogate();
    }

    public static boolean getAutoCreated(@NotNull Db2Check element) {
        if (element == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(3);
        }
        return element.isNameSurrogate();
    }

    @Nullable
    private static Db2LikeDefType resolveType(@NotNull Db2Sequence sequence) {
        if (sequence == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(4);
        }
        DasType dasType = sequence.getDasType();
        String schemaName = DasTypeUtilsKt.getSchemaName((DasType)dasType);
        String moduleName = DasTypeUtilsKt.getPackageName((DasType)dasType);
        String typeName = DasTypeUtilsKt.getTypeName((DasType)dasType);
        if (schemaName == null || schemaName.isEmpty() || schemaName.equalsIgnoreCase("SYSIBM")) {
            return null;
        }
        Db2Schema mySchema = sequence.getSchema();
        if (mySchema == null) {
            return null;
        }
        BasicSchema targetSchema = mySchema.getSibling(schemaName);
        if (!(targetSchema instanceof Db2Schema)) {
            return null;
        }
        Db2Module module = moduleName != null ? (Db2Module)((Db2Schema)targetSchema).getModules().get(moduleName) : null;
        Object types = module != null ? module.getDefTypes() : ((Db2Schema)targetSchema).getDefTypes();
        return (Db2LikeDefType)types.get(typeName);
    }

    public static List<String> getRefColNames(Db2ForeignKey fk) {
        return Db2GeneratedModelUtil.getRefColNamesByKey((BasicForeignKey)fk);
    }

    public static void setRefColNames(Db2ForeignKey fk, List<String> names) {
        Db2GeneratedModelUtil.setRefColNamesByKey((BasicModForeignKey)fk, names);
    }

    public static SequenceIdentity getSequenceIdentity(@NotNull Db2TableColumn column) {
        Db2Sequence seq;
        if (column == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(5);
        }
        if ((seq = column.getSequence()) != null) {
            return seq.getSequenceIdentity();
        }
        if (column.getSequenceRef() == null) {
            return null;
        }
        return SequenceIdentity.UNKNOWN;
    }

    public static void setSequenceIdentity(Db2TableColumn column, SequenceIdentity identity) {
        if (identity == null) {
            column.setSequenceRef(null);
        } else {
            if (column.getSequenceRef() != null) {
                return;
            }
            column.setSequenceRef((BasicReference)BasicNameReference.create((String)"unknown"));
        }
    }

    public static boolean isComputed(Db2TableColumn column) {
        ColumnKind kind = column.getColumnKind();
        return kind == ColumnKind.GENERATED_STORED || kind == ColumnKind.GENERATED_VIRTUAL;
    }

    public static void setComputed(Db2TableColumn column, boolean computed) {
        if (Db2GeneratedModelUtil.isComputed(column) == computed) {
            return;
        }
        column.setColumnKind(computed ? ColumnKind.GENERATED_VIRTUAL : ColumnKind.NORMAL);
    }

    public static int getDisplayOrder(@NotNull BasicOverloadable e1, @NotNull BasicOverloadable e2) {
        if (e1 == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(6);
        }
        if (e2 == null) {
            Db2GeneratedModelUtil.$$$reportNull$$$0(7);
        }
        if (e1 == e2) {
            return 0;
        }
        int order = GeneratedModelUtil.getDisplayOrder((BasicOverloadable)e1, (BasicOverloadable)e2);
        if (order != 0) {
            return order;
        }
        if (e1 instanceof Db2LikeRoutine) {
            Db2LikeRoutine r1 = (Db2LikeRoutine)e1;
            if (e2 instanceof Db2LikeRoutine) {
                Db2LikeRoutine r2 = (Db2LikeRoutine)e2;
                String name1 = r1.getSpecificName();
                String name2 = r2.getSpecificName();
                if (name1 != null && name2 != null) {
                    return Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
                }
            }
        }
        return order;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/model/Db2GeneratedModelUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/model/Db2GeneratedModelUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSequenceIdentity";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

