/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.testFramework;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.testFramework.core.FileComparisonFailedError;
import com.intellij.testFramework.TestLoggerFactory;
import com.jetbrains.rdclient.testFramework.TestScriptsKt;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a\u001e\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\f*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\n\u0010\u0012\u001a\u00020\f*\u00020\f\u001a\u0016\u0010\u0013\u001a\u00020\f*\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\bH\u0002\u001a\u0012\u0010\u0014\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00160\u001a\u001a\u0016\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f\u001a\f\u0010\u001f\u001a\u00020\u000e*\u00020\u000eH\u0002\u001a\n\u0010 \u001a\u00020\u000e*\u00020\u000e\u001a&\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000e\u001a\u0006\u0010'\u001a\u00020\u000e\u001a\u0018\u0010(\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u000eH\u0002\" \u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0006\u001a\u0004\b\u0007\u0010\t\"\u001b\u0010$\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0006\u001a\u0004\b%\u0010\t\u00a8\u0006*"}, d2={"frameworkLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getFrameworkLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "frameworkLogger$delegate", "Lkotlin/Lazy;", "isUnderTeamCity", "", "()Z", "isUnderTeamCity$delegate", "createFileWithExtension", "Ljava/io/File;", "extension", "", "newExtension", "getFileWithNameSuffix", "fileNameSuffix", "getGoldFile", "createTmpFile", "getFileWithExtension", "executeWithGold", "", "testFile", "goldFileSuffix", "action", "Lkotlin/Function1;", "Ljava/io/PrintStream;", "maskAndCompare", "goldFile", "tmpFile", "normalizeSeparators", "normalizeLineEndings", "compareText", "goldText", "tmpText", "createGold", "getCreateGold", "createGold$delegate", "getGoldFileSystemDependentSuffix", "createGoldFile", "content", "intellij.rd.client.testFramework"})
public final class TestFrameworkKt {
    @NotNull
    private static final Lazy frameworkLogger$delegate = LazyKt.lazy(TestFrameworkKt::frameworkLogger_delegate$lambda$0);
    @NotNull
    private static final Lazy isUnderTeamCity$delegate = LazyKt.lazy(TestFrameworkKt::isUnderTeamCity_delegate$lambda$0);
    @NotNull
    private static final Lazy createGold$delegate = LazyKt.lazy(TestFrameworkKt::createGold_delegate$lambda$0);

    @NotNull
    public static final Logger getFrameworkLogger() {
        Lazy lazy = frameworkLogger$delegate;
        return (Logger)lazy.getValue();
    }

    public static final boolean isUnderTeamCity() {
        Lazy lazy = isUnderTeamCity$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final File createFileWithExtension(File $this$createFileWithExtension, String extension, boolean newExtension) {
        File tmpFile = newExtension ? new File($this$createFileWithExtension.getParent(), FilesKt.getNameWithoutExtension((File)$this$createFileWithExtension) + extension) : new File($this$createFileWithExtension.getParent(), $this$createFileWithExtension.getName() + extension);
        tmpFile.delete();
        tmpFile.getParentFile().mkdirs();
        tmpFile.createNewFile();
        return tmpFile;
    }

    static /* synthetic */ File createFileWithExtension$default(File file, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return TestFrameworkKt.createFileWithExtension(file, string, bl);
    }

    private static final File getFileWithNameSuffix(File $this$getFileWithNameSuffix, String fileNameSuffix) {
        if (((CharSequence)fileNameSuffix).length() == 0) {
            return $this$getFileWithNameSuffix;
        }
        return new File($this$getFileWithNameSuffix.getParent(), FilesKt.getNameWithoutExtension((File)$this$getFileWithNameSuffix) + fileNameSuffix + (String)(((CharSequence)FilesKt.getExtension((File)$this$getFileWithNameSuffix)).length() == 0 ? "" : "." + FilesKt.getExtension((File)$this$getFileWithNameSuffix)));
    }

    @NotNull
    public static final File getGoldFile(@NotNull File $this$getGoldFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getGoldFile, (String)"<this>");
        return TestFrameworkKt.getFileWithExtension($this$getGoldFile, ".gold");
    }

    private static final File createTmpFile(File $this$createTmpFile, boolean newExtension) {
        return TestFrameworkKt.createFileWithExtension($this$createTmpFile, ".tmp", newExtension);
    }

    static /* synthetic */ File createTmpFile$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return TestFrameworkKt.createTmpFile(file, bl);
    }

    @NotNull
    public static final File getFileWithExtension(@NotNull File $this$getFileWithExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileWithExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return new File($this$getFileWithExtension.getParent(), FilesKt.getNameWithoutExtension((File)$this$getFileWithExtension) + extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void executeWithGold(@NotNull File testFile, @NotNull String goldFileSuffix, @NotNull Function1<? super PrintStream, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Intrinsics.checkNotNullParameter((Object)goldFileSuffix, (String)"goldFileSuffix");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean osDependent = false;
        File goldFileWithSuffix = null;
        goldFileWithSuffix = TestFrameworkKt.getFileWithNameSuffix(testFile, TestFrameworkKt.getGoldFileSystemDependentSuffix());
        if (TestFrameworkKt.getGoldFile(goldFileWithSuffix).exists()) {
            osDependent = true;
        }
        if (!osDependent) {
            goldFileWithSuffix = TestFrameworkKt.getFileWithNameSuffix(testFile, goldFileSuffix);
        }
        File tmpFile = TestFrameworkKt.createTmpFile$default(goldFileWithSuffix, false, 1, null);
        Closeable closeable = new PrintStream(tmpFile.getPath(), "UTF-8");
        Throwable throwable = null;
        try {
            PrintStream printStream = (PrintStream)closeable;
            boolean bl = false;
            File goldFile = TestFrameworkKt.getGoldFile(goldFileWithSuffix);
            try {
                action.invoke((Object)printStream);
                printStream.flush();
            }
            catch (Throwable e) {
                TestFrameworkKt.getFrameworkLogger().warn("Exception is occurred while executing test (will be rethrown): " + e.getLocalizedMessage() + ". \r\nTmp path: file:///" + FilesKt.getInvariantSeparatorsPath((File)tmpFile) + "\r\nGold path: file:///" + FilesKt.getInvariantSeparatorsPath((File)goldFile) + "\r\nTest data was written partially\r\n: " + FilesKt.readText$default((File)tmpFile, null, (int)1, null));
                throw e;
            }
            if (TestFrameworkKt.getCreateGold() && !TestFrameworkKt.isUnderTeamCity()) {
                String tmpText = FilesKt.readText$default((File)tmpFile, null, (int)1, null);
                TestFrameworkKt.createGoldFile(goldFile, tmpText);
            } else {
                if (TestFrameworkKt.getCreateGold() && TestFrameworkKt.isUnderTeamCity()) {
                    TestFrameworkKt.getFrameworkLogger().info("Temp file: " + tmpFile.getAbsolutePath());
                    return;
                }
                boolean bl2 = goldFile.exists();
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl3 = false;
                    TestScriptsKt.writeCopyToGoldScript(goldFile, tmpFile);
                    String string = "Gold file: " + goldFile.getAbsolutePath() + " is not found\nTemp file: " + tmpFile.getAbsolutePath();
                    throw new AssertionError((Object)string);
                }
                TestFrameworkKt.maskAndCompare(goldFile, tmpFile);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        tmpFile.delete();
    }

    public static /* synthetic */ void executeWithGold$default(File file, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        TestFrameworkKt.executeWithGold(file, string, (Function1<? super PrintStream, Unit>)function1);
    }

    public static final void maskAndCompare(@NotNull File goldFile, @NotNull File tmpFile) {
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
        String goldText = TestFrameworkKt.normalizeSeparators(TestFrameworkKt.normalizeLineEndings(FilesKt.readText$default((File)goldFile, null, (int)1, null)));
        String tmpText = TestFrameworkKt.normalizeSeparators(TestFrameworkKt.normalizeLineEndings(FilesKt.readText$default((File)tmpFile, null, (int)1, null)));
        TestFrameworkKt.compareText(goldFile, goldText, tmpFile, tmpText);
    }

    private static final String normalizeSeparators(String $this$normalizeSeparators) {
        return StringsKt.replace$default((String)$this$normalizeSeparators, (String)"\\", (String)"/", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String normalizeLineEndings(@NotNull String $this$normalizeLineEndings) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeLineEndings, (String)"<this>");
        return StringsKt.replace$default((String)$this$normalizeLineEndings, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
    }

    public static final void compareText(@NotNull File goldFile, @NotNull String goldText, @NotNull File tmpFile, @NotNull String tmpText) {
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)goldText, (String)"goldText");
        Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
        Intrinsics.checkNotNullParameter((Object)tmpText, (String)"tmpText");
        TestFrameworkKt.getFrameworkLogger().info("start comparing... \"" + goldFile.getAbsolutePath() + "\" \"" + tmpFile.getAbsolutePath() + "\"");
        try {
            if (!Intrinsics.areEqual((Object)goldText, (Object)tmpText)) {
                throw new FileComparisonFailedError("Text mismatch: ", goldText, tmpText, goldFile.getPath(), tmpFile.getPath());
            }
        }
        catch (AssertionError ex) {
            TestScriptsKt.writeUpdateGoldScript(goldFile, tmpFile);
            throw ex;
        }
        TestFrameworkKt.getFrameworkLogger().info("files are identical");
    }

    public static final boolean getCreateGold() {
        Lazy lazy = createGold$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public static final String getGoldFileSystemDependentSuffix() {
        return SystemInfo.isWindows ? "_win" : (SystemInfo.isLinux ? "_linux" : (SystemInfo.isMac ? "_mac" : ""));
    }

    private static final void createGoldFile(File goldFile, String content) {
        if (!goldFile.exists()) {
            boolean bl = goldFile.createNewFile();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        FilesKt.writeText$default((File)goldFile, (String)content, null, (int)2, null);
    }

    private static final Logger frameworkLogger_delegate$lambda$0() {
        if (!Logger.isInitialized()) {
            Logger.setFactory(TestLoggerFactory.class);
        }
        return Logger.getInstance((String)"com.jetbrains.rdclient.test.framework");
    }

    private static final boolean isUnderTeamCity_delegate$lambda$0() {
        return System.getenv("TEAMCITY_VERSION") != null;
    }

    private static final boolean createGold_delegate$lambda$0() {
        String string = System.getenv("CREATE_GOLD");
        if (string == null) {
            return false;
        }
        String isGeneratingGold = string;
        return Boolean.parseBoolean(isGeneratingGold);
    }
}

