/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.testFramework.scriptingApi;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProjectViewTestUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.util.TimeoutTracker;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import java.time.Duration;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007\u001a(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"enableProjectView", "", "project", "Lcom/intellij/openapi/project/Project;", "dumpProjectViewPane", "", "withSelection", "", "additionalWait", "paneId", "intellij.rd.client.testFramework"})
public final class ProjectView_ScriptingApiKt {
    public static final void enableProjectView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ApplicationKt.getApplication().isHeadlessEnvironment()) {
            ProjectViewTestUtil.setupImpl((Project)project, (boolean)true);
            return;
        }
        Ref.BooleanRef initialized = new Ref.BooleanRef();
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Project");
        if (toolWindow != null) {
            toolWindow.show(() -> ProjectView_ScriptingApiKt.enableProjectView$lambda$0(project, initialized));
        }
        Duration duration = Duration.ofSeconds(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        TimeoutTracker tracker = new TimeoutTracker(duration);
        while (!initialized.element) {
            tracker.throwIfExpired(() -> ProjectView_ScriptingApiKt.enableProjectView$lambda$1(tracker));
            IdeEventQueue.Companion.getInstance().flushQueue();
        }
    }

    @NotNull
    public static final String dumpProjectViewPane(@NotNull Project project, boolean withSelection, boolean additionalWait) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CharSequence charSequence = ProjectView_ScriptingApiKt.dumpProjectViewPane(project, withSelection, "ProjectPane", additionalWait);
        Regex regex = new Regex("(?s)[+\\-]?[^\\-+]*data[^\\-+]*");
        String string = "";
        return regex.replace(charSequence, string);
    }

    public static /* synthetic */ String dumpProjectViewPane$default(Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return ProjectView_ScriptingApiKt.dumpProjectViewPane(project, bl, bl2);
    }

    @NotNull
    public static final String dumpProjectViewPane(@NotNull Project project, boolean withSelection, @NotNull String paneId, boolean additionalWait) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
        IdeEventQueue.Companion.getInstance().flushQueue();
        ProjectView projectView = ProjectView.getInstance((Project)project);
        projectView.changeView(paneId);
        AbstractProjectViewPane pane = projectView.getProjectViewPaneById(paneId);
        JTree tree = pane.getTree();
        PlatformTestUtil.waitWhileBusy((JTree)tree);
        PlatformTestUtil.expandAll((JTree)tree);
        PlatformTestUtil.waitWhileBusy((JTree)tree);
        if (additionalWait) {
            Duration duration = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            ExtensionsKt.pumpMessages((Duration)duration);
        }
        String string = PlatformTestUtil.print((JTree)tree, (boolean)withSelection);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"print(...)");
        return string;
    }

    public static /* synthetic */ String dumpProjectViewPane$default(Project project, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return ProjectView_ScriptingApiKt.dumpProjectViewPane(project, bl, string, bl2);
    }

    private static final void enableProjectView$lambda$0(Project $project, Ref.BooleanRef $initialized) {
        ProjectView.getInstance((Project)$project).changeViewCB("ProjectPane", null).doWhenProcessed(() -> ProjectView_ScriptingApiKt.enableProjectView$lambda$0$0($initialized));
    }

    private static final void enableProjectView$lambda$0$0(Ref.BooleanRef $initialized) {
        $initialized.element = true;
    }

    private static final String enableProjectView$lambda$1(TimeoutTracker $tracker) {
        return "Can not show ProjectViewPane in " + $tracker.getTimeout().getSeconds() + " sec";
    }
}

