/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.testFramework;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rdclient.testFramework.TestFrameworkKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a \u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"writeUpdateGoldScript", "", "goldFile", "Ljava/io/File;", "tmpFile", "writeCopyToGoldScript", "writeScript", "action", "", "intellij.rd.client.testFramework"})
public final class TestScriptsKt {
    public static final void writeUpdateGoldScript(@NotNull File goldFile, @NotNull File tmpFile) {
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
        TestScriptsKt.writeScript(goldFile, tmpFile, "Update gold");
    }

    public static final void writeCopyToGoldScript(@NotNull File goldFile, @NotNull File tmpFile) {
        Intrinsics.checkNotNullParameter((Object)goldFile, (String)"goldFile");
        Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
        TestScriptsKt.writeScript(goldFile, tmpFile, "Copy to gold");
    }

    private static final void writeScript(File goldFile, File tmpFile, String action) {
        try {
            if (SystemInfo.isWindows && !TestFrameworkKt.isUnderTeamCity()) {
                File dir = new File(FileUtil.getTempDirectory(), "JetTestScripts");
                dir.mkdir();
                String baseName = "copyToGold_" + FilesKt.getNameWithoutExtension((File)tmpFile);
                File file = new File(dir, baseName + ".bat");
                int index = 1;
                while (file.exists()) {
                    file = new File(dir, baseName + index + ".bat");
                    ++index;
                }
                file.createNewFile();
                FilesKt.writeText$default((File)file, (String)("move /y \"" + tmpFile.getAbsolutePath() + "\" \"" + goldFile.getAbsolutePath() + "\""), null, (int)2, null);
                TestFrameworkKt.getFrameworkLogger().info(action + ": " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

