/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.requests.PatchEngineRetryTimestampWithGeneration;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rdclient.requests.BackendOriginatedChange;
import com.jetbrains.rdclient.requests.BackendResponse;
import com.jetbrains.rdclient.requests.ChangeFromBackend;
import com.jetbrains.rdclient.requests.SpeculativeRequest;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u00013B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010J\u0013\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0014J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eJ\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\u001eJ\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\bJ\u001d\u0010\"\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bJ1\u0010,\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010-2\u0006\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u001a\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010.J%\u0010/\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u00100\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor;", "TContext", "TReq", "Lcom/jetbrains/rdclient/requests/SpeculativeRequest;", "", "<init>", "()V", "lastSubmittedRequestId", "", "globalRetryTimestamp", "Lcom/jetbrains/rd/ide/requests/PatchEngineRetryTimestampWithGeneration;", "backendChangesCounter", "pendingRequestsQueue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "pendingResponses", "Ljava/util/ArrayDeque;", "Lcom/jetbrains/rdclient/requests/ChangeFromBackend;", "processing", "", "submitRequest", "", "request", "(Lcom/jetbrains/rdclient/requests/SpeculativeRequest;)V", "onBackendResponse", "response", "process", "context", "(Ljava/lang/Object;)V", "cancelAndRemoveAllPending", "getPendingRequests", "", "getPendingResponses", "isEmpty", "appliedResponsesCount", "rebase", "oldTimestamp", "(Ljava/lang/Object;Lcom/jetbrains/rd/ide/requests/PatchEngineRetryTimestampWithGeneration;)V", "tryProcessWithoutPhysicalRebase", "Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor$FastPathResult;", "(Ljava/lang/Object;)Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor$FastPathResult;", "rollbackAllPendingRequests", "virtually", "(ZLjava/lang/Object;)V", "applyAllPendingResponses", "completeRequest", "Lcom/jetbrains/rdclient/requests/BackendResponse$Success;", "(Lcom/jetbrains/rdclient/requests/BackendResponse$Success;Lcom/jetbrains/rdclient/requests/SpeculativeRequest;Ljava/lang/Object;)V", "rollForwardAllPendingRequests", "timestampChanged", "(ZLjava/lang/Object;Z)V", "resendPendingRequests", "FastPathResult", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nSpeculativeQueueProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeculativeQueueProcessor.kt\ncom/jetbrains/rdclient/requests/SpeculativeQueueProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1869#2,2:310\n1761#2,3:312\n1869#2,2:315\n1869#2,2:317\n*S KotlinDebug\n*F\n+ 1 SpeculativeQueueProcessor.kt\ncom/jetbrains/rdclient/requests/SpeculativeQueueProcessor\n*L\n109#1:310,2\n163#1:312,3\n289#1:315,2\n298#1:317,2\n*E\n"})
public final class SpeculativeQueueProcessor<TContext, TReq extends SpeculativeRequest<TContext>> {
    private long lastSubmittedRequestId = Long.MIN_VALUE;
    @NotNull
    private PatchEngineRetryTimestampWithGeneration globalRetryTimestamp = new PatchEngineRetryTimestampWithGeneration(0L, 0L);
    private long backendChangesCounter;
    @NotNull
    private final ConcurrentLinkedDeque<TReq> pendingRequestsQueue = new ConcurrentLinkedDeque();
    @NotNull
    private final ArrayDeque<ChangeFromBackend<TContext, TReq>> pendingResponses = new ArrayDeque();
    private boolean processing;

    public final void submitRequest(@NotNull TReq request) {
        boolean bl;
        Intrinsics.checkNotNullParameter(request, (String)"request");
        boolean bl2 = bl = !this.processing;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SpeculativeQueueProcessor$submitRequest$32 = false;
            String $i$a$-assert-SpeculativeQueueProcessor$submitRequest$32 = "Submitting requests: " + request + " during processing is prohibited";
            throw new AssertionError((Object)$i$a$-assert-SpeculativeQueueProcessor$submitRequest$32);
        }
        boolean bl3 = bl = this.lastSubmittedRequestId < request.getUniqueId();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "request.uniqueId: " + request.getUniqueId() + " must be more then previous id: " + this.lastSubmittedRequestId;
            throw new AssertionError((Object)string);
        }
        this.lastSubmittedRequestId = request.getUniqueId();
        this.pendingRequestsQueue.add(request);
        request.send(this.globalRetryTimestamp);
    }

    public final void onBackendResponse(@NotNull ChangeFromBackend<TContext, TReq> response) {
        boolean bl;
        Intrinsics.checkNotNullParameter(response, (String)"response");
        boolean bl2 = bl = !this.processing;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Submitting responses: " + response + " during processing is prohibited";
            throw new AssertionError((Object)string);
        }
        this.pendingResponses.add(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(TContext context) {
        if (this.pendingResponses.isEmpty()) {
            return;
        }
        List responsesCopy = CollectionsKt.toList((Iterable)this.pendingResponses);
        PatchEngineRetryTimestampWithGeneration oldTimestamp = this.globalRetryTimestamp;
        this.processing = true;
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[this.tryProcessWithoutPhysicalRebase(context).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    boolean bl;
                    boolean bl2 = bl = oldTimestamp.compareTo(this.globalRetryTimestamp) < 0;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-SpeculativeQueueProcessor$process$32 = false;
                        String $i$a$-assert-SpeculativeQueueProcessor$process$32 = "Old timestamp: " + oldTimestamp + " < globalRetryTimestamp: " + this.globalRetryTimestamp;
                        throw new AssertionError((Object)$i$a$-assert-SpeculativeQueueProcessor$process$32);
                    }
                    this.resendPendingRequests();
                    break;
                }
                case 3: {
                    this.rebase(context, oldTimestamp);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean bl = this.pendingResponses.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-SpeculativeQueueProcessor$process$42 = false;
                String $i$a$-assert-SpeculativeQueueProcessor$process$42 = "All pending responses must be processed";
                throw new AssertionError((Object)$i$a$-assert-SpeculativeQueueProcessor$process$42);
            }
            Iterable $this$forEach$iv = responsesCopy;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChangeFromBackend it = (ChangeFromBackend)element$iv;
                boolean bl3 = false;
                it.executed();
            }
        }
        finally {
            this.processing = false;
        }
    }

    public final void cancelAndRemoveAllPending() {
        ThreadingAssertions.assertEventDispatchThread();
        ThreadingAssertions.assertWriteIntentReadAccess();
        this.pendingResponses.clear();
        this.pendingRequestsQueue.clear();
        this.globalRetryTimestamp = this.globalRetryTimestamp.incrementGeneration();
    }

    @NotNull
    public final List<TReq> getPendingRequests() {
        return CollectionsKt.toList((Iterable)this.pendingRequestsQueue);
    }

    @NotNull
    public final List<ChangeFromBackend<TContext, TReq>> getPendingResponses() {
        return CollectionsKt.toList((Iterable)this.pendingResponses);
    }

    public final boolean isEmpty() {
        return this.pendingRequestsQueue.isEmpty();
    }

    public final long appliedResponsesCount() {
        return this.backendChangesCounter;
    }

    private final void rebase(TContext context, PatchEngineRetryTimestampWithGeneration oldTimestamp) {
        this.rollbackAllPendingRequests(false, context);
        this.applyAllPendingResponses(context);
        this.rollForwardAllPendingRequests(false, context, !Intrinsics.areEqual((Object)oldTimestamp, (Object)this.globalRetryTimestamp));
    }

    private final FastPathResult tryProcessWithoutPhysicalRebase(TContext context) {
        Iterator<ChangeFromBackend<TContext, TReq>> iterator2 = this.pendingResponses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ChangeFromBackend<TContext, TReq>> iterator3 = iterator2;
        FastPathResult result2 = FastPathResult.Processed;
        while (iterator3.hasNext()) {
            boolean $i$a$-assert-SpeculativeQueueProcessor$tryProcessWithoutPhysicalRebase$52;
            ChangeFromBackend<TContext, TReq> response = iterator3.next();
            if (response instanceof BackendOriginatedChange) {
                boolean bl;
                block16: {
                    Iterable $this$any$iv = this.pendingRequestsQueue;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SpeculativeRequest it = (SpeculativeRequest)element$iv;
                            boolean bl2 = false;
                            BackendOriginatedChange backendOriginatedChange = (BackendOriginatedChange)response;
                            Intrinsics.checkNotNull((Object)it);
                            if (!backendOriginatedChange.conflictsWith(it)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return FastPathResult.Rebase;
                }
                iterator3.remove();
                ((BackendOriginatedChange)response).apply(context);
                long $this$any$iv = this.backendChangesCounter;
                this.backendChangesCounter = $this$any$iv + 1L;
                continue;
            }
            if (response instanceof BackendResponse.RetryRequired) {
                boolean $this$any$iv;
                iterator3.remove();
                boolean bl = $this$any$iv = this.globalRetryTimestamp.compareTo(((BackendResponse.RetryRequired)response).getNewGlobalRetryTimestamp()) < 0;
                if (_Assertions.ENABLED && !$this$any$iv) {
                    $i$a$-assert-SpeculativeQueueProcessor$tryProcessWithoutPhysicalRebase$52 = false;
                    String $i$a$-assert-SpeculativeQueueProcessor$tryProcessWithoutPhysicalRebase$52 = "Global retry timestamp must be less than new global retry timestamp";
                    throw new AssertionError((Object)$i$a$-assert-SpeculativeQueueProcessor$tryProcessWithoutPhysicalRebase$52);
                }
                this.globalRetryTimestamp = ((BackendResponse.RetryRequired)response).getNewGlobalRetryTimestamp();
                result2 = FastPathResult.JustRetry;
                continue;
            }
            if (response instanceof BackendResponse.Success) {
                boolean bl;
                PatchEngineRetryTimestampWithGeneration newRetryTimestamp;
                SpeculativeRequest request = (SpeculativeRequest)this.pendingRequestsQueue.peek();
                boolean bl3 = $i$a$-assert-SpeculativeQueueProcessor$tryProcessWithoutPhysicalRebase$52 = ((BackendResponse.Success)response).getRequestId() == request.getUniqueId();
                if (_Assertions.ENABLED && !$i$a$-assert-SpeculativeQueueProcessor$tryProcessWithoutPhysicalRebase$52) {
                    boolean bl4 = false;
                    String string = "Unexpected response " + response + " for " + request;
                    throw new AssertionError((Object)string);
                }
                BackendResponse.Success success = (BackendResponse.Success)response;
                Intrinsics.checkNotNull((Object)request);
                switch (WhenMappings.$EnumSwitchMapping$1[success.compare(request, context).ordinal()]) {
                    case 1: {
                        iterator3.remove();
                        this.completeRequest((BackendResponse.Success)response, request, context);
                        break;
                    }
                    case 2: {
                        iterator3.remove();
                        this.rollbackAllPendingRequests(true, context);
                        ((BackendResponse.Success)response).apply(true, request, context);
                        this.completeRequest((BackendResponse.Success)response, request, context);
                        this.rollForwardAllPendingRequests(true, context, false);
                        break;
                    }
                    case 3: {
                        return FastPathResult.Rebase;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                if ((newRetryTimestamp = ((BackendResponse.Success)response).getNewRetryTimestamp()) == null) continue;
                boolean bl5 = bl = this.globalRetryTimestamp.compareTo(newRetryTimestamp) < 0;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string = "Global retry timestamp must be less than new global retry timestamp";
                    throw new AssertionError((Object)string);
                }
                this.globalRetryTimestamp = newRetryTimestamp;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    private final void rollbackAllPendingRequests(boolean virtually, TContext context) {
        Iterator<TReq> iterator2 = this.pendingRequestsQueue.descendingIterator();
        while (iterator2.hasNext()) {
            SpeculativeRequest request = (SpeculativeRequest)iterator2.next();
            request.rollback(virtually, context);
        }
    }

    private final void applyAllPendingResponses(TContext context) {
        Iterator<ChangeFromBackend<TContext, TReq>> iterator2 = this.pendingResponses.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ChangeFromBackend<TContext, TReq>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ChangeFromBackend<TContext, TReq> response = iterator3.next();
            if (response instanceof BackendOriginatedChange) {
                ((BackendOriginatedChange)response).apply(context);
                long l = this.backendChangesCounter;
                this.backendChangesCounter = l + 1L;
            } else if (response instanceof BackendResponse.RetryRequired) {
                boolean bl;
                boolean bl2 = bl = this.globalRetryTimestamp.compareTo(((BackendResponse.RetryRequired)response).getNewGlobalRetryTimestamp()) < 0;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-SpeculativeQueueProcessor$applyAllPendingResponses$32 = false;
                    String $i$a$-assert-SpeculativeQueueProcessor$applyAllPendingResponses$32 = "Global retry timestamp must be less than new global retry timestamp";
                    throw new AssertionError((Object)$i$a$-assert-SpeculativeQueueProcessor$applyAllPendingResponses$32);
                }
                this.globalRetryTimestamp = ((BackendResponse.RetryRequired)response).getNewGlobalRetryTimestamp();
            } else if (response instanceof BackendResponse.Success) {
                SpeculativeRequest pendingRequest;
                PatchEngineRetryTimestampWithGeneration newRetryTimestamp = ((BackendResponse.Success)response).getNewRetryTimestamp();
                if (newRetryTimestamp != null) {
                    boolean $i$a$-assert-SpeculativeQueueProcessor$applyAllPendingResponses$32;
                    boolean bl = $i$a$-assert-SpeculativeQueueProcessor$applyAllPendingResponses$32 = this.globalRetryTimestamp.compareTo(newRetryTimestamp) < 0;
                    if (_Assertions.ENABLED && !$i$a$-assert-SpeculativeQueueProcessor$applyAllPendingResponses$32) {
                        boolean bl3 = false;
                        String string = "Global retry timestamp must be less than new global retry timestamp";
                        throw new AssertionError((Object)string);
                    }
                    this.globalRetryTimestamp = newRetryTimestamp;
                }
                if ((pendingRequest = (SpeculativeRequest)this.pendingRequestsQueue.peek()).getUniqueId() != ((BackendResponse.Success)response).getRequestId()) {
                    throw new IllegalStateException(("Unexpected response: " + response + ". Current first pending request is " + pendingRequest).toString());
                }
                BackendResponse.Success success = (BackendResponse.Success)response;
                Intrinsics.checkNotNull((Object)pendingRequest);
                success.apply(false, pendingRequest, context);
                this.completeRequest((BackendResponse.Success)response, pendingRequest, context);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            iterator3.remove();
        }
    }

    private final void completeRequest(BackendResponse.Success<TContext, TReq> response, TReq request, TContext context) {
        boolean bl;
        SpeculativeRequest firstRequest = (SpeculativeRequest)this.pendingRequestsQueue.poll();
        boolean bl2 = bl = firstRequest == request;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected request to be removed: " + request + ", but actual: " + firstRequest;
            throw new AssertionError((Object)string);
        }
        response.complete(request, context);
        long l = this.backendChangesCounter;
        this.backendChangesCounter = l + 1L;
    }

    private final void rollForwardAllPendingRequests(boolean virtually, TContext context, boolean timestampChanged) {
        Iterable $this$forEach$iv = this.pendingRequestsQueue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpeculativeRequest request = (SpeculativeRequest)element$iv;
            boolean bl = false;
            request.replay(virtually, context);
            if (virtually || !timestampChanged) continue;
            request.send(this.globalRetryTimestamp);
        }
    }

    private final void resendPendingRequests() {
        Iterable $this$forEach$iv = this.pendingRequestsQueue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpeculativeRequest it = (SpeculativeRequest)element$iv;
            boolean bl = false;
            it.send(this.globalRetryTimestamp);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/requests/SpeculativeQueueProcessor$FastPathResult;", "", "<init>", "(Ljava/lang/String;I)V", "Processed", "JustRetry", "Rebase", "intellij.rd.client"})
    private static final class FastPathResult
    extends Enum<FastPathResult> {
        public static final /* enum */ FastPathResult Processed = new FastPathResult();
        public static final /* enum */ FastPathResult JustRetry = new FastPathResult();
        public static final /* enum */ FastPathResult Rebase = new FastPathResult();
        private static final /* synthetic */ FastPathResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FastPathResult[] values() {
            return (FastPathResult[])$VALUES.clone();
        }

        public static FastPathResult valueOf(String value) {
            return Enum.valueOf(FastPathResult.class, value);
        }

        @NotNull
        public static EnumEntries<FastPathResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fastPathResultArray = new FastPathResult[]{FastPathResult.Processed, FastPathResult.JustRetry, FastPathResult.Rebase};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FastPathResult.values().length];
            try {
                nArray[FastPathResult.Processed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FastPathResult.JustRetry.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FastPathResult.Rebase.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpeculativelyEqualsResult.values().length];
            try {
                nArray[SpeculativelyEqualsResult.Equals.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpeculativelyEqualsResult.Equivalent.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpeculativelyEqualsResult.Different.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

