/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.gutterMarks;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.MergeableGutterIconRenderer;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ExperimentalUI;
import com.jetbrains.rd.ide.model.GutterMarkActionModel;
import com.jetbrains.rd.ide.model.GutterMarkDnDModel;
import com.jetbrains.rd.ide.model.GutterMarkHoverModel;
import com.jetbrains.rd.ide.model.HoverEventType;
import com.jetbrains.rd.ide.model.RdGutterExecutionRequest;
import com.jetbrains.rd.ide.model.RdGutterHoverRequest;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkInfo;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.GutterMarkWeight;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.IGutterIconRendererWithHover;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendStringTooltipCalculator;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\"\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020,2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\"\u00102\u001a\u00020.2\u0006\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020,2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020.H\u0016J\u0011\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u0002H\u0096\u0002J\u0013\u0010:\u001a\u0002042\b\u00109\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020.H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "Lcom/intellij/openapi/editor/MergeableGutterIconRenderer;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/IGutterIconRendererWithHover;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "info", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;", "gutterMarkActionModel", "Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "gutterMarkHoverModel", "Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "dndModel", "Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;)V", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getInfo", "()Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/GutterMarkInfo;", "getGutterMarkActionModel", "()Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "getDndModel", "()Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "getIcon", "Ljavax/swing/Icon;", "tooltipCalculator", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendStringTooltipCalculator;", "getTooltipText", "", "onHover", "", "hoverEvent", "Lcom/jetbrains/rd/ide/model/HoverEventType;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "calcSurroundRange", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "calculateRightOffset", "foldingModelImpl", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "calculateLeftOffset", "isNavigateAction", "", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getWeight", "compareTo", "other", "equals", "", "hashCode", "intellij.rd.client"})
public class FrontendGutterIconRenderer
extends GutterIconRenderer
implements MergeableGutterIconRenderer,
DumbAware,
IGutterIconRendererWithHover {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final GutterMarkInfo info;
    @NotNull
    private final GutterMarkActionModel gutterMarkActionModel;
    @NotNull
    private final GutterMarkHoverModel gutterMarkHoverModel;
    @NotNull
    private final GutterMarkDnDModel dndModel;
    @NotNull
    private final FrontendStringTooltipCalculator tooltipCalculator;

    public FrontendGutterIconRenderer(@NotNull RangeHighlighter highlighter, @NotNull GutterMarkInfo info, @NotNull GutterMarkActionModel gutterMarkActionModel, @NotNull GutterMarkHoverModel gutterMarkHoverModel, @NotNull FrontendTooltipProvider tooltipProvider, @NotNull GutterMarkDnDModel dndModel) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)gutterMarkActionModel, (String)"gutterMarkActionModel");
        Intrinsics.checkNotNullParameter((Object)gutterMarkHoverModel, (String)"gutterMarkHoverModel");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        Intrinsics.checkNotNullParameter((Object)dndModel, (String)"dndModel");
        this.highlighter = highlighter;
        this.info = info;
        this.gutterMarkActionModel = gutterMarkActionModel;
        this.gutterMarkHoverModel = gutterMarkHoverModel;
        this.dndModel = dndModel;
        this.tooltipCalculator = new FrontendStringTooltipCalculator(this.info.getId(), tooltipProvider);
    }

    @NotNull
    public final RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final GutterMarkInfo getInfo() {
        return this.info;
    }

    @NotNull
    protected final GutterMarkActionModel getGutterMarkActionModel() {
        return this.gutterMarkActionModel;
    }

    @NotNull
    public final GutterMarkDnDModel getDndModel() {
        return this.dndModel;
    }

    @NotNull
    public Icon getIcon() {
        return this.info.getIcon();
    }

    @Nullable
    public String getTooltipText() {
        return this.tooltipCalculator.getTooltip();
    }

    @Override
    public void onHover(@NotNull HoverEventType hoverEvent) {
        Intrinsics.checkNotNullParameter((Object)hoverEvent, (String)"hoverEvent");
        RdGutterHoverRequest request = new RdGutterHoverRequest(this.info.getId(), hoverEvent);
        this.gutterMarkHoverModel.getHover().fire((Object)request);
    }

    @Nullable
    public AnAction getClickAction() {
        if (this.info.getLeftAction() == null) {
            return null;
        }
        Icon icon = this.getIcon();
        return (AnAction)new DumbAware(this, icon){
            final /* synthetic */ FrontendGutterIconRenderer this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                if (!this.this$0.getHighlighter().isValid()) {
                    return;
                }
                TextRange rangeToCollectBulbs = this.this$0.calcSurroundRange(editor2, this.this$0.getHighlighter().getStartOffset());
                RdGutterExecutionRequest request = new RdGutterExecutionRequest(this.this$0.getInfo().getId(), rangeToCollectBulbs.getStartOffset(), rangeToCollectBulbs.getEndOffset());
                this.this$0.getGutterMarkActionModel().getLeftClick().fire((Object)request);
            }
        };
    }

    @Nullable
    public ActionGroup getPopupMenuActions() {
        return null;
    }

    @NotNull
    public final TextRange calcSurroundRange(@NotNull Editor editor, int offset) {
        FoldingModel foldingModel;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        SoftWrap wrap = editor.getSoftWrapModel().getSoftWrap(offset);
        if (wrap != null) {
            new TextRange(wrap.getStart(), wrap.getEnd());
        }
        FoldingModelImpl foldingModel2 = (foldingModel = editor.getFoldingModel()) instanceof FoldingModelImpl ? (FoldingModelImpl)foldingModel : null;
        return new TextRange(this.calculateLeftOffset(offset, editor, foldingModel2), this.calculateRightOffset(offset, editor, foldingModel2));
    }

    private final int calculateRightOffset(int offset, Editor editor, FoldingModelImpl foldingModelImpl) {
        int lineEndOffset = EditorUtil.getNotFoldedLineEndOffset((Editor)editor, (int)offset);
        if (foldingModelImpl == null) {
            return lineEndOffset;
        }
        List list2 = foldingModelImpl.getRegionsOverlappingWith(offset, lineEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRegionsOverlappingWith(...)");
        List regionsOverlappingWithRange = list2;
        for (Object e : regionsOverlappingWithRange) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FoldRegion foldRegion = (FoldRegion)e;
            int n = offset + 1;
            int n2 = foldRegion.getStartOffset();
            boolean bl = n <= n2 ? n2 < lineEndOffset : false;
            if (!bl || foldRegion.isExpanded()) continue;
            return foldRegion.getStartOffset();
        }
        return lineEndOffset;
    }

    private final int calculateLeftOffset(int offset, Editor editor, FoldingModelImpl foldingModelImpl) {
        int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset((Editor)editor, (int)offset);
        if (foldingModelImpl == null) {
            return lineStartOffset;
        }
        List list2 = foldingModelImpl.getRegionsOverlappingWith(lineStartOffset, offset);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRegionsOverlappingWith(...)");
        List regionsOverlappingWithRange = list2;
        CollectionsKt.sortWith((List)regionsOverlappingWithRange, (arg_0, arg_1) -> FrontendGutterIconRenderer.calculateLeftOffset$lambda$1(FrontendGutterIconRenderer::calculateLeftOffset$lambda$0, arg_0, arg_1));
        for (Object e : regionsOverlappingWithRange) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FoldRegion foldRegion = (FoldRegion)e;
            int n = lineStartOffset + 1;
            int n2 = foldRegion.getEndOffset();
            boolean bl = n <= n2 ? n2 < offset : false;
            if (!bl || foldRegion.isExpanded()) continue;
            return foldRegion.getEndOffset();
        }
        return lineStartOffset;
    }

    public boolean isNavigateAction() {
        return this.info.isNavigatable();
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return this.info.getAlignment() == GutterIconRenderer.Alignment.LINE_NUMBERS && (!ExperimentalUI.Companion.isNewUI() || !EditorUtil.isBreakPointsOnLineNumbers()) ? GutterIconRenderer.Alignment.RIGHT : this.info.getAlignment();
    }

    public int getWeight() {
        return this.info.getWeight().getFrontendWeight();
    }

    public int compareTo(@NotNull MergeableGutterIconRenderer other) {
        int cmp;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof FrontendGutterIconRenderer && (cmp = GutterMarkWeight.Companion.compareByBackend(this.info.getWeight(), ((FrontendGutterIconRenderer)other).info.getWeight())) != 0) {
            return cmp;
        }
        return super.compareTo(other);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FrontendGutterIconRenderer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.info, (Object)((FrontendGutterIconRenderer)other).info);
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    private static final int calculateLeftOffset$lambda$0(FoldRegion firstRegion, FoldRegion secondRegion) {
        return secondRegion.getEndOffset() - firstRegion.getEndOffset();
    }

    private static final int calculateLeftOffset$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

