/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModel;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u0001:\u0002@AB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0016\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020 2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010(2\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0015H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020%H\u0002J\u0016\u00101\u001a\u00020 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030$H\u0002J\b\u00104\u001a\u00020 H\u0002J\u0016\u00105\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u00020 2\f\u00109\u001a\b\u0012\u0004\u0012\u00020 0:H\u0002J\u001d\u0010;\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u000207H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006B"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupAdapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "highlighterRepairer", "Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "storage", "Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "suppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMarkupAdapter", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "getStorage", "()Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "value", "", "isUpdating", "()Z", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "isFlushedFlowMutable", "Lkotlinx/coroutines/flow/MutableStateFlow;", "isFlushedFlow", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "queueUpdateIfNeed", "", "flushHighlighters", "highlightersAdded", "added", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "isReplaced", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "highlightersUpdated", "updated", "repair", "model", "trackInvalid", "recycle", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "element", "highlightersRemoved", "removed", "", "removeAllHighlighters", "suppress", "suppressionKind", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "update", "block", "Lkotlin/Function0;", "bind", "protocolMarkup", "Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "bind$intellij_rd_client", "isSuppressed", "MergingUpdateTask", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n67#2,4:327\n60#2,5:332\n67#2,4:337\n67#2,4:341\n67#2,4:345\n67#2,4:349\n67#2,4:353\n60#2,5:357\n67#2,4:362\n67#2,4:368\n67#2,2:372\n70#2:376\n67#2,4:377\n67#2,4:381\n67#2,4:385\n67#2,4:389\n13#2:393\n1#3:331\n13225#4,2:366\n1915#5,2:374\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n*L\n157#1:327,4\n71#1:332,5\n72#1:337,4\n89#1:341,4\n101#1:345,4\n106#1:349,4\n111#1:353,4\n232#1:357,5\n235#1:362,4\n266#1:368,4\n270#1:372,2\n270#1:376\n284#1:377,4\n288#1:381,4\n292#1:385,4\n296#1:389,4\n306#1:393\n236#1:366,2\n274#1:374,2\n*E\n"})
public final class FrontendMarkupContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FrontendMarkupAdapter markupAdapter;
    @NotNull
    private final HighlighterRangeRepairer highlighterRepairer;
    @NotNull
    private final RecyclingHighlighterStorage storage;
    @NotNull
    private final FrontendMarkupSuppressor suppressor;
    private boolean isUpdating;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private final MutableStateFlow<Boolean> isFlushedFlowMutable;
    @NotNull
    private final StateFlow<Boolean> isFlushedFlow;
    @NotNull
    private static final Logger LOG;

    public FrontendMarkupContributor(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapter markupAdapter, @NotNull HighlighterRangeRepairer highlighterRepairer, @NotNull RecyclingHighlighterStorage storage, @NotNull FrontendMarkupSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkNotNullParameter((Object)highlighterRepairer, (String)"highlighterRepairer");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        this.lifetime = lifetime;
        this.markupAdapter = markupAdapter;
        this.highlighterRepairer = highlighterRepairer;
        this.storage = storage;
        this.suppressor = suppressor;
        this.mergingUpdateQueue = new MergingUpdateQueue("FrontendMarkupContributor.mergingUpdateQueue", 50, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null), null, false, 96, null);
        this.isFlushedFlowMutable = StateFlowKt.MutableStateFlow((Object)false);
        this.isFlushedFlow = FlowKt.asStateFlow(this.isFlushedFlowMutable);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final FrontendMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    @NotNull
    public final RecyclingHighlighterStorage getStorage() {
        return this.storage;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    @NotNull
    public final StateFlow<Boolean> isFlushedFlow() {
        return this.isFlushedFlow;
    }

    private final void queueUpdateIfNeed() {
        if (this.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE) {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            this.mergingUpdateQueue.queue((Update)new MergingUpdateTask(modalityState));
        }
    }

    private final void flushHighlighters() {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.flushHighlighters$lambda$0(this)));
    }

    private final void highlightersAdded(List<HighlighterElement> added) {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.highlightersAdded$lambda$0(added, this)));
    }

    private final boolean isReplaced(HighlighterModel highlighterModel) {
        FrontendHighlighterSuppressionHandler relevantSuppressor = (FrontendHighlighterSuppressionHandler)FrontendHighlighterSuppressionHandler.Companion.getEP_NAME().findFirstSafe(arg_0 -> FrontendMarkupContributor.isReplaced$lambda$1(arg_0 -> FrontendMarkupContributor.isReplaced$lambda$0(highlighterModel, this, arg_0), arg_0));
        if (relevantSuppressor != null) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Suppressing " + highlighterModel.getClass().getSimpleName() + " highlighter " + HighlightersUtilKt.prettyPrint(highlighterModel) + " by " + relevantSuppressor.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    private final void highlightersUpdated(List<HighlighterElement> updated) {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.highlightersUpdated$lambda$0(updated, this)));
    }

    private final HighlighterModel repair(HighlighterModel model2, boolean trackInvalid) {
        HighlighterModel highlighterModel = this.highlighterRepairer.repair(model2);
        if (highlighterModel != null) {
            HighlighterModel it = highlighterModel;
            boolean bl = false;
            return it;
        }
        if (trackInvalid) {
            this.storage.addInvalidHighlighter(model2);
        }
        return null;
    }

    private final RangeHighlighterEx recycle(HighlighterElement element) {
        RangeHighlighterEx recycledHighlighter = this.storage.recycle(element.getHighlighter());
        if (recycledHighlighter != null) {
            this.markupAdapter.updateHighlighter(recycledHighlighter, element);
        }
        return recycledHighlighter;
    }

    private final void highlightersRemoved(List<Long> removed) {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.highlightersRemoved$lambda$0(removed, this)));
    }

    private final void removeAllHighlighters() {
        this.update((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.removeAllHighlighters$lambda$0(this)));
    }

    public final void suppress(@NotNull Lifetime lifetime, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime, suppressionKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void update(Function0<Unit> block) {
        try {
            this.isUpdating = true;
            this.isFlushedFlowMutable.setValue((Object)false);
            block.invoke();
        }
        finally {
            this.isUpdating = false;
            this.isFlushedFlowMutable.setValue((Object)this.storage.isFlushed());
        }
    }

    public final void bind$intellij_rd_client(@NotNull Lifetime lifetime, @NotNull ProtocolSuppressableMarkupModel protocolMarkup) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        protocolMarkup.getHighlightersRemoved().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$0(this, arg_0));
        protocolMarkup.getHighlightersAdded().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$1(this, arg_0));
        protocolMarkup.getHighlightersUpdated().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$2(this, arg_0));
        protocolMarkup.getHighlightersCleared().advise(lifetime, arg_0 -> FrontendMarkupContributor.bind$lambda$3(this, arg_0));
        this.suppressor.released(lifetime, (Function1<? super Lifetime, Unit>)((Function1)arg_0 -> FrontendMarkupContributor.bind$lambda$4(this, arg_0)));
        lifetime.onTermination(() -> FrontendMarkupContributor.bind$lambda$5(this));
        protocolMarkup.bind(lifetime);
    }

    @TestOnly
    @NotNull
    public final MarkupSuppressionKind isSuppressed() {
        return this.suppressor.isSuppressed$intellij_rd_client();
    }

    private static final Unit flushHighlighters$lambda$0(FrontendMarkupContributor this$0) {
        List<RangeHighlighterEx> notDeleted;
        Logger $this$trace$iv;
        HighlighterModel repairedModel;
        List extensions;
        Logger logger;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("highlighter flush triggered!", t$iv);
        }
        Logger $this$trace$iv2 = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace("highlighters in document:" + this$0.markupAdapter.getAllHighlighters().length);
        }
        List<Map.Entry<RangeHighlighterEx, HighlighterElement>> notUpdated = this$0.storage.flushNotUpdated();
        if (!((Collection)notUpdated).isEmpty()) {
            for (Map.Entry<RangeHighlighterEx, HighlighterElement> bl : notUpdated) {
                RangeHighlighterEx highlighter = bl.getKey();
                HighlighterElement element = bl.getValue();
                HighlighterModel model2 = element.component1();
                extensions = element.component2();
                repairedModel = this$0.repair(model2, false);
                if (repairedModel == null) {
                    LOG.warn("Received unrepairable update for highlighter during flush. Model: " + HighlightersUtilKt.prettyPrint(model2));
                    continue;
                }
                this$0.markupAdapter.updateHighlighter(highlighter, new HighlighterElement(repairedModel, extensions));
            }
        }
        ArrayList<HighlighterElement> notReused = new ArrayList<HighlighterElement>();
        List<HighlighterElement> notRegistered = this$0.storage.flushNotRegistered();
        if (!((Collection)notRegistered).isEmpty()) {
            Logger $this$trace$iv3 = LOG;
            boolean $i$f$trace22 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl = false;
                logger.trace("Flushing to markup " + notRegistered.size() + " not registered highlighters");
            }
            for (HighlighterElement $i$f$trace22 : notRegistered) {
                HighlighterModel highlighterModel = $i$f$trace22.component1();
                extensions = $i$f$trace22.component2();
                repairedModel = this$0.repair(highlighterModel, true);
                if (repairedModel == null) {
                    LOG.warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                    continue;
                }
                HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
                RangeHighlighterEx recycled = this$0.recycle(repairedElement);
                if (recycled != null) continue;
                notReused.add(repairedElement);
            }
            int reused = notRegistered.size() - notReused.size();
            $this$trace$iv = LOG;
            boolean $i$f$trace3 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Reused " + reused + " highlighters during flush");
            }
        }
        if (!((Collection)(notDeleted = this$0.storage.flushNotDeleted())).isEmpty()) {
            $this$trace$iv = LOG;
            boolean $i$f$trace4 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Deleting " + notDeleted.size() + " highlighters from markup");
            }
            this$0.markupAdapter.bulkRemoveHighlighters(notDeleted);
        }
        if (notReused.size() != 0) {
            $this$trace$iv = LOG;
            boolean $i$f$trace5 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Registering last portion of " + notReused.size() + " highlighters which have failed at reusing");
            }
            List<RangeHighlighterEx> added = this$0.markupAdapter.bulkAddHighlighters((List<HighlighterElement>)notReused);
            int n = ((Collection)added).size();
            for (int i = 0; i < n; ++i) {
                this$0.storage.addHighlighter(((HighlighterElement)notReused.get(i)).getHighlighter().getId(), added.get(i));
            }
        }
        this$0.highlighterRepairer.shrinkHistory();
        return Unit.INSTANCE;
    }

    private static final Unit highlightersAdded$lambda$0(List $added, FrontendMarkupContributor this$0) {
        List repairedModels = new ArrayList();
        for (HighlighterElement element : $added) {
            Object object;
            HighlighterModel repairedModel;
            boolean bl;
            HighlighterModel highlighterModel = element.getHighlighter();
            List extensions = element.getExtensions();
            boolean bl2 = bl = this$0.storage.get(highlighterModel.getId()) == null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = false;
                String $i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22 = "Multiple highlighter registration on IDEA-side! id: " + highlighterModel.getId() + " model: " + HighlightersUtilKt.prettyPrint(highlighterModel);
                throw new AssertionError((Object)$i$a$-assert-FrontendMarkupContributor$highlightersAdded$1$22);
            }
            if (this$0.repair(highlighterModel, true) == null || this$0.isReplaced(highlighterModel)) continue;
            HighlighterElement repairedElement = new HighlighterElement(repairedModel, extensions);
            if (this$0.suppressor.shouldSuppressAddition(highlighterModel.getProperties())) {
                object = this$0.recycle(repairedElement);
                if (object == null) {
                    FrontendMarkupContributor $this$highlightersAdded_u24lambda_u240_u241 = this$0;
                    boolean bl3 = false;
                    $this$highlightersAdded_u24lambda_u240_u241.storage.queueRegistration(element);
                    $this$highlightersAdded_u24lambda_u240_u241.queueUpdateIfNeed();
                    object = Unit.INSTANCE;
                }
                continue;
            }
            object = repairedModels.add(repairedElement);
        }
        if (!((Collection)repairedModels).isEmpty()) {
            List<RangeHighlighterEx> bulkAdded = this$0.markupAdapter.bulkAddHighlighters(repairedModels);
            int n = ((Collection)bulkAdded).size();
            for (int i = 0; i < n; ++i) {
                this$0.storage.addHighlighter(((HighlighterElement)repairedModels.get(i)).getHighlighter().getId(), bulkAdded.get(i));
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean isReplaced$lambda$0(HighlighterModel $highlighterModel, FrontendMarkupContributor this$0, FrontendHighlighterSuppressionHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.shouldSuppress($highlighterModel, this$0.markupAdapter.getDocument());
    }

    private static final boolean isReplaced$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit highlightersUpdated$lambda$0(List $updated, FrontendMarkupContributor this$0) {
        for (HighlighterElement element : $updated) {
            if (this$0.storage.updateRegistration(element)) continue;
            RangeHighlighterEx highlighter = this$0.storage.get(element.getHighlighter().getId());
            if (highlighter == null) {
                LOG.warn("Received update for not registered highlighter " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                continue;
            }
            if (this$0.suppressor.shouldSuppressUpdate()) {
                this$0.storage.queueUpdate(highlighter, element);
                this$0.queueUpdateIfNeed();
                continue;
            }
            HighlighterModel repairedModel = this$0.repair(element.getHighlighter(), false);
            if (repairedModel == null) {
                if (element.getHighlighter().getProperties().isVerifiable()) {
                    LOG.trace("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                    continue;
                }
                LOG.warn("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(element.getHighlighter()));
                continue;
            }
            this$0.markupAdapter.updateHighlighter(highlighter, new HighlighterElement(repairedModel, element.getExtensions()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit highlightersRemoved$lambda$0(List $removed, FrontendMarkupContributor this$0) {
        List toRemove = new ArrayList();
        Iterator iterator2 = $removed.iterator();
        while (iterator2.hasNext()) {
            RangeHighlighterEx highlighter;
            long id = ((Number)iterator2.next()).longValue();
            if (this$0.storage.remove(id) == null) continue;
            if (this$0.suppressor.shouldSuppressDeletion(UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter)))) {
                this$0.storage.queueDeletion(highlighter);
                this$0.queueUpdateIfNeed();
                continue;
            }
            toRemove.add(highlighter);
        }
        if (toRemove.isEmpty()) {
            return Unit.INSTANCE;
        }
        this$0.markupAdapter.bulkRemoveHighlighters(toRemove);
        return Unit.INSTANCE;
    }

    private static final Unit removeAllHighlighters$lambda$0(FrontendMarkupContributor this$0) {
        boolean any;
        block4: {
            boolean bl;
            Logger logger;
            List allHighlighters = CollectionsKt.plus(this$0.storage.getRegisteredHighlighters(), (Iterable)this$0.storage.flushNotDeleted());
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Cleaning highlighter storage. Total amount " + allHighlighters.size(), t$iv);
            }
            this$0.markupAdapter.bulkRemoveHighlighters(allHighlighters);
            this$0.storage.clear();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl3 = false;
                logger.trace("storage: " + this$0.storage);
            }
            RangeHighlighterEx[] $this$any$iv = this$0.markupAdapter.getAllHighlighters();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                RangeHighlighterEx element$iv;
                RangeHighlighterEx it = element$iv = $this$any$iv[i];
                boolean bl4 = false;
                if (!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)it)) continue;
                bl = true;
                break block4;
            }
            bl = any = false;
        }
        if (any) {
            LOG.error("backend highlighters present in Markup model after cleaning");
        }
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$0(FrontendMarkupContributor this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersRemoved fired: count=" + it.size());
        }
        this$0.highlightersRemoved(it);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(FrontendMarkupContributor this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            StringBuilder result2 = new StringBuilder().append("RdMarkupModel.highlightersAdded fired: count=" + it.size()).append('\n').append("Received highlighters from backend.  Highlighter breakdown:").append('\n');
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HighlighterElement element = (HighlighterElement)element$iv;
                boolean bl2 = false;
                HighlighterModel highlighter = element.getHighlighter();
                result2.append(highlighter.getProperties().getAttributeId()).append(":");
                com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$default(Companion, highlighter.getTextAttributesKey(), result2, 0, 2, null);
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger.trace(string);
        }
        this$0.highlightersAdded(it);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$2(FrontendMarkupContributor this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersUpdated fired: count=" + it.size());
        }
        this$0.highlightersUpdated(it);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(FrontendMarkupContributor this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
        }
        this$0.removeAllHighlighters();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4(FrontendMarkupContributor this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("suppressor is released. call flushHighlighters()");
        }
        this$0.flushHighlighters();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$5(FrontendMarkupContributor this$0) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
        }
        this$0.removeAllHighlighters();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "prettyPrint", "", "Lcom/jetbrains/ide/model/highlighterRegistration/TextAttributesKeyModel;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "depth", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void prettyPrint(@Nullable TextAttributesKeyModel $this$prettyPrint, @NotNull StringBuilder result2, int depth) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if ($this$prettyPrint == null) {
                result2.append("[NULL KEY]").append('\n');
                return;
            }
            if (!($this$prettyPrint instanceof IdeaTextAttributesKey)) {
                result2.append("[NON-IDEA KEY]").append('\n');
                return;
            }
            String indent = "  ";
            StringBuilder stringBuilder = result2.append(((IdeaTextAttributesKey)$this$prettyPrint).getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(" (").append('\n').append(StringsKt.repeat((CharSequence)indent, (int)(depth + 1))).append("fallback: ");
            TextAttributesKeyModel fallback = ((IdeaTextAttributesKey)$this$prettyPrint).getFallback();
            if (fallback == null) {
                result2.append("NULL").append('\n');
            } else {
                this.prettyPrint(fallback, result2, depth + 1);
            }
            StringBuilder stringBuilder3 = result2.append(StringsKt.repeat((CharSequence)indent, (int)depth));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder3;
            stringBuilder4.append(")").append('\n');
        }

        public static /* synthetic */ void prettyPrint$default(Companion companion, TextAttributesKeyModel textAttributesKeyModel, StringBuilder stringBuilder, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            companion.prettyPrint(textAttributesKeyModel, stringBuilder, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask;", "Lcom/intellij/util/ui/update/Update;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "<init>", "(Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;Lcom/intellij/openapi/application/ModalityState;)V", "run", "", "canEat", "", "update", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,326:1\n67#2,4:327\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n*L\n49#1:327,4\n*E\n"})
    private final class MergingUpdateTask
    extends Update {
        @NotNull
        private final ModalityState modality;

        public MergingUpdateTask(ModalityState modality) {
            Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
            super((Object)modality, false, 0, 6, null);
            this.modality = modality;
        }

        public void run() {
            ApplicationKt.getApplication().invokeLater(() -> MergingUpdateTask.run$lambda$0(FrontendMarkupContributor.this, this), this.modality);
        }

        public boolean canEat(@NotNull Update update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            if (!(update2 instanceof MergingUpdateTask)) {
                return false;
            }
            ModalityState otherModality = ((MergingUpdateTask)update2).modality;
            return Intrinsics.areEqual((Object)this.modality, (Object)otherModality) || this.modality.dominates(otherModality);
        }

        private static final void run$lambda$0(FrontendMarkupContributor this$0, MergingUpdateTask this$1) {
            if (this$0.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE && RLifetimeKt.isAlive((Lifetime)this$0.getLifetime())) {
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("MergingUpdateTask.run&invokeLater: call flushHighlighters(). modality: " + this$1.modality);
                }
                this$0.flushHighlighters();
            }
        }
    }
}

