/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.model.ActionTimestampSetModel;
import com.jetbrains.rd.ide.model.RdCallEditorActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.actions.cwm.ActionTimestampModelProvider;
import com.jetbrains.rdclient.actions.cwm.FrontendActionTimestampValidator;
import com.jetbrains.rdclient.diagnostics.ActionRequestFusData;
import com.jetbrains.rdclient.diagnostics.ActionRequestFusDataProvider;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequestKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BK\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\tH\u0014J\b\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u001e\u0010\"\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006-"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendEditorActionRequest;", "Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusDataProvider;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "info", "Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;", "initialTimestampSet", "Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "actionFusData", "Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;)V", "getEditorId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getFrontendActionId", "()Ljava/lang/String;", "getInfo", "()Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;", "getActionFusData", "()Lcom/jetbrains/rdclient/diagnostics/ActionRequestFusData;", "isBatchingAllowed", "", "()Z", "value", "timestampSetModel", "getTimestampSetModel", "()Lcom/jetbrains/rd/ide/model/ActionTimestampSetModel;", "doRedo", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "assertClientId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallEditorActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,115:1\n67#2,4:116\n57#2:127\n35#2,2:128\n82#2,2:130\n84#2:134\n23#2:141\n62#3,7:120\n69#3,2:132\n71#3,6:135\n77#3,2:142\n*S KotlinDebug\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n*L\n87#1:116,4\n94#1:127\n94#1:128,2\n94#1:130,2\n94#1:134\n94#1:141\n94#1:120,7\n94#1:132,2\n94#1:135,6\n94#1:142,2\n*E\n"})
public class FrontendCallEditorActionRequest
extends FrontendAsyncRequestWithImmediateResult
implements FrontendEditorActionRequest,
ActionRequestFusDataProvider {
    @NotNull
    private final TextControlId editorId;
    @NotNull
    private final String frontendActionId;
    @Nullable
    private final EditorActionCommandInfo info;
    @NotNull
    private final ActionRequestFusData actionFusData;
    @NotNull
    private ActionTimestampSetModel timestampSetModel;

    public FrontendCallEditorActionRequest(@NotNull RdPatch patch, @NotNull TextControlId editorId, @NotNull String frontendActionId, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken, @Nullable EditorActionCommandInfo info, @NotNull ActionTimestampSetModel initialTimestampSet, @NotNull ActionRequestFusData actionFusData) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)initialTimestampSet, (String)"initialTimestampSet");
        Intrinsics.checkNotNullParameter((Object)actionFusData, (String)"actionFusData");
        super(session, patch, resetUndoHistoryToken);
        this.editorId = editorId;
        this.frontendActionId = frontendActionId;
        this.info = info;
        this.actionFusData = actionFusData;
        this.timestampSetModel = initialTimestampSet;
    }

    @Override
    @NotNull
    public TextControlId getEditorId() {
        return this.editorId;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @Override
    @Nullable
    public EditorActionCommandInfo getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public ActionRequestFusData getActionFusData() {
        return this.actionFusData;
    }

    @Override
    public boolean isBatchingAllowed() {
        return true;
    }

    @NotNull
    public final ActionTimestampSetModel getTimestampSetModel() {
        return this.timestampSetModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected RdPatch doRedo(@NotNull FrontendRebaseSession rebaseSession) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        Editor editor = FrontendTextControlHostKt.toEditorOrNull(this.getEditorId());
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl == null) {
            return FrontendAsyncRequest.Companion.getEmptyPatch();
        }
        EditorImpl editor2 = editorImpl;
        DataContext dataContext = editor2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        ActionTimestampSetModel actualSetModel = ActionTimestampModelProvider.Companion.createTimestampModelSet(this.frontendActionId, dataContext2, false);
        if (!FrontendActionTimestampValidator.Companion.validateActualTimestampSetModel(this.frontendActionId, this.timestampSetModel, actualSetModel)) {
            FrontendCallEditorActionRequestKt.access$getLOG$p().error("Context changed. `" + this.frontendActionId + "` might produce incorrect results");
            Logger $this$trace$iv = FrontendCallEditorActionRequestKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Old context: " + this.timestampSetModel + ", new context: " + this.timestampSetModel);
            }
        }
        this.timestampSetModel = ActionTimestampModelProvider.Companion.preserveFragileTimestamps(actualSetModel, this.timestampSetModel);
        PatchEngine $i$f$trace = FrontendPatchEngineKt.getEngine(this.getSession());
        String description$iv = "Redoing call editor action " + this.frontendActionId;
        boolean $i$f$recordChanges = false;
        $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
        try {
            RdPatch rdPatch2;
            AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, null, null, (int)28, null);
            Throwable throwable = null;
            try {
                Object object;
                void $this$runAndLogException$iv$iv;
                RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                boolean bl5 = false;
                boolean $i$f$fileLogger22 = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger $i$f$fileLogger22 = logger;
                boolean $i$f$runAndLogException = false;
                void var16_25 = $this$runAndLogException$iv$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv$iv = var16_25;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ChangeScope $this$doRedo_u24lambda_u241 = it$iv.getSession().getChangeScope();
                    boolean bl4 = false;
                    ActionManager actionManager = ActionManager.getInstance();
                    AnAction anAction = actionManager.getAction(this.frontendActionId);
                    if (anAction == null) {
                        throw new IllegalStateException(("Not found action id: " + this.frontendActionId).toString());
                    }
                    AnAction action = anAction;
                    AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"keyboard shortcut", (DataContext)dataContext2);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    ActionUtil.performAction((AnAction)action, (AnActionEvent)actionEvent);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                rdPatch2 = it$iv.getSession().buildPatchAndClear();
            }
            catch (Throwable bl5) {
                try {
                    throwable = bl5;
                    throw bl5;
                }
                catch (Throwable bl5) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw bl5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            rdPatch = rdPatch2;
        }
        finally {
            if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                while ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                }
            }
        }
        RdPatch patchAfterRedo = rdPatch;
        return patchAfterRedo;
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        ActionTimestampSetModel timestampSetModel = ActionTimestampModelProvider.Companion.filterOutTransientTimestamps(this.timestampSetModel);
        String backendActionId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(this.frontendActionId);
        return (RdRequest)new RdCallEditorActionRequest(backendActionId, this.getEditorId(), this.getPatch(), timestampSetModel);
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call editor action=" + this.frontendActionId + " Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    @Override
    public void assertClientId() {
        ClientIdKt.assertClientIdConsistency$default((ClientId)new ClientId(this.getEditorId().getClientId()), (String)(this.debugDescription() + "::" + this.getEditorId().getDocumentId()), (boolean)false, (int)2, null);
    }
}

