/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.base;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.BackendDelegatingActionCustomization;
import com.jetbrains.rdclient.actions.base.BackendDelegatingActionKt;
import com.jetbrains.rdclient.actions.base.EditorActionHandlersCustomization;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateTrait;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionUpdateTrait;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\"\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionUpdateTrait;", "Lcom/jetbrains/rdclient/actions/base/FrontendActionUpdateTrait;", "frontendId", "", "baseHandler", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getFrontendId", "()Ljava/lang/String;", "getBaseHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "hasActivePatch", "executeOnFrontend", "backendIsEnabledForCaret", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorActionHandler.kt\ncom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n60#2,5:78\n60#2,5:83\n13#2:89\n1#3:88\n*S KotlinDebug\n*F\n+ 1 FrontendEditorActionHandler.kt\ncom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler\n*L\n53#1:78,5\n58#1:83,5\n42#1:89\n*E\n"})
public class FrontendEditorActionHandler
extends EditorActionHandler
implements FrontendEditorActionUpdateTrait,
FrontendActionUpdateTrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frontendId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private static final Logger logger;

    public FrontendEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        this.frontendId = frontendId;
        this.baseHandler = baseHandler;
    }

    @NotNull
    public final String getFrontendId() {
        return this.frontendId;
    }

    @NotNull
    public final EditorActionHandler getBaseHandler() {
        return this.baseHandler;
    }

    protected final boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean res = this.backendIsEnabledForCaret(editor, caret, dataContext);
        return res || this.baseHandler.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        boolean ret;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean bl = ret = this.backendIsEnabledForCaret(editor, caret, dataContext) && !this.hasActivePatch(dataContext);
        if (ret) {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Executing backend editor handler '" + this.frontendId + "'", t$iv);
            }
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
            AnActionEvent event = anActionEvent;
            BackendActionDelegationKt.backendActionPerformed(this.frontendId, event);
        } else {
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl3 = false;
                logger.debug("Executing frontend editor base handler '" + this.frontendId + "'", t$iv);
            }
            this.executeOnFrontend(editor, caret, dataContext);
        }
    }

    private final boolean hasActivePatch(DataContext dataContext) {
        ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
        return clientAppSession != null && (clientAppSession = FrontendPatchEngineKt.getEngine(clientAppSession)) != null ? clientAppSession.getHasActivePatch() : false;
    }

    protected void executeOnFrontend(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.baseHandler.execute(editor, caret, dataContext);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!EditorActionHandlersCustomization.Companion.getInstance().isEnabled()) {
            return false;
        }
        if (!FrontendEditorActionUpdateTrait.super.backendIsEnabledForCaret(editor, caret, dataContext)) {
            return false;
        }
        BackendDelegatingActionCustomization backendDelegatingActionCustomization = BackendDelegatingActionKt.findCustomization(dataContext, this.frontendId);
        if (backendDelegatingActionCustomization != null) {
            BackendDelegatingActionCustomization it = backendDelegatingActionCustomization;
            boolean bl = false;
            return FrontendActionUpdateTrait.frontendUpdate$default(it, this.frontendId, dataContext, null, "unknown", null, 16, null);
        }
        return FrontendActionUpdateTrait.super.frontendUpdate(this.frontendId, dataContext, null, "unknown", null);
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendEditorActionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendEditorActionHandler.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

